/*
 * Decompiled with CFR 0.152.
 */
package b3.entrypoint.fixp.sbe;

import b3.entrypoint.fixp.sbe.Boolean;
import b3.entrypoint.fixp.sbe.MessageHeaderEncoder;
import b3.entrypoint.fixp.sbe.MetaAttribute;
import b3.entrypoint.fixp.sbe.QuoteDecoder;
import b3.entrypoint.fixp.sbe.UTCTimestampNanosEncoder;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.sbe.MessageEncoderFlyweight;

public final class QuoteEncoder
implements MessageEncoderFlyweight {
    public static final int BLOCK_LENGTH = 52;
    public static final int TEMPLATE_ID = 403;
    public static final int SCHEMA_ID = 1;
    public static final int SCHEMA_VERSION = 5;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final QuoteEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    private static final byte[] SECURITYIDSOURCE_VALUE = new byte[]{56};
    private static final byte[] SECURITYEXCHANGE_VALUE = new byte[]{66, 86, 77, 70};
    private final UTCTimestampNanosEncoder transactTime = new UTCTimestampNanosEncoder();

    public int sbeBlockLength() {
        return 52;
    }

    public int sbeTemplateId() {
        return 403;
    }

    public int sbeSchemaId() {
        return 1;
    }

    public int sbeSchemaVersion() {
        return 5;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public QuoteEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.limit(offset + 52);
        return this;
    }

    public QuoteEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(52).templateId(403).schemaId(1).version(5);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int messageTypeId() {
        return 35;
    }

    public static int messageTypeSinceVersion() {
        return 0;
    }

    public static int messageTypeEncodingOffset() {
        return 0;
    }

    public static int messageTypeEncodingLength() {
        return 1;
    }

    public static String messageTypeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "constant";
        }
        return "";
    }

    public static int quoteReqIDId() {
        return 131;
    }

    public static int quoteReqIDSinceVersion() {
        return 0;
    }

    public static int quoteReqIDEncodingOffset() {
        return 0;
    }

    public static int quoteReqIDEncodingLength() {
        return 8;
    }

    public static String quoteReqIDMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long quoteReqIDNullValue() {
        return -1L;
    }

    public static long quoteReqIDMinValue() {
        return 0L;
    }

    public static long quoteReqIDMaxValue() {
        return -2L;
    }

    public QuoteEncoder quoteReqID(long value) {
        this.buffer.putLong(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int quoteIDId() {
        return 117;
    }

    public static int quoteIDSinceVersion() {
        return 0;
    }

    public static int quoteIDEncodingOffset() {
        return 8;
    }

    public static int quoteIDEncodingLength() {
        return 8;
    }

    public static String quoteIDMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long quoteIDNullValue() {
        return -1L;
    }

    public static long quoteIDMinValue() {
        return 0L;
    }

    public static long quoteIDMaxValue() {
        return -2L;
    }

    public QuoteEncoder quoteID(long value) {
        this.buffer.putLong(this.offset + 8, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int securityIDId() {
        return 48;
    }

    public static int securityIDSinceVersion() {
        return 0;
    }

    public static int securityIDEncodingOffset() {
        return 16;
    }

    public static int securityIDEncodingLength() {
        return 8;
    }

    public static String securityIDMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long securityIDNullValue() {
        return -1L;
    }

    public static long securityIDMinValue() {
        return 0L;
    }

    public static long securityIDMaxValue() {
        return -2L;
    }

    public QuoteEncoder securityID(long value) {
        this.buffer.putLong(this.offset + 16, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int securityIDSourceId() {
        return 22;
    }

    public static int securityIDSourceSinceVersion() {
        return 0;
    }

    public static int securityIDSourceEncodingOffset() {
        return 24;
    }

    public static int securityIDSourceEncodingLength() {
        return 0;
    }

    public static String securityIDSourceMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "constant";
        }
        return "";
    }

    public static byte securityIDSourceNullValue() {
        return 0;
    }

    public static byte securityIDSourceMinValue() {
        return 32;
    }

    public static byte securityIDSourceMaxValue() {
        return 126;
    }

    public static int securityIDSourceLength() {
        return 1;
    }

    public byte securityIDSource(int index) {
        return SECURITYIDSOURCE_VALUE[index];
    }

    public int getSecurityIDSource(byte[] dst, int offset, int length) {
        int bytesCopied = Math.min(length, 1);
        System.arraycopy(SECURITYIDSOURCE_VALUE, 0, dst, offset, bytesCopied);
        return bytesCopied;
    }

    public byte securityIDSource() {
        return 56;
    }

    public static int securityExchangeId() {
        return 207;
    }

    public static int securityExchangeSinceVersion() {
        return 0;
    }

    public static int securityExchangeEncodingOffset() {
        return 24;
    }

    public static int securityExchangeEncodingLength() {
        return 0;
    }

    public static String securityExchangeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "constant";
        }
        return "";
    }

    public static byte securityExchangeNullValue() {
        return 0;
    }

    public static byte securityExchangeMinValue() {
        return 32;
    }

    public static byte securityExchangeMaxValue() {
        return 126;
    }

    public static int securityExchangeLength() {
        return 4;
    }

    public byte securityExchange(int index) {
        return SECURITYEXCHANGE_VALUE[index];
    }

    public int getSecurityExchange(byte[] dst, int offset, int length) {
        int bytesCopied = Math.min(length, 4);
        System.arraycopy(SECURITYEXCHANGE_VALUE, 0, dst, offset, bytesCopied);
        return bytesCopied;
    }

    public String securityExchange() {
        return "BVMF";
    }

    public static int accountId() {
        return 1;
    }

    public static int accountSinceVersion() {
        return 0;
    }

    public static int accountEncodingOffset() {
        return 24;
    }

    public static int accountEncodingLength() {
        return 4;
    }

    public static String accountMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "optional";
        }
        return "";
    }

    public static long accountNullValue() {
        return 0L;
    }

    public static long accountMinValue() {
        return 0L;
    }

    public static long accountMaxValue() {
        return 0xFFFFFFFEL;
    }

    public QuoteEncoder account(long value) {
        this.buffer.putInt(this.offset + 24, (int)value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int transactTimeId() {
        return 60;
    }

    public static int transactTimeSinceVersion() {
        return 0;
    }

    public static int transactTimeEncodingOffset() {
        return 28;
    }

    public static int transactTimeEncodingLength() {
        return 8;
    }

    public static String transactTimeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public UTCTimestampNanosEncoder transactTime() {
        this.transactTime.wrap(this.buffer, this.offset + 28);
        return this.transactTime;
    }

    public static int senderLocationId() {
        return 35503;
    }

    public static int senderLocationSinceVersion() {
        return 0;
    }

    public static int senderLocationEncodingOffset() {
        return 36;
    }

    public static int senderLocationEncodingLength() {
        return 10;
    }

    public static String senderLocationMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static byte senderLocationNullValue() {
        return 0;
    }

    public static byte senderLocationMinValue() {
        return 32;
    }

    public static byte senderLocationMaxValue() {
        return 126;
    }

    public static int senderLocationLength() {
        return 10;
    }

    public QuoteEncoder senderLocation(int index, byte value) {
        if (index < 0 || index >= 10) {
            throw new IndexOutOfBoundsException("index out of range: index=" + index);
        }
        int pos = this.offset + 36 + index * 1;
        this.buffer.putByte(pos, value);
        return this;
    }

    public static String senderLocationCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public QuoteEncoder putSenderLocation(byte[] src, int srcOffset) {
        int length = 10;
        if (srcOffset < 0 || srcOffset > src.length - 10) {
            throw new IndexOutOfBoundsException("Copy will go out of range: offset=" + srcOffset);
        }
        this.buffer.putBytes(this.offset + 36, src, srcOffset, 10);
        return this;
    }

    public QuoteEncoder senderLocation(String src) {
        int srcLength;
        int length = 10;
        int n = srcLength = null == src ? 0 : src.length();
        if (srcLength > 10) {
            throw new IndexOutOfBoundsException("String too large for copy: byte length=" + srcLength);
        }
        this.buffer.putStringWithoutLengthAscii(this.offset + 36, src);
        for (int start = srcLength; start < 10; ++start) {
            this.buffer.putByte(this.offset + 36 + start, (byte)0);
        }
        return this;
    }

    public QuoteEncoder senderLocation(CharSequence src) {
        int srcLength;
        int length = 10;
        int n = srcLength = null == src ? 0 : src.length();
        if (srcLength > 10) {
            throw new IndexOutOfBoundsException("CharSequence too large for copy: byte length=" + srcLength);
        }
        this.buffer.putStringWithoutLengthAscii(this.offset + 36, src);
        for (int start = srcLength; start < 10; ++start) {
            this.buffer.putByte(this.offset + 36 + start, (byte)0);
        }
        return this;
    }

    public static int enteringTraderId() {
        return 35502;
    }

    public static int enteringTraderSinceVersion() {
        return 0;
    }

    public static int enteringTraderEncodingOffset() {
        return 46;
    }

    public static int enteringTraderEncodingLength() {
        return 5;
    }

    public static String enteringTraderMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static byte enteringTraderNullValue() {
        return 0;
    }

    public static byte enteringTraderMinValue() {
        return 32;
    }

    public static byte enteringTraderMaxValue() {
        return 126;
    }

    public static int enteringTraderLength() {
        return 5;
    }

    public QuoteEncoder enteringTrader(int index, byte value) {
        if (index < 0 || index >= 5) {
            throw new IndexOutOfBoundsException("index out of range: index=" + index);
        }
        int pos = this.offset + 46 + index * 1;
        this.buffer.putByte(pos, value);
        return this;
    }

    public static String enteringTraderCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public QuoteEncoder putEnteringTrader(byte[] src, int srcOffset) {
        int length = 5;
        if (srcOffset < 0 || srcOffset > src.length - 5) {
            throw new IndexOutOfBoundsException("Copy will go out of range: offset=" + srcOffset);
        }
        this.buffer.putBytes(this.offset + 46, src, srcOffset, 5);
        return this;
    }

    public QuoteEncoder enteringTrader(String src) {
        int srcLength;
        int length = 5;
        int n = srcLength = null == src ? 0 : src.length();
        if (srcLength > 5) {
            throw new IndexOutOfBoundsException("String too large for copy: byte length=" + srcLength);
        }
        this.buffer.putStringWithoutLengthAscii(this.offset + 46, src);
        for (int start = srcLength; start < 5; ++start) {
            this.buffer.putByte(this.offset + 46 + start, (byte)0);
        }
        return this;
    }

    public QuoteEncoder enteringTrader(CharSequence src) {
        int srcLength;
        int length = 5;
        int n = srcLength = null == src ? 0 : src.length();
        if (srcLength > 5) {
            throw new IndexOutOfBoundsException("CharSequence too large for copy: byte length=" + srcLength);
        }
        this.buffer.putStringWithoutLengthAscii(this.offset + 46, src);
        for (int start = srcLength; start < 5; ++start) {
            this.buffer.putByte(this.offset + 46 + start, (byte)0);
        }
        return this;
    }

    public static int privateQuoteId() {
        return 1171;
    }

    public static int privateQuoteSinceVersion() {
        return 0;
    }

    public static int privateQuoteEncodingOffset() {
        return 51;
    }

    public static int privateQuoteEncodingLength() {
        return 1;
    }

    public static String privateQuoteMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public QuoteEncoder privateQuote(Boolean value) {
        this.buffer.putByte(this.offset + 51, (byte)value.value());
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        QuoteDecoder decoder = new QuoteDecoder();
        decoder.wrap((DirectBuffer)this.buffer, this.initialOffset, 52, 5);
        return decoder.appendTo(builder);
    }
}

