/*
 * Decompiled with CFR 0.152.
 */
package b3.entrypoint.fixp.sbe;

import b3.entrypoint.fixp.sbe.DeltaInNanosDecoder;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.sbe.CompositeEncoderFlyweight;

public final class DeltaInNanosEncoder
implements CompositeEncoderFlyweight {
    public static final int SCHEMA_ID = 1;
    public static final int SCHEMA_VERSION = 5;
    public static final int ENCODED_LENGTH = 4;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private int offset;
    private MutableDirectBuffer buffer;

    public DeltaInNanosEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        return this;
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public int encodedLength() {
        return 4;
    }

    public int sbeSchemaId() {
        return 1;
    }

    public int sbeSchemaVersion() {
        return 5;
    }

    public static int timeEncodingOffset() {
        return 0;
    }

    public static int timeEncodingLength() {
        return 4;
    }

    public static long timeNullValue() {
        return 0xFFFFFFFFL;
    }

    public static long timeMinValue() {
        return 0L;
    }

    public static long timeMaxValue() {
        return 0xFFFFFFFEL;
    }

    public DeltaInNanosEncoder time(long value) {
        this.buffer.putInt(this.offset + 0, (int)value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int unitEncodingOffset() {
        return 4;
    }

    public static int unitEncodingLength() {
        return 0;
    }

    public static short unitNullValue() {
        return 255;
    }

    public static short unitMinValue() {
        return 0;
    }

    public static short unitMaxValue() {
        return 254;
    }

    public short unit() {
        return 9;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        DeltaInNanosDecoder decoder = new DeltaInNanosDecoder();
        decoder.wrap((DirectBuffer)this.buffer, this.offset);
        return decoder.appendTo(builder);
    }
}

