/*
 * Decompiled with CFR 0.152.
 */
package b3.entrypoint.fixp.sbe;

import b3.entrypoint.fixp.sbe.Boolean;
import b3.entrypoint.fixp.sbe.ExecuteUnderlyingTrade;
import b3.entrypoint.fixp.sbe.MessageHeaderEncoder;
import b3.entrypoint.fixp.sbe.MetaAttribute;
import b3.entrypoint.fixp.sbe.PercentageEncoder;
import b3.entrypoint.fixp.sbe.PriceEncoder;
import b3.entrypoint.fixp.sbe.QuoteRequestDecoder;
import b3.entrypoint.fixp.sbe.SettlType;
import b3.entrypoint.fixp.sbe.Side;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.NoSuchElementException;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.ArrayUtil;
import org.agrona.sbe.MessageEncoderFlyweight;

public final class QuoteRequestEncoder
implements MessageEncoderFlyweight {
    public static final int BLOCK_LENGTH = 79;
    public static final int TEMPLATE_ID = 401;
    public static final int SCHEMA_ID = 1;
    public static final int SCHEMA_VERSION = 5;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final QuoteRequestEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    private static final byte[] SECURITYIDSOURCE_VALUE = new byte[]{56};
    private static final byte[] SECURITYEXCHANGE_VALUE = new byte[]{66, 86, 77, 70};
    private final PercentageEncoder fixedRate = new PercentageEncoder();
    private final PriceEncoder price = new PriceEncoder();
    private final NoSidesEncoder noSides = new NoSidesEncoder(this);

    public int sbeBlockLength() {
        return 79;
    }

    public int sbeTemplateId() {
        return 401;
    }

    public int sbeSchemaId() {
        return 1;
    }

    public int sbeSchemaVersion() {
        return 5;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public QuoteRequestEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.limit(offset + 79);
        return this;
    }

    public QuoteRequestEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(79).templateId(401).schemaId(1).version(5);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int messageTypeId() {
        return 35;
    }

    public static int messageTypeSinceVersion() {
        return 0;
    }

    public static int messageTypeEncodingOffset() {
        return 0;
    }

    public static int messageTypeEncodingLength() {
        return 1;
    }

    public static String messageTypeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "constant";
        }
        return "";
    }

    public static int quoteReqIDId() {
        return 131;
    }

    public static int quoteReqIDSinceVersion() {
        return 0;
    }

    public static int quoteReqIDEncodingOffset() {
        return 0;
    }

    public static int quoteReqIDEncodingLength() {
        return 8;
    }

    public static String quoteReqIDMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long quoteReqIDNullValue() {
        return -1L;
    }

    public static long quoteReqIDMinValue() {
        return 0L;
    }

    public static long quoteReqIDMaxValue() {
        return -2L;
    }

    public QuoteRequestEncoder quoteReqID(long value) {
        this.buffer.putLong(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int quoteIDId() {
        return 117;
    }

    public static int quoteIDSinceVersion() {
        return 0;
    }

    public static int quoteIDEncodingOffset() {
        return 8;
    }

    public static int quoteIDEncodingLength() {
        return 8;
    }

    public static String quoteIDMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "optional";
        }
        return "";
    }

    public static long quoteIDNullValue() {
        return 0L;
    }

    public static long quoteIDMinValue() {
        return 0L;
    }

    public static long quoteIDMaxValue() {
        return -2L;
    }

    public QuoteRequestEncoder quoteID(long value) {
        this.buffer.putLong(this.offset + 8, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int securityIDId() {
        return 48;
    }

    public static int securityIDSinceVersion() {
        return 0;
    }

    public static int securityIDEncodingOffset() {
        return 16;
    }

    public static int securityIDEncodingLength() {
        return 8;
    }

    public static String securityIDMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long securityIDNullValue() {
        return -1L;
    }

    public static long securityIDMinValue() {
        return 0L;
    }

    public static long securityIDMaxValue() {
        return -2L;
    }

    public QuoteRequestEncoder securityID(long value) {
        this.buffer.putLong(this.offset + 16, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int securityIDSourceId() {
        return 22;
    }

    public static int securityIDSourceSinceVersion() {
        return 0;
    }

    public static int securityIDSourceEncodingOffset() {
        return 24;
    }

    public static int securityIDSourceEncodingLength() {
        return 0;
    }

    public static String securityIDSourceMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "constant";
        }
        return "";
    }

    public static byte securityIDSourceNullValue() {
        return 0;
    }

    public static byte securityIDSourceMinValue() {
        return 32;
    }

    public static byte securityIDSourceMaxValue() {
        return 126;
    }

    public static int securityIDSourceLength() {
        return 1;
    }

    public byte securityIDSource(int index) {
        return SECURITYIDSOURCE_VALUE[index];
    }

    public int getSecurityIDSource(byte[] dst, int offset, int length) {
        int bytesCopied = Math.min(length, 1);
        System.arraycopy(SECURITYIDSOURCE_VALUE, 0, dst, offset, bytesCopied);
        return bytesCopied;
    }

    public byte securityIDSource() {
        return 56;
    }

    public static int securityExchangeId() {
        return 207;
    }

    public static int securityExchangeSinceVersion() {
        return 0;
    }

    public static int securityExchangeEncodingOffset() {
        return 24;
    }

    public static int securityExchangeEncodingLength() {
        return 0;
    }

    public static String securityExchangeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "constant";
        }
        return "";
    }

    public static byte securityExchangeNullValue() {
        return 0;
    }

    public static byte securityExchangeMinValue() {
        return 32;
    }

    public static byte securityExchangeMaxValue() {
        return 126;
    }

    public static int securityExchangeLength() {
        return 4;
    }

    public byte securityExchange(int index) {
        return SECURITYEXCHANGE_VALUE[index];
    }

    public int getSecurityExchange(byte[] dst, int offset, int length) {
        int bytesCopied = Math.min(length, 4);
        System.arraycopy(SECURITYEXCHANGE_VALUE, 0, dst, offset, bytesCopied);
        return bytesCopied;
    }

    public String securityExchange() {
        return "BVMF";
    }

    public static int orderQtyId() {
        return 38;
    }

    public static int orderQtySinceVersion() {
        return 0;
    }

    public static int orderQtyEncodingOffset() {
        return 24;
    }

    public static int orderQtyEncodingLength() {
        return 8;
    }

    public static String orderQtyMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long orderQtyNullValue() {
        return -1L;
    }

    public static long orderQtyMinValue() {
        return 0L;
    }

    public static long orderQtyMaxValue() {
        return -2L;
    }

    public QuoteRequestEncoder orderQty(long value) {
        this.buffer.putLong(this.offset + 24, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int uniqueTradeIDId() {
        return 6032;
    }

    public static int uniqueTradeIDSinceVersion() {
        return 0;
    }

    public static int uniqueTradeIDEncodingOffset() {
        return 32;
    }

    public static int uniqueTradeIDEncodingLength() {
        return 4;
    }

    public static String uniqueTradeIDMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "optional";
        }
        return "";
    }

    public static long uniqueTradeIDNullValue() {
        return 0L;
    }

    public static long uniqueTradeIDMinValue() {
        return 0L;
    }

    public static long uniqueTradeIDMaxValue() {
        return 0xFFFFFFFEL;
    }

    public QuoteRequestEncoder uniqueTradeID(long value) {
        this.buffer.putInt(this.offset + 32, (int)value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int fixedRateId() {
        return 5706;
    }

    public static int fixedRateSinceVersion() {
        return 0;
    }

    public static int fixedRateEncodingOffset() {
        return 36;
    }

    public static int fixedRateEncodingLength() {
        return 8;
    }

    public static String fixedRateMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public PercentageEncoder fixedRate() {
        this.fixedRate.wrap(this.buffer, this.offset + 36);
        return this.fixedRate;
    }

    public static int priceId() {
        return 44;
    }

    public static int priceSinceVersion() {
        return 0;
    }

    public static int priceEncodingOffset() {
        return 44;
    }

    public static int priceEncodingLength() {
        return 8;
    }

    public static String priceMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public PriceEncoder price() {
        this.price.wrap(this.buffer, this.offset + 44);
        return this.price;
    }

    public static int daysToSettlementId() {
        return 5497;
    }

    public static int daysToSettlementSinceVersion() {
        return 0;
    }

    public static int daysToSettlementEncodingOffset() {
        return 52;
    }

    public static int daysToSettlementEncodingLength() {
        return 2;
    }

    public static String daysToSettlementMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "optional";
        }
        return "";
    }

    public static int daysToSettlementNullValue() {
        return 65535;
    }

    public static int daysToSettlementMinValue() {
        return 0;
    }

    public static int daysToSettlementMaxValue() {
        return 65534;
    }

    public QuoteRequestEncoder daysToSettlement(int value) {
        this.buffer.putShort(this.offset + 52, (short)value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int privateQuoteId() {
        return 1171;
    }

    public static int privateQuoteSinceVersion() {
        return 0;
    }

    public static int privateQuoteEncodingOffset() {
        return 54;
    }

    public static int privateQuoteEncodingLength() {
        return 1;
    }

    public static String privateQuoteMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public QuoteRequestEncoder privateQuote(Boolean value) {
        this.buffer.putByte(this.offset + 54, (byte)value.value());
        return this;
    }

    public static int settlTypeId() {
        return 63;
    }

    public static int settlTypeSinceVersion() {
        return 0;
    }

    public static int settlTypeEncodingOffset() {
        return 55;
    }

    public static int settlTypeEncodingLength() {
        return 1;
    }

    public static String settlTypeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public QuoteRequestEncoder settlType(SettlType value) {
        this.buffer.putByte(this.offset + 55, value.value());
        return this;
    }

    public static int executeUnderlyingTradeId() {
        return 35004;
    }

    public static int executeUnderlyingTradeSinceVersion() {
        return 0;
    }

    public static int executeUnderlyingTradeEncodingOffset() {
        return 56;
    }

    public static int executeUnderlyingTradeEncodingLength() {
        return 1;
    }

    public static String executeUnderlyingTradeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "optional";
        }
        return "";
    }

    public QuoteRequestEncoder executeUnderlyingTrade(ExecuteUnderlyingTrade value) {
        this.buffer.putByte(this.offset + 56, value.value());
        return this;
    }

    public static int contraBrokerId() {
        return 375;
    }

    public static int contraBrokerSinceVersion() {
        return 0;
    }

    public static int contraBrokerEncodingOffset() {
        return 60;
    }

    public static int contraBrokerEncodingLength() {
        return 4;
    }

    public static String contraBrokerMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "optional";
        }
        return "";
    }

    public static long contraBrokerNullValue() {
        return 0L;
    }

    public static long contraBrokerMinValue() {
        return 0L;
    }

    public static long contraBrokerMaxValue() {
        return 0xFFFFFFFEL;
    }

    public QuoteRequestEncoder contraBroker(long value) {
        this.buffer.putInt(this.offset + 60, (int)value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int senderLocationId() {
        return 35503;
    }

    public static int senderLocationSinceVersion() {
        return 0;
    }

    public static int senderLocationEncodingOffset() {
        return 64;
    }

    public static int senderLocationEncodingLength() {
        return 10;
    }

    public static String senderLocationMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static byte senderLocationNullValue() {
        return 0;
    }

    public static byte senderLocationMinValue() {
        return 32;
    }

    public static byte senderLocationMaxValue() {
        return 126;
    }

    public static int senderLocationLength() {
        return 10;
    }

    public QuoteRequestEncoder senderLocation(int index, byte value) {
        if (index < 0 || index >= 10) {
            throw new IndexOutOfBoundsException("index out of range: index=" + index);
        }
        int pos = this.offset + 64 + index * 1;
        this.buffer.putByte(pos, value);
        return this;
    }

    public static String senderLocationCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public QuoteRequestEncoder putSenderLocation(byte[] src, int srcOffset) {
        int length = 10;
        if (srcOffset < 0 || srcOffset > src.length - 10) {
            throw new IndexOutOfBoundsException("Copy will go out of range: offset=" + srcOffset);
        }
        this.buffer.putBytes(this.offset + 64, src, srcOffset, 10);
        return this;
    }

    public QuoteRequestEncoder senderLocation(String src) {
        int srcLength;
        int length = 10;
        int n = srcLength = null == src ? 0 : src.length();
        if (srcLength > 10) {
            throw new IndexOutOfBoundsException("String too large for copy: byte length=" + srcLength);
        }
        this.buffer.putStringWithoutLengthAscii(this.offset + 64, src);
        for (int start = srcLength; start < 10; ++start) {
            this.buffer.putByte(this.offset + 64 + start, (byte)0);
        }
        return this;
    }

    public QuoteRequestEncoder senderLocation(CharSequence src) {
        int srcLength;
        int length = 10;
        int n = srcLength = null == src ? 0 : src.length();
        if (srcLength > 10) {
            throw new IndexOutOfBoundsException("CharSequence too large for copy: byte length=" + srcLength);
        }
        this.buffer.putStringWithoutLengthAscii(this.offset + 64, src);
        for (int start = srcLength; start < 10; ++start) {
            this.buffer.putByte(this.offset + 64 + start, (byte)0);
        }
        return this;
    }

    public static int enteringTraderId() {
        return 35502;
    }

    public static int enteringTraderSinceVersion() {
        return 0;
    }

    public static int enteringTraderEncodingOffset() {
        return 74;
    }

    public static int enteringTraderEncodingLength() {
        return 5;
    }

    public static String enteringTraderMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static byte enteringTraderNullValue() {
        return 0;
    }

    public static byte enteringTraderMinValue() {
        return 32;
    }

    public static byte enteringTraderMaxValue() {
        return 126;
    }

    public static int enteringTraderLength() {
        return 5;
    }

    public QuoteRequestEncoder enteringTrader(int index, byte value) {
        if (index < 0 || index >= 5) {
            throw new IndexOutOfBoundsException("index out of range: index=" + index);
        }
        int pos = this.offset + 74 + index * 1;
        this.buffer.putByte(pos, value);
        return this;
    }

    public static String enteringTraderCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public QuoteRequestEncoder putEnteringTrader(byte[] src, int srcOffset) {
        int length = 5;
        if (srcOffset < 0 || srcOffset > src.length - 5) {
            throw new IndexOutOfBoundsException("Copy will go out of range: offset=" + srcOffset);
        }
        this.buffer.putBytes(this.offset + 74, src, srcOffset, 5);
        return this;
    }

    public QuoteRequestEncoder enteringTrader(String src) {
        int srcLength;
        int length = 5;
        int n = srcLength = null == src ? 0 : src.length();
        if (srcLength > 5) {
            throw new IndexOutOfBoundsException("String too large for copy: byte length=" + srcLength);
        }
        this.buffer.putStringWithoutLengthAscii(this.offset + 74, src);
        for (int start = srcLength; start < 5; ++start) {
            this.buffer.putByte(this.offset + 74 + start, (byte)0);
        }
        return this;
    }

    public QuoteRequestEncoder enteringTrader(CharSequence src) {
        int srcLength;
        int length = 5;
        int n = srcLength = null == src ? 0 : src.length();
        if (srcLength > 5) {
            throw new IndexOutOfBoundsException("CharSequence too large for copy: byte length=" + srcLength);
        }
        this.buffer.putStringWithoutLengthAscii(this.offset + 74, src);
        for (int start = srcLength; start < 5; ++start) {
            this.buffer.putByte(this.offset + 74 + start, (byte)0);
        }
        return this;
    }

    public static long noSidesId() {
        return 552L;
    }

    public NoSidesEncoder noSidesCount(int count) {
        this.noSides.wrap(this.buffer, count);
        return this.noSides;
    }

    public static int deskIDId() {
        return 35510;
    }

    public static String deskIDCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public static String deskIDMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        if (MetaAttribute.SEMANTIC_TYPE == metaAttribute) {
            return "String";
        }
        return "";
    }

    public static int deskIDHeaderLength() {
        return 1;
    }

    public QuoteRequestEncoder putDeskID(DirectBuffer src, int srcOffset, int length) {
        if (length > 20) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        this.buffer.putByte(limit, (byte)length);
        this.buffer.putBytes(limit + 1, src, srcOffset, length);
        return this;
    }

    public QuoteRequestEncoder putDeskID(byte[] src, int srcOffset, int length) {
        if (length > 20) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        this.buffer.putByte(limit, (byte)length);
        this.buffer.putBytes(limit + 1, src, srcOffset, length);
        return this;
    }

    public QuoteRequestEncoder deskID(String value) {
        int length;
        int n = length = null == value ? 0 : value.length();
        if (length > 20) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        this.buffer.putByte(limit, (byte)length);
        this.buffer.putStringWithoutLengthAscii(limit + 1, value);
        return this;
    }

    public QuoteRequestEncoder deskID(CharSequence value) {
        int length;
        int n = length = null == value ? 0 : value.length();
        if (length > 20) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        this.buffer.putByte(limit, (byte)length);
        this.buffer.putStringWithoutLengthAscii(limit + 1, value);
        return this;
    }

    public static int memoId() {
        return 5149;
    }

    public static String memoCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String memoMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        if (MetaAttribute.SEMANTIC_TYPE == metaAttribute) {
            return "String";
        }
        return "";
    }

    public static int memoHeaderLength() {
        return 1;
    }

    public QuoteRequestEncoder putMemo(DirectBuffer src, int srcOffset, int length) {
        if (length > 40) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        this.buffer.putByte(limit, (byte)length);
        this.buffer.putBytes(limit + 1, src, srcOffset, length);
        return this;
    }

    public QuoteRequestEncoder putMemo(byte[] src, int srcOffset, int length) {
        if (length > 40) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        this.buffer.putByte(limit, (byte)length);
        this.buffer.putBytes(limit + 1, src, srcOffset, length);
        return this;
    }

    public QuoteRequestEncoder memo(String value) {
        byte[] bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(StandardCharsets.UTF_8);
        int length = bytes.length;
        if (length > 40) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        this.buffer.putByte(limit, (byte)length);
        this.buffer.putBytes(limit + 1, bytes, 0, length);
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        QuoteRequestDecoder decoder = new QuoteRequestDecoder();
        decoder.wrap((DirectBuffer)this.buffer, this.initialOffset, 79, 5);
        return decoder.appendTo(builder);
    }

    public static final class NoSidesEncoder {
        public static final int HEADER_SIZE = 3;
        private final QuoteRequestEncoder parentMessage;
        private MutableDirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int initialLimit;

        NoSidesEncoder(QuoteRequestEncoder parentMessage) {
            this.parentMessage = parentMessage;
        }

        public void wrap(MutableDirectBuffer buffer, int count) {
            int limit;
            if (count < 0 || count > 254) {
                throw new IllegalArgumentException("count outside allowed range: count=" + count);
            }
            if (buffer != this.buffer) {
                this.buffer = buffer;
            }
            this.index = 0;
            this.count = count;
            this.initialLimit = limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 3);
            buffer.putShort(limit + 0, (short)5, ByteOrder.LITTLE_ENDIAN);
            buffer.putByte(limit + 2, (byte)count);
        }

        public NoSidesEncoder next() {
            if (this.index >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + NoSidesEncoder.sbeBlockLength());
            ++this.index;
            return this;
        }

        public int resetCountToIndex() {
            this.count = this.index;
            this.buffer.putByte(this.initialLimit + 2, (byte)this.count);
            return this.count;
        }

        public static short countMinValue() {
            return 0;
        }

        public static short countMaxValue() {
            return 254;
        }

        public static int sbeHeaderSize() {
            return 3;
        }

        public static int sbeBlockLength() {
            return 5;
        }

        public static int sideId() {
            return 54;
        }

        public static int sideSinceVersion() {
            return 0;
        }

        public static int sideEncodingOffset() {
            return 0;
        }

        public static int sideEncodingLength() {
            return 1;
        }

        public static String sideMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public NoSidesEncoder side(Side value) {
            this.buffer.putByte(this.offset + 0, value.value());
            return this;
        }

        public static int accountId() {
            return 1;
        }

        public static int accountSinceVersion() {
            return 0;
        }

        public static int accountEncodingOffset() {
            return 1;
        }

        public static int accountEncodingLength() {
            return 4;
        }

        public static String accountMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "optional";
            }
            return "";
        }

        public static long accountNullValue() {
            return 0L;
        }

        public static long accountMinValue() {
            return 0L;
        }

        public static long accountMaxValue() {
            return 0xFFFFFFFEL;
        }

        public NoSidesEncoder account(long value) {
            this.buffer.putInt(this.offset + 1, (int)value, ByteOrder.LITTLE_ENDIAN);
            return this;
        }
    }
}

