/*
 * Decompiled with CFR 0.152.
 */
package b3.entrypoint.fixp.sbe;

import b3.entrypoint.fixp.sbe.AllocationInstructionDecoder;
import b3.entrypoint.fixp.sbe.MessageHeaderEncoder;
import b3.entrypoint.fixp.sbe.MetaAttribute;
import b3.entrypoint.fixp.sbe.Side;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.NoSuchElementException;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.ArrayUtil;
import org.agrona.sbe.MessageEncoderFlyweight;

public final class AllocationInstructionEncoder
implements MessageEncoderFlyweight {
    public static final int BLOCK_LENGTH = 5;
    public static final int TEMPLATE_ID = 601;
    public static final int SCHEMA_ID = 1;
    public static final int SCHEMA_VERSION = 0;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final AllocationInstructionEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    private final NoExecsEncoder noExecs = new NoExecsEncoder(this);
    private final NoAllocsEncoder noAllocs = new NoAllocsEncoder(this);

    public int sbeBlockLength() {
        return 5;
    }

    public int sbeTemplateId() {
        return 601;
    }

    public int sbeSchemaId() {
        return 1;
    }

    public int sbeSchemaVersion() {
        return 0;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public AllocationInstructionEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.limit(offset + 5);
        return this;
    }

    public AllocationInstructionEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(5).templateId(601).schemaId(1).version(0);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int sideId() {
        return 54;
    }

    public static int sideSinceVersion() {
        return 0;
    }

    public static int sideEncodingOffset() {
        return 0;
    }

    public static int sideEncodingLength() {
        return 1;
    }

    public static String sideMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public AllocationInstructionEncoder side(Side value) {
        this.buffer.putByte(this.offset + 0, value.value());
        return this;
    }

    public static int tradeDateId() {
        return 75;
    }

    public static int tradeDateSinceVersion() {
        return 0;
    }

    public static int tradeDateEncodingOffset() {
        return 1;
    }

    public static int tradeDateEncodingLength() {
        return 4;
    }

    public static String tradeDateMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "optional";
        }
        return "";
    }

    public static int tradeDateNullValue() {
        return 0;
    }

    public static int tradeDateMinValue() {
        return 0;
    }

    public static int tradeDateMaxValue() {
        return 65534;
    }

    public static int tradeDateLength() {
        return 2;
    }

    public AllocationInstructionEncoder tradeDate(int index, int value) {
        if (index < 0 || index >= 2) {
            throw new IndexOutOfBoundsException("index out of range: index=" + index);
        }
        int pos = this.offset + 1 + index * 2;
        this.buffer.putShort(pos, (short)value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public AllocationInstructionEncoder putTradeDate(int value0, int value1) {
        this.buffer.putShort(this.offset + 1, (short)value0, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putShort(this.offset + 3, (short)value1, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static long noExecsId() {
        return 13L;
    }

    public NoExecsEncoder noExecsCount(int count) {
        this.noExecs.wrap(this.buffer, count);
        return this.noExecs;
    }

    public static long noAllocsId() {
        return 15L;
    }

    public NoAllocsEncoder noAllocsCount(int count) {
        this.noAllocs.wrap(this.buffer, count);
        return this.noAllocs;
    }

    public static int deskIDId() {
        return 35510;
    }

    public static String deskIDCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public static String deskIDMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int deskIDHeaderLength() {
        return 1;
    }

    public AllocationInstructionEncoder putDeskID(DirectBuffer src, int srcOffset, int length) {
        if (length > 20) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        this.buffer.putByte(limit, (byte)length);
        this.buffer.putBytes(limit + 1, src, srcOffset, length);
        return this;
    }

    public AllocationInstructionEncoder putDeskID(byte[] src, int srcOffset, int length) {
        if (length > 20) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        this.buffer.putByte(limit, (byte)length);
        this.buffer.putBytes(limit + 1, src, srcOffset, length);
        return this;
    }

    public AllocationInstructionEncoder deskID(String value) {
        int length;
        int n = length = null == value ? 0 : value.length();
        if (length > 20) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        this.buffer.putByte(limit, (byte)length);
        this.buffer.putStringWithoutLengthAscii(limit + 1, value);
        return this;
    }

    public AllocationInstructionEncoder deskID(CharSequence value) {
        int length;
        int n = length = null == value ? 0 : value.length();
        if (length > 20) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        this.buffer.putByte(limit, (byte)length);
        this.buffer.putStringWithoutLengthAscii(limit + 1, value);
        return this;
    }

    public static int memoId() {
        return 5149;
    }

    public static String memoCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String memoMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int memoHeaderLength() {
        return 1;
    }

    public AllocationInstructionEncoder putMemo(DirectBuffer src, int srcOffset, int length) {
        if (length > 40) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        this.buffer.putByte(limit, (byte)length);
        this.buffer.putBytes(limit + 1, src, srcOffset, length);
        return this;
    }

    public AllocationInstructionEncoder putMemo(byte[] src, int srcOffset, int length) {
        if (length > 40) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        this.buffer.putByte(limit, (byte)length);
        this.buffer.putBytes(limit + 1, src, srcOffset, length);
        return this;
    }

    public AllocationInstructionEncoder memo(String value) {
        byte[] bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(StandardCharsets.UTF_8);
        int length = bytes.length;
        if (length > 40) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        boolean headerLength = true;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 1 + length);
        this.buffer.putByte(limit, (byte)length);
        this.buffer.putBytes(limit + 1, bytes, 0, length);
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        AllocationInstructionDecoder decoder = new AllocationInstructionDecoder();
        decoder.wrap((DirectBuffer)this.buffer, this.initialOffset, 5, 0);
        return decoder.appendTo(builder);
    }

    public static final class NoAllocsEncoder {
        public static final int HEADER_SIZE = 3;
        private final AllocationInstructionEncoder parentMessage;
        private MutableDirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int initialLimit;

        NoAllocsEncoder(AllocationInstructionEncoder parentMessage) {
            this.parentMessage = parentMessage;
        }

        public void wrap(MutableDirectBuffer buffer, int count) {
            int limit;
            if (count < 0 || count > 254) {
                throw new IllegalArgumentException("count outside allowed range: count=" + count);
            }
            if (buffer != this.buffer) {
                this.buffer = buffer;
            }
            this.index = 0;
            this.count = count;
            this.initialLimit = limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 3);
            buffer.putShort(limit + 0, (short)0, ByteOrder.LITTLE_ENDIAN);
            buffer.putByte(limit + 2, (byte)count);
        }

        public NoAllocsEncoder next() {
            if (this.index >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + NoAllocsEncoder.sbeBlockLength());
            ++this.index;
            return this;
        }

        public int resetCountToIndex() {
            this.count = this.index;
            this.buffer.putByte(this.initialLimit + 2, (byte)this.count);
            return this.count;
        }

        public static short countMinValue() {
            return 0;
        }

        public static short countMaxValue() {
            return 254;
        }

        public static int sbeHeaderSize() {
            return 3;
        }

        public static int sbeBlockLength() {
            return 0;
        }
    }

    public static final class NoExecsEncoder {
        public static final int HEADER_SIZE = 3;
        private final AllocationInstructionEncoder parentMessage;
        private MutableDirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int initialLimit;

        NoExecsEncoder(AllocationInstructionEncoder parentMessage) {
            this.parentMessage = parentMessage;
        }

        public void wrap(MutableDirectBuffer buffer, int count) {
            int limit;
            if (count < 0 || count > 254) {
                throw new IllegalArgumentException("count outside allowed range: count=" + count);
            }
            if (buffer != this.buffer) {
                this.buffer = buffer;
            }
            this.index = 0;
            this.count = count;
            this.initialLimit = limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 3);
            buffer.putShort(limit + 0, (short)0, ByteOrder.LITTLE_ENDIAN);
            buffer.putByte(limit + 2, (byte)count);
        }

        public NoExecsEncoder next() {
            if (this.index >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + NoExecsEncoder.sbeBlockLength());
            ++this.index;
            return this;
        }

        public int resetCountToIndex() {
            this.count = this.index;
            this.buffer.putByte(this.initialLimit + 2, (byte)this.count);
            return this.count;
        }

        public static short countMinValue() {
            return 0;
        }

        public static short countMaxValue() {
            return 254;
        }

        public static int sbeHeaderSize() {
            return 3;
        }

        public static int sbeBlockLength() {
            return 0;
        }
    }
}

