/*
 * Decompiled with CFR 0.152.
 */
package b3.entrypoint.fixp.sbe;

import b3.entrypoint.fixp.sbe.MessageHeaderDecoder;
import b3.entrypoint.fixp.sbe.MessageType;
import b3.entrypoint.fixp.sbe.MetaAttribute;
import b3.entrypoint.fixp.sbe.PriceDecoder;
import b3.entrypoint.fixp.sbe.Side;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.agrona.DirectBuffer;
import org.agrona.sbe.MessageDecoderFlyweight;

public final class NewOrderCrossDecoder
implements MessageDecoderFlyweight {
    public static final int BLOCK_LENGTH = 46;
    public static final int TEMPLATE_ID = 106;
    public static final int SCHEMA_ID = 1;
    public static final int SCHEMA_VERSION = 0;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final NewOrderCrossDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;
    private static final byte[] SECURITYIDSOURCE_VALUE = new byte[]{56};
    private static final byte[] SECURITYEXCHANGE_VALUE = new byte[]{66, 86, 77, 70};
    private final PriceDecoder price = new PriceDecoder();
    private final NoSidesDecoder noSides = new NoSidesDecoder(this);

    public int sbeBlockLength() {
        return 46;
    }

    public int sbeTemplateId() {
        return 106;
    }

    public int sbeSchemaId() {
        return 1;
    }

    public int sbeSchemaVersion() {
        return 0;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public NewOrderCrossDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public NewOrderCrossDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (106 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public NewOrderCrossDecoder sbeRewind() {
        return this.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
    }

    public int sbeDecodedLength() {
        int currentLimit = this.limit();
        this.sbeSkip();
        int decodedLength = this.encodedLength();
        this.limit(currentLimit);
        return decodedLength;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int messageTypeId() {
        return 35;
    }

    public static int messageTypeSinceVersion() {
        return 0;
    }

    public static int messageTypeEncodingOffset() {
        return 0;
    }

    public static int messageTypeEncodingLength() {
        return 1;
    }

    public static String messageTypeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "constant";
        }
        return "";
    }

    public short messageTypeRaw() {
        return MessageType.NewOrderCross.value();
    }

    public MessageType messageType() {
        return MessageType.NewOrderCross;
    }

    public static int crossIDId() {
        return 548;
    }

    public static int crossIDSinceVersion() {
        return 0;
    }

    public static int crossIDEncodingOffset() {
        return 0;
    }

    public static int crossIDEncodingLength() {
        return 8;
    }

    public static String crossIDMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long crossIDNullValue() {
        return -1L;
    }

    public static long crossIDMinValue() {
        return 0L;
    }

    public static long crossIDMaxValue() {
        return -2L;
    }

    public long crossID() {
        return this.buffer.getLong(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
    }

    public static int securityIDId() {
        return 48;
    }

    public static int securityIDSinceVersion() {
        return 0;
    }

    public static int securityIDEncodingOffset() {
        return 8;
    }

    public static int securityIDEncodingLength() {
        return 8;
    }

    public static String securityIDMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long securityIDNullValue() {
        return -1L;
    }

    public static long securityIDMinValue() {
        return 0L;
    }

    public static long securityIDMaxValue() {
        return -2L;
    }

    public long securityID() {
        return this.buffer.getLong(this.offset + 8, ByteOrder.LITTLE_ENDIAN);
    }

    public static int securityIDSourceId() {
        return 22;
    }

    public static int securityIDSourceSinceVersion() {
        return 0;
    }

    public static int securityIDSourceEncodingOffset() {
        return 16;
    }

    public static int securityIDSourceEncodingLength() {
        return 0;
    }

    public static String securityIDSourceMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "constant";
        }
        return "";
    }

    public static byte securityIDSourceNullValue() {
        return 0;
    }

    public static byte securityIDSourceMinValue() {
        return 32;
    }

    public static byte securityIDSourceMaxValue() {
        return 126;
    }

    public static int securityIDSourceLength() {
        return 1;
    }

    public byte securityIDSource(int index) {
        return SECURITYIDSOURCE_VALUE[index];
    }

    public int getSecurityIDSource(byte[] dst, int offset, int length) {
        int bytesCopied = Math.min(length, 1);
        System.arraycopy(SECURITYIDSOURCE_VALUE, 0, dst, offset, bytesCopied);
        return bytesCopied;
    }

    public byte securityIDSource() {
        return 56;
    }

    public static int securityExchangeId() {
        return 207;
    }

    public static int securityExchangeSinceVersion() {
        return 0;
    }

    public static int securityExchangeEncodingOffset() {
        return 16;
    }

    public static int securityExchangeEncodingLength() {
        return 0;
    }

    public static String securityExchangeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "constant";
        }
        return "";
    }

    public static byte securityExchangeNullValue() {
        return 0;
    }

    public static byte securityExchangeMinValue() {
        return 32;
    }

    public static byte securityExchangeMaxValue() {
        return 126;
    }

    public static int securityExchangeLength() {
        return 4;
    }

    public byte securityExchange(int index) {
        return SECURITYEXCHANGE_VALUE[index];
    }

    public int getSecurityExchange(byte[] dst, int offset, int length) {
        int bytesCopied = Math.min(length, 4);
        System.arraycopy(SECURITYEXCHANGE_VALUE, 0, dst, offset, bytesCopied);
        return bytesCopied;
    }

    public String securityExchange() {
        return "BVMF";
    }

    public static int priceId() {
        return 44;
    }

    public static int priceSinceVersion() {
        return 0;
    }

    public static int priceEncodingOffset() {
        return 16;
    }

    public static int priceEncodingLength() {
        return 8;
    }

    public static String priceMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public PriceDecoder price() {
        this.price.wrap(this.buffer, this.offset + 16);
        return this.price;
    }

    public static int orderQtyId() {
        return 38;
    }

    public static int orderQtySinceVersion() {
        return 0;
    }

    public static int orderQtyEncodingOffset() {
        return 24;
    }

    public static int orderQtyEncodingLength() {
        return 16;
    }

    public static String orderQtyMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long orderQtyNullValue() {
        return 0xFFFFFFFFL;
    }

    public static long orderQtyMinValue() {
        return 0L;
    }

    public static long orderQtyMaxValue() {
        return 0xFFFFFFFEL;
    }

    public static int orderQtyLength() {
        return 4;
    }

    public long orderQty(int index) {
        if (index < 0 || index >= 4) {
            throw new IndexOutOfBoundsException("index out of range: index=" + index);
        }
        int pos = this.offset + 24 + index * 4;
        return (long)this.buffer.getInt(pos, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL;
    }

    public static int marketSegmentIDId() {
        return 1300;
    }

    public static int marketSegmentIDSinceVersion() {
        return 0;
    }

    public static int marketSegmentIDEncodingOffset() {
        return 40;
    }

    public static int marketSegmentIDEncodingLength() {
        return 1;
    }

    public static String marketSegmentIDMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static short marketSegmentIDNullValue() {
        return 255;
    }

    public static short marketSegmentIDMinValue() {
        return 0;
    }

    public static short marketSegmentIDMaxValue() {
        return 254;
    }

    public short marketSegmentID() {
        return (short)(this.buffer.getByte(this.offset + 40) & 0xFF);
    }

    public static int enteringTraderId() {
        return 35502;
    }

    public static int enteringTraderSinceVersion() {
        return 0;
    }

    public static int enteringTraderEncodingOffset() {
        return 41;
    }

    public static int enteringTraderEncodingLength() {
        return 5;
    }

    public static String enteringTraderMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static byte enteringTraderNullValue() {
        return 0;
    }

    public static byte enteringTraderMinValue() {
        return 32;
    }

    public static byte enteringTraderMaxValue() {
        return 126;
    }

    public static int enteringTraderLength() {
        return 5;
    }

    public byte enteringTrader(int index) {
        if (index < 0 || index >= 5) {
            throw new IndexOutOfBoundsException("index out of range: index=" + index);
        }
        int pos = this.offset + 41 + index * 1;
        return this.buffer.getByte(pos);
    }

    public static String enteringTraderCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public int getEnteringTrader(byte[] dst, int dstOffset) {
        int length = 5;
        if (dstOffset < 0 || dstOffset > dst.length - 5) {
            throw new IndexOutOfBoundsException("Copy will go out of range: offset=" + dstOffset);
        }
        this.buffer.getBytes(this.offset + 41, dst, dstOffset, 5);
        return 5;
    }

    public String enteringTrader() {
        int end;
        byte[] dst = new byte[5];
        this.buffer.getBytes(this.offset + 41, dst, 0, 5);
        for (end = 0; end < 5 && dst[end] != 0; ++end) {
        }
        return new String(dst, 0, end, StandardCharsets.US_ASCII);
    }

    public int getEnteringTrader(Appendable value) {
        for (int i = 0; i < 5; ++i) {
            int c = this.buffer.getByte(this.offset + 41 + i) & 0xFF;
            if (c == 0) {
                return i;
            }
            try {
                value.append((char)(c > 127 ? 63 : (char)c));
                continue;
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
        return 5;
    }

    public static long noSidesDecoderId() {
        return 10L;
    }

    public static int noSidesDecoderSinceVersion() {
        return 0;
    }

    public NoSidesDecoder noSides() {
        this.noSides.wrap(this.buffer);
        return this.noSides;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        NewOrderCrossDecoder decoder = new NewOrderCrossDecoder();
        decoder.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        int i;
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.initialOffset + this.actingBlockLength);
        builder.append("[NewOrderCross](sbeTemplateId=");
        builder.append(106);
        builder.append("|sbeSchemaId=");
        builder.append(1);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 0) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(0);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 46) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(46);
        builder.append("):");
        builder.append("messageType=");
        builder.append((Object)this.messageType());
        builder.append('|');
        builder.append("crossID=");
        builder.append(this.crossID());
        builder.append('|');
        builder.append("securityID=");
        builder.append(this.securityID());
        builder.append('|');
        builder.append("price=");
        PriceDecoder price = this.price();
        if (price != null) {
            price.appendTo(builder);
        } else {
            builder.append("null");
        }
        builder.append('|');
        builder.append("orderQty=");
        builder.append('[');
        if (NewOrderCrossDecoder.orderQtyLength() > 0) {
            for (i = 0; i < NewOrderCrossDecoder.orderQtyLength(); ++i) {
                builder.append(this.orderQty(i));
                builder.append(',');
            }
            builder.setLength(builder.length() - 1);
        }
        builder.append(']');
        builder.append('|');
        builder.append("marketSegmentID=");
        builder.append(this.marketSegmentID());
        builder.append('|');
        builder.append("enteringTrader=");
        for (i = 0; i < NewOrderCrossDecoder.enteringTraderLength() && this.enteringTrader(i) > 0; ++i) {
            builder.append((char)this.enteringTrader(i));
        }
        builder.append('|');
        builder.append("noSides=[");
        int noSidesOriginalOffset = this.noSides.offset;
        int noSidesOriginalIndex = this.noSides.index;
        NoSidesDecoder noSides = this.noSides();
        if (noSides.count() > 0) {
            while (noSides.hasNext()) {
                noSides.next().appendTo(builder);
                builder.append(',');
            }
            builder.setLength(builder.length() - 1);
        }
        noSides.offset = noSidesOriginalOffset;
        noSides.index = noSidesOriginalIndex;
        builder.append(']');
        this.limit(originalLimit);
        return builder;
    }

    public NewOrderCrossDecoder sbeSkip() {
        this.sbeRewind();
        NoSidesDecoder noSides = this.noSides();
        if (noSides.count() > 0) {
            while (noSides.hasNext()) {
                noSides.next();
                noSides.sbeSkip();
            }
        }
        return this;
    }

    public static final class NoSidesDecoder
    implements Iterable<NoSidesDecoder>,
    Iterator<NoSidesDecoder> {
        public static final int HEADER_SIZE = 3;
        private final NewOrderCrossDecoder parentMessage;
        private DirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int blockLength;

        NoSidesDecoder(NewOrderCrossDecoder parentMessage) {
            this.parentMessage = parentMessage;
        }

        public void wrap(DirectBuffer buffer) {
            if (buffer != this.buffer) {
                this.buffer = buffer;
            }
            this.index = 0;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 3);
            this.blockLength = buffer.getShort(limit + 0, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            this.count = (short)(buffer.getByte(limit + 2) & 0xFF);
        }

        @Override
        public NoSidesDecoder next() {
            if (this.index >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + this.blockLength);
            ++this.index;
            return this;
        }

        public static short countMinValue() {
            return 0;
        }

        public static short countMaxValue() {
            return 254;
        }

        public static int sbeHeaderSize() {
            return 3;
        }

        public static int sbeBlockLength() {
            return 13;
        }

        public int actingBlockLength() {
            return this.blockLength;
        }

        public int count() {
            return this.count;
        }

        @Override
        public Iterator<NoSidesDecoder> iterator() {
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index < this.count;
        }

        public static int sideId() {
            return 54;
        }

        public static int sideSinceVersion() {
            return 0;
        }

        public static int sideEncodingOffset() {
            return 0;
        }

        public static int sideEncodingLength() {
            return 1;
        }

        public static String sideMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public byte sideRaw() {
            return this.buffer.getByte(this.offset + 0);
        }

        public Side side() {
            return Side.get(this.buffer.getByte(this.offset + 0));
        }

        public static int clOrdIDId() {
            return 11;
        }

        public static int clOrdIDSinceVersion() {
            return 0;
        }

        public static int clOrdIDEncodingOffset() {
            return 1;
        }

        public static int clOrdIDEncodingLength() {
            return 8;
        }

        public static String clOrdIDMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static long clOrdIDNullValue() {
            return -1L;
        }

        public static long clOrdIDMinValue() {
            return 0L;
        }

        public static long clOrdIDMaxValue() {
            return -2L;
        }

        public long clOrdID() {
            return this.buffer.getLong(this.offset + 1, ByteOrder.LITTLE_ENDIAN);
        }

        public static int accountId() {
            return 1;
        }

        public static int accountSinceVersion() {
            return 0;
        }

        public static int accountEncodingOffset() {
            return 9;
        }

        public static int accountEncodingLength() {
            return 4;
        }

        public static String accountMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "optional";
            }
            return "";
        }

        public static long accountNullValue() {
            return 0L;
        }

        public static long accountMinValue() {
            return 0L;
        }

        public static long accountMaxValue() {
            return 0xFFFFFFFEL;
        }

        public long account() {
            return (long)this.buffer.getInt(this.offset + 9, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL;
        }

        public StringBuilder appendTo(StringBuilder builder) {
            if (null == this.buffer) {
                return builder;
            }
            builder.append('(');
            builder.append("side=");
            builder.append((Object)this.side());
            builder.append('|');
            builder.append("clOrdID=");
            builder.append(this.clOrdID());
            builder.append('|');
            builder.append("account=");
            builder.append(this.account());
            builder.append(')');
            return builder;
        }

        public NoSidesDecoder sbeSkip() {
            return this;
        }
    }
}

