/*
 * Decompiled with CFR 0.152.
 */
package uk.co.markormesher.androidfab;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.support.v7.widget.CardView;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import java.util.ArrayList;
import uk.co.markormesher.androidfab.FloatingActionButton$$Lambda$1;
import uk.co.markormesher.androidfab.FloatingActionButton$$Lambda$4;
import uk.co.markormesher.androidfab.FloatingActionButton$$Lambda$5;
import uk.co.markormesher.androidfab.SpeedDialMenuAdapter;
import uk.co.markormesher.androidfab.fab.R;

public class FloatingActionButton
extends RelativeLayout {
    private static final long ANIMATION_DURATION = 200L;
    private RelativeLayout fabContainer;
    private CardView cardView;
    private ViewGroup iconContainer;
    private View coverView;
    private View.OnClickListener listener;
    private boolean speedDialMenuOpen = false;
    private boolean busyAnimatingFabIcon = false;
    private boolean busyAnimatingSpeedDialCover = false;
    private boolean busyAnimatingSpeedDialMenu = false;
    private SpeedDialMenuAdapter menuAdapter;
    private ArrayList<View> speedDialMenuItems;

    public FloatingActionButton(Context context) {
        super(context);
        this.initView();
    }

    public FloatingActionButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public FloatingActionButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView();
    }

    private void initView() {
        FloatingActionButton.inflate((Context)this.getContext(), (int)R.layout.floating_action_button, (ViewGroup)this);
        this.fabContainer = (RelativeLayout)this.findViewById(R.id.fab_container);
        this.cardView = (CardView)this.findViewById(R.id.card);
        this.iconContainer = (ViewGroup)this.findViewById(R.id.icon_container);
        this.coverView = this.findViewById(R.id.cover);
        this.coverView.setAlpha(0.0f);
        this.cardView.setClickable(true);
        this.cardView.setFocusable(true);
        this.cardView.setOnClickListener(FloatingActionButton$$Lambda$1.lambdaFactory$(this));
    }

    public void setIcon(View icon) {
        this.iconContainer.removeAllViews();
        if (icon != null) {
            if (icon.getParent() != null) {
                ((ViewGroup)icon.getParent()).removeView(icon);
            }
            this.iconContainer.addView(icon);
        }
    }

    public void setOnClickListener(View.OnClickListener listener) {
        this.menuAdapter = null;
        this.listener = listener;
    }

    private void onClick() {
        if (this.listener != null) {
            this.listener.onClick((View)this);
        } else if (this.menuAdapter != null) {
            this.toggleSpeedDialMenu();
        }
    }

    public void setMenuAdapter(SpeedDialMenuAdapter menuAdapter) {
        this.listener = null;
        this.menuAdapter = menuAdapter;
        if (menuAdapter != null) {
            this.createSpeedDialMenuItems();
        }
    }

    @SuppressLint(value={"InlinedApi"})
    private void createSpeedDialMenuItems() {
        if (this.menuAdapter.getCount() == 0) {
            Log.w((String)"ANDROID_FAB", (String)"SpeedDialMenuAdapter contained zero items; speed-dial functionality was disabled.");
            this.setMenuAdapter(null);
            return;
        }
        this.speedDialMenuItems = new ArrayList(this.menuAdapter.getCount());
        for (int i = this.menuAdapter.getCount() - 1; i >= 0; --i) {
            View view = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.speed_dial_button, null);
            this.fabContainer.addView(view, 1);
            this.speedDialMenuItems.add(view);
            View[] adapterViews = this.menuAdapter.getViews(this.getContext(), i);
            if (adapterViews.length != 2) {
                throw new IllegalStateException("getViews() must return exactly two views.");
            }
            if (adapterViews[0] != null) {
                ((ViewGroup)view.findViewById(R.id.icon_container)).addView(adapterViews[0], 0);
            }
            if (adapterViews[1] != null) {
                ((ViewGroup)view.findViewById(R.id.speed_dial_item_container)).addView(adapterViews[1], 0);
            }
            RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)view.getLayoutParams();
            params.addRule(11);
            if (Build.VERSION.SDK_INT >= 17) {
                params.addRule(21);
            }
            params.addRule(12);
            view.setLayoutParams((ViewGroup.LayoutParams)params);
            view.setAlpha(0.0f);
            view.setTag((Object)i);
            view.setOnClickListener(FloatingActionButton$$Lambda$4.lambdaFactory$(this));
        }
    }

    public void closeSpeedDialMenu() {
        if (this.speedDialMenuOpen) {
            this.toggleSpeedDialMenu();
        }
    }

    public void openSpeedDialMenu() {
        if (!this.speedDialMenuOpen) {
            this.toggleSpeedDialMenu();
        }
    }

    private void toggleSpeedDialMenu() {
        if (this.busyAnimatingFabIcon || this.busyAnimatingSpeedDialCover || this.busyAnimatingSpeedDialMenu) {
            return;
        }
        boolean bl = this.speedDialMenuOpen = !this.speedDialMenuOpen;
        if (this.menuAdapter.rotateFab()) {
            this.toggleFabIconForSpeedDialMenu(this.speedDialMenuOpen);
        }
        this.setSpeedDialCoverVisible(this.speedDialMenuOpen);
        this.setSpeedDialMenuVisible(this.speedDialMenuOpen);
        this.coverView.setClickable(this.speedDialMenuOpen);
        this.coverView.setFocusable(this.speedDialMenuOpen);
        if (this.speedDialMenuOpen) {
            this.coverView.setOnClickListener(FloatingActionButton$$Lambda$5.lambdaFactory$(this));
        } else {
            this.coverView.setOnClickListener(null);
        }
    }

    private void toggleFabIconForSpeedDialMenu(boolean visible) {
        if (this.busyAnimatingFabIcon) {
            return;
        }
        this.busyAnimatingFabIcon = true;
        this.iconContainer.animate().rotation(visible ? 45.0f : 0.0f).setDuration(200L).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                FloatingActionButton.this.busyAnimatingFabIcon = false;
            }
        });
    }

    private void setSpeedDialCoverVisible(boolean visible) {
        if (this.busyAnimatingSpeedDialCover) {
            return;
        }
        this.busyAnimatingSpeedDialCover = true;
        this.coverView.animate().scaleX(visible ? 50.0f : 0.0f).scaleY(visible ? 50.0f : 0.0f).alpha(visible ? 1.0f : 0.0f).setDuration(200L).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                FloatingActionButton.this.busyAnimatingSpeedDialCover = false;
            }
        });
    }

    private void setSpeedDialMenuVisible(boolean visible) {
        if (this.busyAnimatingSpeedDialMenu) {
            return;
        }
        this.busyAnimatingSpeedDialMenu = true;
        int distance = this.cardView.getHeight();
        int n = this.speedDialMenuItems.size();
        for (int i = 0; i < n; ++i) {
            this.speedDialMenuItems.get(i).animate().translationY(visible ? (float)((i + 1) * distance * -1 - distance / 8) : 0.0f).alpha(visible ? 1.0f : 0.0f).setDuration(200L).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    FloatingActionButton.this.busyAnimatingSpeedDialMenu = false;
                }
            });
        }
    }

    private /* synthetic */ void lambda$toggleSpeedDialMenu$2(View v) {
        this.toggleSpeedDialMenu();
    }

    private /* synthetic */ void lambda$createSpeedDialMenuItems$1(View v) {
        if (this.menuAdapter.onMenuItemClick((Integer)v.getTag())) {
            this.closeSpeedDialMenu();
        }
    }

    private /* synthetic */ void lambda$initView$0(View v) {
        this.onClick();
    }

    static /* synthetic */ void access$lambda$0(FloatingActionButton floatingActionButton, View view) {
        floatingActionButton.lambda$initView$0(view);
    }

    static /* synthetic */ void access$lambda$1(FloatingActionButton floatingActionButton, View view) {
        floatingActionButton.lambda$createSpeedDialMenuItems$1(view);
    }

    static /* synthetic */ void access$lambda$2(FloatingActionButton floatingActionButton, View view) {
        floatingActionButton.lambda$toggleSpeedDialMenu$2(view);
    }
}

