/*
 * Decompiled with CFR 0.152.
 */
package uk.co.lucasweb.aws.v4.signer;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;

class CanonicalHeaders {
    private final String names;
    private final String canonicalizedHeaders;
    private final TreeMap<String, List<String>> internalMap;

    private CanonicalHeaders(String names, String canonicalizedHeaders, TreeMap<String, List<String>> internalMap) {
        this.names = names;
        this.canonicalizedHeaders = canonicalizedHeaders;
        this.internalMap = internalMap;
    }

    String get() {
        return this.canonicalizedHeaders;
    }

    String getNames() {
        return this.names;
    }

    Optional<String> getFirstValue(String name) {
        return Optional.ofNullable(this.internalMap.get(name.toLowerCase())).map(values -> (String)values.get(0));
    }

    static Builder builder() {
        return new Builder();
    }

    static class Builder {
        private final TreeMap<String, List<String>> internalMap = new TreeMap();

        Builder() {
        }

        Builder add(String name, String value) {
            if (name == null) {
                throw new IllegalArgumentException("name is null");
            }
            if (value == null) {
                throw new IllegalArgumentException("value is null");
            }
            String lowerCaseName = name.toLowerCase();
            this.internalMap.put(lowerCaseName, Optional.ofNullable(this.internalMap.get(lowerCaseName)).map(values -> {
                values.add(value);
                return values;
            }).orElse(this.newValueListWithValue(value)));
            return this;
        }

        CanonicalHeaders build() {
            String names = this.internalMap.keySet().stream().map(String::toLowerCase).collect(Collectors.joining(";"));
            StringBuilder canonicalizedHeadersBuilder = new StringBuilder();
            this.internalMap.entrySet().forEach(header -> ((List)header.getValue()).forEach(value -> canonicalizedHeadersBuilder.append(((String)header.getKey()).toLowerCase()).append(':').append((String)value).append('\n')));
            return new CanonicalHeaders(names, canonicalizedHeadersBuilder.toString(), this.internalMap);
        }

        private List<String> newValueListWithValue(String value) {
            ArrayList<String> values = new ArrayList<String>();
            values.add(value);
            return values;
        }
    }
}

