/*
 * Decompiled with CFR 0.152.
 */
package uk.co.deanwild.flowtextview.helpers;

import android.view.MotionEvent;
import android.view.View;
import java.util.ArrayList;
import uk.co.deanwild.flowtextview.helpers.SpanParser;
import uk.co.deanwild.flowtextview.listeners.OnLinkClickListener;
import uk.co.deanwild.flowtextview.models.HtmlLink;

public class ClickHandler
implements View.OnTouchListener {
    private final SpanParser mSpanParser;
    private OnLinkClickListener mOnLinkClickListener;
    private double distance = 0.0;
    private float x1;
    private float y1;
    private float x2;
    private float y2 = 0.0f;

    public ClickHandler(SpanParser spanParser) {
        this.mSpanParser = spanParser;
    }

    public boolean onTouch(View view, MotionEvent event) {
        int event_code = event.getAction();
        if (event_code == 0) {
            this.distance = 0.0;
            this.x1 = event.getX();
            this.y1 = event.getY();
        }
        if (event_code == 2) {
            this.x2 = event.getX();
            this.y2 = event.getY();
            this.distance = ClickHandler.getPointDistance(this.x1, this.y1, this.x2, this.y2);
        }
        if (this.distance < 10.0) {
            if (event_code == 1) {
                this.onClick(event.getX(), event.getY());
            }
            return true;
        }
        return false;
    }

    private void onClick(float x, float y) {
        ArrayList<HtmlLink> links = this.mSpanParser.getLinks();
        for (HtmlLink link : links) {
            float tlX = link.xOffset;
            float tlY = link.yOffset;
            float brX = link.xOffset + link.width;
            float brY = link.yOffset + link.height;
            if (!(x > tlX) || !(x < brX) || !(y > tlY) || !(y < brY)) continue;
            this.onLinkClick(link.url);
            return;
        }
    }

    private void onLinkClick(String url) {
        if (this.mOnLinkClickListener != null) {
            this.mOnLinkClickListener.onLinkClick(url);
        }
    }

    private static double getPointDistance(float x1, float y1, float x2, float y2) {
        return Math.sqrt(Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0));
    }

    public OnLinkClickListener getOnLinkClickListener() {
        return this.mOnLinkClickListener;
    }

    public void setOnLinkClickListener(OnLinkClickListener mOnLinkClickListener) {
        this.mOnLinkClickListener = mOnLinkClickListener;
    }
}

