/*
 * Decompiled with CFR 0.152.
 */
package uk.co.datumedge.hamcrest.json;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import uk.co.datumedge.hamcrest.json.JSONArrayAssertComparator;
import uk.co.datumedge.hamcrest.json.JSONComparator;
import uk.co.datumedge.hamcrest.json.JSONComparisonResult;
import uk.co.datumedge.hamcrest.json.JSONObjectAssertComparator;

public final class SameJSONAs<T>
extends TypeSafeDiagnosingMatcher<T> {
    private final T expected;
    private final JSONComparator<T> comparator;

    public SameJSONAs(T expected, JSONComparator<T> comparator) {
        this.expected = expected;
        this.comparator = comparator;
    }

    public void describeTo(Description description) {
        description.appendValue((Object)this.expected.toString());
    }

    protected boolean matchesSafely(T actual, Description mismatchDescription) {
        try {
            JSONComparisonResult result = this.comparator.compare(this.expected, actual);
            if (result.failed()) {
                mismatchDescription.appendDescriptionOf((SelfDescribing)result);
            }
            return result.passed();
        }
        catch (JSONException e) {
            StringWriter out = new StringWriter();
            e.printStackTrace(new PrintWriter(out));
            mismatchDescription.appendText(out.toString());
            return false;
        }
    }

    public SameJSONAs<T> allowingAnyArrayOrdering() {
        return new SameJSONAs<T>(this.expected, this.comparator.butAllowingAnyArrayOrdering());
    }

    public SameJSONAs<T> allowingExtraUnexpectedFields() {
        return new SameJSONAs<T>(this.expected, this.comparator.butAllowingExtraUnexpectedFields());
    }

    @Factory
    public static SameJSONAs<JSONObject> sameJSONObjectAs(JSONObject expected) {
        return new SameJSONAs<JSONObject>(expected, JSONObjectAssertComparator.actualJSONObjectSameAsExpected());
    }

    @Factory
    public static SameJSONAs<JSONArray> sameJSONArrayAs(JSONArray expected) {
        return new SameJSONAs<JSONArray>(expected, JSONArrayAssertComparator.actualJSONArraySameAsExpected());
    }

    @Factory
    public static Matcher<? super JSONArray> sameJSONArrayAs(JSONArray expected, JSONComparator<JSONArray> jsonComparator) {
        return new SameJSONAs<JSONArray>(expected, jsonComparator);
    }
}

