/*
 * Decompiled with CFR 0.152.
 */
package uk.co.coen.capsulecrm.client;

import com.google.common.base.MoreObjects;
import com.google.common.util.concurrent.Futures;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.Param;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import org.joda.time.DateTime;
import uk.co.coen.capsulecrm.client.CMilestones;
import uk.co.coen.capsulecrm.client.COpportunities;
import uk.co.coen.capsulecrm.client.CParty;
import uk.co.coen.capsulecrm.client.CapsuleEntity;
import uk.co.coen.capsulecrm.client.utils.ListenableFutureAdapter;
import uk.co.coen.capsulecrm.client.utils.ThrowOnHttpFailure;
import uk.co.coen.capsulecrm.client.utils.UnmarshalResponseBody;

public class COpportunity
extends CapsuleEntity {
    public String name;
    public String description;
    public Long partyId;
    public String currency;
    public String value;
    public String durationBasis;
    public Integer duration;
    public DateTime expectedCloseDate;
    public Long milestoneId;
    public String milestone;
    public String probability;
    public String owner;
    public Long trackId;
    public String endDate;

    @Override
    protected String readContextPath() {
        return "/opportunity";
    }

    @Override
    protected String writeContextPath() {
        return "/party/" + this.partyId + "/opportunity";
    }

    @Override
    protected List<Param> extraQueryParams() {
        ArrayList<Param> arrayList = new ArrayList<Param>();
        if (this.trackId != null) {
            arrayList.add(new Param("trackId", this.trackId.toString()));
        }
        if (this.endDate != null) {
            arrayList.add(new Param("endDate", this.endDate));
        }
        return arrayList;
    }

    public static Future<CMilestones> listMilestones() throws IOException {
        return Futures.transform(new ListenableFutureAdapter(((AsyncHttpClient.BoundRequestBuilder)asyncHttpClient.prepareGet(COpportunity.getCapsuleUrl() + "/api/opportunity/milestones").addHeader("Accept", "application/xml").setRealm(COpportunity.getRealm())).execute((AsyncHandler)new ThrowOnHttpFailure())), new UnmarshalResponseBody(xstream));
    }

    public static Future<COpportunities> listAll() throws IOException {
        return Futures.transform(new ListenableFutureAdapter(((AsyncHttpClient.BoundRequestBuilder)asyncHttpClient.prepareGet(COpportunity.getCapsuleUrl() + "/api/opportunity").addHeader("Accept", "application/xml").setRealm(COpportunity.getRealm())).execute((AsyncHandler)new ThrowOnHttpFailure())), new UnmarshalResponseBody(xstream));
    }

    public static Future<COpportunities> listByTag(String string) throws IOException {
        return Futures.transform(new ListenableFutureAdapter(((AsyncHttpClient.BoundRequestBuilder)asyncHttpClient.prepareGet(COpportunity.getCapsuleUrl() + "/api/opportunity").addQueryParam("tag", string).addHeader("Accept", "application/xml").setRealm(COpportunity.getRealm())).execute((AsyncHandler)new ThrowOnHttpFailure())), new UnmarshalResponseBody(xstream));
    }

    public static Future<COpportunities> listModifiedSince(DateTime dateTime) throws IOException {
        return Futures.transform(new ListenableFutureAdapter(((AsyncHttpClient.BoundRequestBuilder)asyncHttpClient.prepareGet(COpportunity.getCapsuleUrl() + "/api/opportunity").addQueryParam("lastmodified", dateTime.toString("yyyyMMdd'T'HHmmss")).addHeader("Accept", "application/xml").setRealm(COpportunity.getRealm())).execute((AsyncHandler)new ThrowOnHttpFailure())), new UnmarshalResponseBody(xstream));
    }

    public static Future<COpportunities> listByMilestone(String string) throws IOException {
        return Futures.transform(new ListenableFutureAdapter(((AsyncHttpClient.BoundRequestBuilder)asyncHttpClient.prepareGet(COpportunity.getCapsuleUrl() + "/api/opportunity").addQueryParam("milestone", string).addHeader("Accept", "application/xml").setRealm(COpportunity.getRealm())).execute((AsyncHandler)new ThrowOnHttpFailure())), new UnmarshalResponseBody(xstream));
    }

    public static Future<COpportunities> listByParty(CParty cParty) throws IOException {
        return Futures.transform(new ListenableFutureAdapter(((AsyncHttpClient.BoundRequestBuilder)asyncHttpClient.prepareGet(COpportunity.getCapsuleUrl() + "/api/party/" + cParty.id + "/opportunity").addHeader("Accept", "application/xml").setRealm(COpportunity.getRealm())).execute((AsyncHandler)new ThrowOnHttpFailure())), new UnmarshalResponseBody(xstream));
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("description", (Object)this.description).add("partyId", (Object)this.partyId).add("currency", (Object)this.currency).add("value", (Object)this.value).add("durationBasis", (Object)this.durationBasis).add("duration", (Object)this.duration).add("expectedCloseDate", (Object)this.expectedCloseDate).add("milestoneId", (Object)this.milestoneId).add("milestone", (Object)this.milestone).add("probability", (Object)this.probability).add("owner", (Object)this.owner).add("trackId", (Object)this.trackId).add("endDate", (Object)this.endDate).toString();
    }
}

