/*
 * Decompiled with CFR 0.152.
 */
package uk.co.coen.capsulecrm.client;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.Realm;
import com.ning.http.client.Response;
import com.ning.http.client.extra.ThrottleRequestFilter;
import com.ning.http.client.filter.RequestFilter;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import uk.co.coen.capsulecrm.client.CAddress;
import uk.co.coen.capsulecrm.client.CAttachment;
import uk.co.coen.capsulecrm.client.CCustomField;
import uk.co.coen.capsulecrm.client.CCustomFields;
import uk.co.coen.capsulecrm.client.CEmail;
import uk.co.coen.capsulecrm.client.CHistory;
import uk.co.coen.capsulecrm.client.CHistoryItem;
import uk.co.coen.capsulecrm.client.CIdentifiable;
import uk.co.coen.capsulecrm.client.CMilestone;
import uk.co.coen.capsulecrm.client.CMilestones;
import uk.co.coen.capsulecrm.client.COpportunities;
import uk.co.coen.capsulecrm.client.COpportunity;
import uk.co.coen.capsulecrm.client.COrganisation;
import uk.co.coen.capsulecrm.client.CParties;
import uk.co.coen.capsulecrm.client.CPerson;
import uk.co.coen.capsulecrm.client.CPhone;
import uk.co.coen.capsulecrm.client.CTag;
import uk.co.coen.capsulecrm.client.CTags;
import uk.co.coen.capsulecrm.client.CTask;
import uk.co.coen.capsulecrm.client.CTasks;
import uk.co.coen.capsulecrm.client.CTrack;
import uk.co.coen.capsulecrm.client.CTracks;
import uk.co.coen.capsulecrm.client.CUser;
import uk.co.coen.capsulecrm.client.CUsers;
import uk.co.coen.capsulecrm.client.CWebsite;
import uk.co.coen.capsulecrm.client.utils.JodaDateTimeXStreamConverter;
import uk.co.coen.capsulecrm.client.utils.ThrowOnHttpFailure;

public abstract class SimpleCapsuleEntity
extends CIdentifiable {
    static final Config conf = ConfigFactory.load();
    static final String capsuleUrl = conf.getString("capsulecrm.url");
    static AsyncHttpClientConfig config = new AsyncHttpClientConfig.Builder().addRequestFilter((RequestFilter)new ThrottleRequestFilter(10)).setMaximumConnectionsPerHost(40).setRequestTimeoutInMs(60000).setCompressionEnabled(true).build();
    static final AsyncHttpClient asyncHttpClient = new AsyncHttpClient(config);
    static final Realm realm = new Realm.RealmBuilder().setPrincipal(conf.getString("capsulecrm.token")).setUsePreemptiveAuth(true).setScheme(Realm.AuthScheme.BASIC).build();
    static final XStream xstream = new XStream();

    protected abstract String readContextPath();

    protected String writeContextPath() {
        return this.readContextPath();
    }

    public Future<Response> save() throws IOException {
        if (this.id != null) {
            return ((AsyncHttpClient.BoundRequestBuilder)((AsyncHttpClient.BoundRequestBuilder)asyncHttpClient.preparePut(capsuleUrl + "/api" + this.writeContextPath() + "/" + this.id).addHeader("Content-Type", "application/xml").setRealm(realm)).setBodyEncoding("UTF-8")).setBody(xstream.toXML((Object)this)).execute((AsyncHandler)new ThrowOnHttpFailure());
        }
        return ((AsyncHttpClient.BoundRequestBuilder)((AsyncHttpClient.BoundRequestBuilder)asyncHttpClient.preparePost(capsuleUrl + "/api" + this.writeContextPath()).addHeader("Content-Type", "application/xml").setRealm(realm)).setBodyEncoding("UTF-8")).setBody(xstream.toXML((Object)this)).execute((AsyncHandler)new ThrowOnHttpFailure(){

            @Override
            public Response onCompleted(Response response) throws Exception {
                String string = (response = super.onCompleted(response)).getHeader("Location");
                if (string == null) {
                    throw new RuntimeException("null location, cannot assign id to " + (Object)((Object)this) + ", status is " + response.getStatusCode() + " " + response.getStatusText());
                }
                SimpleCapsuleEntity.this.id = Long.parseLong(string.substring(string.lastIndexOf("/") + 1));
                return response;
            }
        });
    }

    public Future<Response> delete() throws IOException {
        return ((AsyncHttpClient.BoundRequestBuilder)asyncHttpClient.prepareDelete(capsuleUrl + "/api" + this.readContextPath() + "/" + this.id).setRealm(realm)).execute((AsyncHandler)new ThrowOnHttpFailure());
    }

    static {
        xstream.registerConverter((Converter)new JodaDateTimeXStreamConverter());
        xstream.addDefaultImplementation(ArrayList.class, List.class);
        xstream.addImplicitCollection(CHistoryItem.class, "attachments", CAttachment.class);
        xstream.alias("attachment", CAttachment.class);
        xstream.alias("organisation", COrganisation.class);
        xstream.alias("person", CPerson.class);
        xstream.alias("address", CAddress.class);
        xstream.alias("website", CWebsite.class);
        xstream.alias("email", CEmail.class);
        xstream.alias("phone", CPhone.class);
        xstream.alias("tags", CTags.class);
        xstream.aliasAttribute(CTags.class, "size", "size");
        xstream.addImplicitCollection(CTags.class, "tags", CTag.class);
        xstream.alias("tag", CTag.class);
        xstream.alias("tasks", CTasks.class);
        xstream.aliasAttribute(CTasks.class, "size", "size");
        xstream.addImplicitCollection(CTasks.class, "tasks", CTask.class);
        xstream.alias("task", CTask.class);
        xstream.alias("tracks", CTracks.class);
        xstream.addImplicitCollection(CTracks.class, "tracks", CTrack.class);
        xstream.alias("track", CTrack.class);
        xstream.alias("users", CUsers.class);
        xstream.addImplicitCollection(CUsers.class, "users", CUser.class);
        xstream.alias("user", CUser.class);
        xstream.alias("history", CHistory.class);
        xstream.aliasAttribute(CHistory.class, "size", "size");
        xstream.addImplicitCollection(CHistory.class, "historyItems", CHistoryItem.class);
        xstream.alias("historyItem", CHistoryItem.class);
        xstream.alias("parties", CParties.class);
        xstream.aliasAttribute(CParties.class, "size", "size");
        xstream.addImplicitCollection(CParties.class, "organisations", COrganisation.class);
        xstream.addImplicitCollection(CParties.class, "persons", CPerson.class);
        xstream.alias("customField", CCustomField.class);
        xstream.aliasField("boolean", CCustomField.class, "bool");
        xstream.alias("customFields", CCustomFields.class);
        xstream.aliasAttribute(CCustomFields.class, "size", "size");
        xstream.addImplicitCollection(CCustomFields.class, "customFields", CCustomField.class);
        xstream.alias("opportunities", COpportunities.class);
        xstream.addImplicitCollection(COpportunities.class, "opportunities", COpportunity.class);
        xstream.alias("opportunity", COpportunity.class);
        xstream.alias("milestones", CMilestones.class);
        xstream.addImplicitCollection(CMilestones.class, "milestones", CMilestone.class);
        xstream.alias("milestone", CMilestone.class);
    }
}

