/*
 * Decompiled with CFR 0.152.
 */
package uk.co.coen.capsulecrm.client;

import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.xml.DomReader;
import org.joda.time.DateTime;
import play.libs.F;
import play.libs.WS;
import uk.co.coen.capsulecrm.client.CCustomField;
import uk.co.coen.capsulecrm.client.CCustomFields;
import uk.co.coen.capsulecrm.client.CHistory;
import uk.co.coen.capsulecrm.client.CHistoryItem;
import uk.co.coen.capsulecrm.client.CTag;
import uk.co.coen.capsulecrm.client.CTask;
import uk.co.coen.capsulecrm.client.CTasks;
import uk.co.coen.capsulecrm.client.SimpleCapsuleEntity;
import uk.co.coen.capsulecrm.client.TaskStatus;

public abstract class CapsuleEntity
extends SimpleCapsuleEntity {
    public DateTime createdOn;
    public DateTime updatedOn;

    public F.Promise<CCustomFields> listCustomFields() {
        return WS.url((String)(capsuleUrl + "/api" + this.readContextPath() + "/" + this.id + "/customfield")).setHeader("Content-Type", "text/xml; charset=utf-8").setAuth(capsuleToken, "").get().map((F.Function)new F.Function<WS.Response, CCustomFields>(){

            public CCustomFields apply(WS.Response response) throws Throwable {
                return (CCustomFields)SimpleCapsuleEntity.xstream.unmarshal((HierarchicalStreamReader)new DomReader(response.asXml()));
            }
        });
    }

    public F.Promise<WS.Response> add(final CCustomField cCustomField) {
        if (cCustomField.id != null) {
            return WS.url((String)(capsuleUrl + "/api" + this.readContextPath() + "/" + this.id + "/customfield/" + cCustomField.id)).setHeader("Content-Type", "text/xml; charset=utf-8").setAuth(capsuleToken, "").put(xstream.toXML((Object)cCustomField));
        }
        return WS.url((String)(capsuleUrl + "/api" + this.readContextPath() + "/" + this.id + "/customfield")).setHeader("Content-Type", "text/xml; charset=utf-8").setAuth(capsuleToken, "").post(xstream.toXML((Object)cCustomField)).map((F.Function)new F.Function<WS.Response, WS.Response>(){

            public WS.Response apply(WS.Response response) throws Throwable {
                String string = response.getHeader("Location");
                if (string == null) {
                    throw new RuntimeException("null location, cannot assign id to custom field " + this + ", status is " + response.getStatus() + " " + response.getStatusText());
                }
                cCustomField.id = Integer.parseInt(string.substring(string.lastIndexOf("/") + 1));
                return response;
            }
        });
    }

    public F.Promise<WS.Response> remove(CCustomField cCustomField) {
        return WS.url((String)(capsuleUrl + "/api" + this.readContextPath() + "/" + this.id + "/customfield/" + cCustomField.id)).setAuth(capsuleToken, "").delete();
    }

    public F.Promise<CHistory> listHistory() {
        return WS.url((String)(capsuleUrl + "/api" + this.readContextPath() + "/" + this.id + "/history")).setHeader("Content-Type", "text/xml; charset=utf-8").setAuth(capsuleToken, "").get().map((F.Function)new F.Function<WS.Response, CHistory>(){

            public CHistory apply(WS.Response response) throws Throwable {
                return (CHistory)SimpleCapsuleEntity.xstream.unmarshal((HierarchicalStreamReader)new DomReader(response.asXml()));
            }
        });
    }

    public F.Promise<WS.Response> add(final CHistoryItem cHistoryItem) {
        if (cHistoryItem.id != null) {
            return WS.url((String)(capsuleUrl + "/api" + this.readContextPath() + "/" + this.id + "/history/" + cHistoryItem.id)).setHeader("Content-Type", "text/xml; charset=utf-8").setAuth(capsuleToken, "").put(xstream.toXML((Object)cHistoryItem));
        }
        return WS.url((String)(capsuleUrl + "/api" + this.readContextPath() + "/" + this.id + "/history")).setHeader("Content-Type", "text/xml; charset=utf-8").setAuth(capsuleToken, "").post(xstream.toXML((Object)cHistoryItem)).map((F.Function)new F.Function<WS.Response, WS.Response>(){

            public WS.Response apply(WS.Response response) throws Throwable {
                String string = response.getHeader("Location");
                if (string == null) {
                    throw new RuntimeException("null location, cannot assign id to history item " + this + ", status is " + response.getStatus() + " " + response.getStatusText());
                }
                cHistoryItem.id = Integer.parseInt(string.substring(string.lastIndexOf("/") + 1));
                return response;
            }
        });
    }

    public F.Promise<WS.Response> remove(CHistoryItem cHistoryItem) {
        return WS.url((String)(capsuleUrl + "/api" + this.readContextPath() + "/" + this.id + "/history/" + cHistoryItem.id)).setAuth(capsuleToken, "").delete();
    }

    public F.Promise<WS.Response> add(CTag cTag) {
        return WS.url((String)(capsuleUrl + "/api" + this.readContextPath() + "/" + this.id + "/tag/" + cTag.name)).setHeader("Content-Type", "text/xml; charset=utf-8").setAuth(capsuleToken, "").post(xstream.toXML((Object)cTag));
    }

    public F.Promise<WS.Response> remove(CTag cTag) {
        return WS.url((String)(capsuleUrl + "/api" + this.readContextPath() + "/" + this.id + "/tag/" + cTag.name)).setAuth(capsuleToken, "").delete();
    }

    public F.Promise<CTasks> listTasks() {
        return WS.url((String)(capsuleUrl + "/api" + this.readContextPath() + "/" + this.id + "/tasks")).setHeader("Content-Type", "text/xml; charset=utf-8").setAuth(capsuleToken, "").get().map((F.Function)new F.Function<WS.Response, CTasks>(){

            public CTasks apply(WS.Response response) throws Throwable {
                return (CTasks)SimpleCapsuleEntity.xstream.unmarshal((HierarchicalStreamReader)new DomReader(response.asXml()));
            }
        });
    }

    public F.Promise<CTasks> listTasks(TaskStatus taskStatus) {
        return WS.url((String)(capsuleUrl + "/api" + this.readContextPath() + "/" + this.id + "/tasks")).setHeader("Content-Type", "text/xml; charset=utf-8").setQueryParameter("status", taskStatus.name()).setAuth(capsuleToken, "").get().map((F.Function)new F.Function<WS.Response, CTasks>(){

            public CTasks apply(WS.Response response) throws Throwable {
                return (CTasks)SimpleCapsuleEntity.xstream.unmarshal((HierarchicalStreamReader)new DomReader(response.asXml()));
            }
        });
    }

    public F.Promise<WS.Response> add(final CTask cTask) {
        return WS.url((String)(capsuleUrl + "/api" + this.readContextPath() + "/" + this.id + "/task")).setHeader("Content-Type", "text/xml; charset=utf-8").setAuth(capsuleToken, "").post(xstream.toXML((Object)cTask)).map((F.Function)new F.Function<WS.Response, WS.Response>(){

            public WS.Response apply(WS.Response response) throws Throwable {
                String string = response.getHeader("Location");
                if (string == null) {
                    throw new RuntimeException("null location, cannot assign id to task " + this + ", status is " + response.getStatus() + " " + response.getStatusText());
                }
                cTask.id = Integer.parseInt(string.substring(string.lastIndexOf("/") + 1));
                return response;
            }
        });
    }
}

