/*
 * Decompiled with CFR 0.152.
 */
package uk.co.coen.capsulecrm.client;

import com.google.common.base.Objects;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.xml.DomReader;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import play.libs.F;
import play.libs.WS;
import uk.co.coen.capsulecrm.client.CMilestones;
import uk.co.coen.capsulecrm.client.COpportunities;
import uk.co.coen.capsulecrm.client.CParty;
import uk.co.coen.capsulecrm.client.CapsuleEntity;
import uk.co.coen.capsulecrm.client.SimpleCapsuleEntity;

public class COpportunity
extends CapsuleEntity {
    public String name;
    public String description;
    public Integer partyId;
    public String currency;
    public String value;
    public String durationBasis;
    public Integer duration;
    public DateTime expectedCloseDate;
    public Integer milestoneId;
    public String milestone;
    public String probability;
    public String owner;

    @Override
    protected String readContextPath() {
        return "/opportunity";
    }

    @Override
    protected String writeContextPath() {
        return "/party/" + this.partyId + "/opportunity";
    }

    public static F.Promise<CMilestones> listMilestones() {
        return WS.url((String)(capsuleUrl + "/api/opportunity/milestones")).setHeader("Content-Type", "text/xml; charset=utf-8").setAuth(capsuleToken, "").get().map((F.Function)new F.Function<WS.Response, CMilestones>(){

            public CMilestones apply(WS.Response response) throws Throwable {
                return (CMilestones)SimpleCapsuleEntity.xstream.unmarshal((HierarchicalStreamReader)new DomReader(response.asXml()));
            }
        });
    }

    public static F.Promise<COpportunities> listAll() {
        return COpportunity.listAll(12L, TimeUnit.SECONDS);
    }

    public static F.Promise<COpportunities> listAll(long l, TimeUnit timeUnit) {
        return WS.url((String)(capsuleUrl + "/api/opportunity")).setTimeout((int)timeUnit.toMillis(l)).setHeader("Content-Type", "text/xml; charset=utf-8").setAuth(capsuleToken, "").get().map((F.Function)new F.Function<WS.Response, COpportunities>(){

            public COpportunities apply(WS.Response response) throws Throwable {
                if (response.getStatus() == 401) {
                    throw new RuntimeException("Not Authorized, check your Play configuration.");
                }
                return (COpportunities)SimpleCapsuleEntity.xstream.unmarshal((HierarchicalStreamReader)new DomReader(response.asXml()));
            }
        });
    }

    public static F.Promise<COpportunities> listByTag(String string) {
        return COpportunity.listByTag(string, 12L, TimeUnit.SECONDS);
    }

    public static F.Promise<COpportunities> listByTag(String string, long l, TimeUnit timeUnit) {
        return WS.url((String)(capsuleUrl + "/api/opportunity")).setTimeout((int)timeUnit.toMillis(l)).setQueryParameter("tag", string).setHeader("Content-Type", "text/xml; charset=utf-8").setAuth(capsuleToken, "").get().map((F.Function)new F.Function<WS.Response, COpportunities>(){

            public COpportunities apply(WS.Response response) throws Throwable {
                return (COpportunities)SimpleCapsuleEntity.xstream.unmarshal((HierarchicalStreamReader)new DomReader(response.asXml()));
            }
        });
    }

    public static F.Promise<COpportunities> listModifiedSince(DateTime dateTime) {
        return COpportunity.listModifiedSince(dateTime, 12L, TimeUnit.SECONDS);
    }

    public static F.Promise<COpportunities> listModifiedSince(DateTime dateTime, long l, TimeUnit timeUnit) {
        return WS.url((String)(capsuleUrl + "/api/opportunity")).setTimeout((int)timeUnit.toMillis(l)).setQueryParameter("lastmodified", dateTime.toString("yyyyMMdd'T'HHmmss")).setHeader("Content-Type", "text/xml; charset=utf-8").setAuth(capsuleToken, "").get().map((F.Function)new F.Function<WS.Response, COpportunities>(){

            public COpportunities apply(WS.Response response) throws Throwable {
                return (COpportunities)SimpleCapsuleEntity.xstream.unmarshal((HierarchicalStreamReader)new DomReader(response.asXml()));
            }
        });
    }

    public static F.Promise<COpportunities> listByParty(CParty cParty) {
        return COpportunity.listByParty(cParty, 12L, TimeUnit.SECONDS);
    }

    public static F.Promise<COpportunities> listByParty(CParty cParty, long l, TimeUnit timeUnit) {
        return WS.url((String)(capsuleUrl + "/api/party/" + cParty.id + "/opportunity")).setTimeout((int)timeUnit.toMillis(l)).setHeader("Content-Type", "text/xml; charset=utf-8").setAuth(capsuleToken, "").get().map((F.Function)new F.Function<WS.Response, COpportunities>(){

            public COpportunities apply(WS.Response response) throws Throwable {
                return (COpportunities)SimpleCapsuleEntity.xstream.unmarshal((HierarchicalStreamReader)new DomReader(response.asXml()));
            }
        });
    }

    @Override
    public String toString() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.name).add("description", (Object)this.description).add("partyId", (Object)this.partyId).add("currency", (Object)this.currency).add("value", (Object)this.value).add("durationBasis", (Object)this.durationBasis).add("duration", (Object)this.duration).add("expectedCloseDate", (Object)this.expectedCloseDate).add("milestoneId", (Object)this.milestoneId).add("milestone", (Object)this.milestone).add("probability", (Object)this.probability).add("owner", (Object)this.owner).toString();
    }
}

