/*
 * Decompiled with CFR 0.152.
 */
package uk.co.chrisjenx.calligraphy;

import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.util.Log;
import java.util.HashMap;
import java.util.Map;
import uk.co.chrisjenx.calligraphy.CalligraphyTypefaceSpan;

public final class TypefaceUtils {
    private static final Map<String, Typeface> sCachedFonts = new HashMap<String, Typeface>();
    private static final Map<Typeface, CalligraphyTypefaceSpan> sCachedSpans = new HashMap<Typeface, CalligraphyTypefaceSpan>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Typeface load(AssetManager assetManager, String filePath) {
        Map<String, Typeface> map = sCachedFonts;
        synchronized (map) {
            try {
                if (!sCachedFonts.containsKey(filePath)) {
                    Typeface typeface = Typeface.createFromAsset((AssetManager)assetManager, (String)filePath);
                    sCachedFonts.put(filePath, typeface);
                    return typeface;
                }
            }
            catch (Exception e) {
                Log.w((String)"Calligraphy", (String)("Can't create asset from " + filePath + ". Make sure you have passed in the correct path and file name."), (Throwable)e);
                sCachedFonts.put(filePath, null);
                return null;
            }
            return sCachedFonts.get(filePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CalligraphyTypefaceSpan getSpan(Typeface typeface) {
        if (typeface == null) {
            return null;
        }
        Map<Typeface, CalligraphyTypefaceSpan> map = sCachedSpans;
        synchronized (map) {
            if (!sCachedSpans.containsKey(typeface)) {
                CalligraphyTypefaceSpan span = new CalligraphyTypefaceSpan(typeface);
                sCachedSpans.put(typeface, span);
                return span;
            }
            return sCachedSpans.get(typeface);
        }
    }

    public static boolean isLoaded(Typeface typeface) {
        return typeface != null && sCachedFonts.containsValue(typeface);
    }

    private TypefaceUtils() {
    }
}

