/*
 * Decompiled with CFR 0.152.
 */
package uk.co.chrisjenx.calligraphy;

import android.annotation.SuppressLint;
import android.content.Context;
import android.support.v7.widget.Toolbar;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.AutoCompleteTextView;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.MultiAutoCompleteTextView;
import android.widget.RadioButton;
import android.widget.TextView;
import android.widget.ToggleButton;
import java.util.HashMap;
import java.util.Map;
import uk.co.chrisjenx.calligraphy.CalligraphyConfig;
import uk.co.chrisjenx.calligraphy.CalligraphyUtils;
import uk.co.chrisjenx.calligraphy.R;
import uk.co.chrisjenx.calligraphy.TypefaceUtils;

class CalligraphyFactory {
    private static final String ACTION_BAR_TITLE = "action_bar_title";
    private static final String ACTION_BAR_SUBTITLE = "action_bar_subtitle";
    private static final Map<Class<? extends TextView>, Integer> sStyles = new HashMap<Class<? extends TextView>, Integer>(){
        {
            this.put(TextView.class, 16842884);
            this.put(Button.class, 16842824);
            this.put(EditText.class, 16842862);
            this.put(AutoCompleteTextView.class, 16842859);
            this.put(MultiAutoCompleteTextView.class, 16842859);
            this.put(CheckBox.class, 16842860);
            this.put(RadioButton.class, 16842878);
            this.put(ToggleButton.class, 16842827);
        }
    };
    private final int mAttributeId;

    protected static int[] getStyleForTextView(TextView view) {
        int[] styleIds = new int[]{-1, -1};
        if (CalligraphyFactory.isActionBarTitle(view)) {
            styleIds[0] = 16843470;
            styleIds[1] = 16843512;
        } else if (CalligraphyFactory.isActionBarSubTitle(view)) {
            styleIds[0] = 16843470;
            styleIds[1] = 16843513;
        }
        if (styleIds[0] == -1) {
            styleIds[0] = sStyles.containsKey(view.getClass()) ? sStyles.get(view.getClass()) : 16842804;
        }
        return styleIds;
    }

    @SuppressLint(value={"NewApi"})
    protected static boolean isActionBarTitle(TextView view) {
        if (CalligraphyFactory.matchesResourceIdName((View)view, ACTION_BAR_TITLE)) {
            return true;
        }
        if (CalligraphyFactory.parentIsToolbarV7((View)view)) {
            Toolbar parent = (Toolbar)view.getParent();
            return TextUtils.equals((CharSequence)parent.getTitle(), (CharSequence)view.getText());
        }
        return false;
    }

    @SuppressLint(value={"NewApi"})
    protected static boolean isActionBarSubTitle(TextView view) {
        if (CalligraphyFactory.matchesResourceIdName((View)view, ACTION_BAR_SUBTITLE)) {
            return true;
        }
        if (CalligraphyFactory.parentIsToolbarV7((View)view)) {
            Toolbar parent = (Toolbar)view.getParent();
            return TextUtils.equals((CharSequence)parent.getSubtitle(), (CharSequence)view.getText());
        }
        return false;
    }

    protected static boolean parentIsToolbarV7(View view) {
        return CalligraphyUtils.canCheckForV7Toolbar() && view.getParent() != null && view.getParent() instanceof Toolbar;
    }

    protected static boolean matchesResourceIdName(View view, String matches) {
        if (view.getId() == -1) {
            return false;
        }
        String resourceEntryName = view.getResources().getResourceEntryName(view.getId());
        return resourceEntryName.equalsIgnoreCase(matches);
    }

    public CalligraphyFactory(int attributeId) {
        this.mAttributeId = attributeId;
    }

    public View onViewCreated(View view, Context context, AttributeSet attrs) {
        if (view != null && view.getTag(R.id.calligraphy_tag_id) != Boolean.TRUE) {
            this.onViewCreatedInternal(view, context, attrs);
            view.setTag(R.id.calligraphy_tag_id, (Object)Boolean.TRUE);
        }
        return view;
    }

    void onViewCreatedInternal(View view, final Context context, AttributeSet attrs) {
        if (view instanceof TextView) {
            if (TypefaceUtils.isLoaded(((TextView)view).getTypeface())) {
                return;
            }
            String textViewFont = CalligraphyUtils.pullFontPathFromView(context, attrs, this.mAttributeId);
            if (TextUtils.isEmpty((CharSequence)textViewFont)) {
                textViewFont = CalligraphyUtils.pullFontPathFromStyle(context, attrs, this.mAttributeId);
            }
            if (TextUtils.isEmpty((CharSequence)textViewFont)) {
                textViewFont = CalligraphyUtils.pullFontPathFromTextAppearance(context, attrs, this.mAttributeId);
            }
            if (TextUtils.isEmpty((CharSequence)textViewFont)) {
                int[] styleForTextView = CalligraphyFactory.getStyleForTextView((TextView)view);
                textViewFont = styleForTextView[1] != -1 ? CalligraphyUtils.pullFontPathFromTheme(context, styleForTextView[0], styleForTextView[1], this.mAttributeId) : CalligraphyUtils.pullFontPathFromTheme(context, styleForTextView[0], this.mAttributeId);
            }
            boolean deferred = CalligraphyFactory.matchesResourceIdName(view, ACTION_BAR_TITLE) || CalligraphyFactory.matchesResourceIdName(view, ACTION_BAR_SUBTITLE);
            CalligraphyUtils.applyFontToTextView(context, (TextView)view, CalligraphyConfig.get(), textViewFont, deferred);
        }
        if (CalligraphyUtils.canCheckForV7Toolbar() && view instanceof Toolbar) {
            final ViewGroup parent = (ViewGroup)view;
            parent.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    if (parent.getChildCount() <= 0) {
                        return;
                    }
                    for (int i = 0; i < parent.getChildCount(); ++i) {
                        CalligraphyFactory.this.onViewCreated(parent.getChildAt(i), context, null);
                    }
                }
            });
        }
    }
}

