/*
 * Decompiled with CFR 0.152.
 */
package uk.co.chrisjenx.calligraphy;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.text.Editable;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.widget.TextView;
import uk.co.chrisjenx.calligraphy.CalligraphyConfig;
import uk.co.chrisjenx.calligraphy.TypefaceUtils;

public final class CalligraphyUtils {
    private static Boolean sToolbarCheck = null;

    public static CharSequence applyTypefaceSpan(CharSequence s, Typeface typeface) {
        if (s != null && s.length() > 0) {
            if (!(s instanceof Spannable)) {
                s = new SpannableString(s);
            }
            ((Spannable)s).setSpan((Object)TypefaceUtils.getSpan(typeface), 0, s.length(), 33);
        }
        return s;
    }

    public static boolean applyFontToTextView(TextView textView, Typeface typeface) {
        return CalligraphyUtils.applyFontToTextView(textView, typeface, false);
    }

    public static boolean applyFontToTextView(TextView textView, final Typeface typeface, boolean deferred) {
        if (textView == null || typeface == null) {
            return false;
        }
        textView.setPaintFlags(textView.getPaintFlags() | 0x80 | 1);
        textView.setTypeface(typeface);
        if (deferred) {
            textView.setText(CalligraphyUtils.applyTypefaceSpan(textView.getText(), typeface), TextView.BufferType.SPANNABLE);
            textView.addTextChangedListener(new TextWatcher(){

                public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                }

                public void onTextChanged(CharSequence s, int start, int before, int count) {
                }

                public void afterTextChanged(Editable s) {
                    CalligraphyUtils.applyTypefaceSpan((CharSequence)s, typeface);
                }
            });
        }
        return true;
    }

    public static boolean applyFontToTextView(Context context, TextView textView, String filePath) {
        return CalligraphyUtils.applyFontToTextView(context, textView, filePath, false);
    }

    static boolean applyFontToTextView(Context context, TextView textView, String filePath, boolean deferred) {
        if (textView == null || context == null) {
            return false;
        }
        AssetManager assetManager = context.getAssets();
        Typeface typeface = TypefaceUtils.load(assetManager, filePath);
        return CalligraphyUtils.applyFontToTextView(textView, typeface, deferred);
    }

    static void applyFontToTextView(Context context, TextView textView, CalligraphyConfig config) {
        CalligraphyUtils.applyFontToTextView(context, textView, config, false);
    }

    static void applyFontToTextView(Context context, TextView textView, CalligraphyConfig config, boolean deferred) {
        if (context == null || textView == null || config == null) {
            return;
        }
        if (!config.isFontSet()) {
            return;
        }
        CalligraphyUtils.applyFontToTextView(context, textView, config.getFontPath(), deferred);
    }

    public static void applyFontToTextView(Context context, TextView textView, CalligraphyConfig config, String textViewFont) {
        CalligraphyUtils.applyFontToTextView(context, textView, config, textViewFont, false);
    }

    static void applyFontToTextView(Context context, TextView textView, CalligraphyConfig config, String textViewFont, boolean deferred) {
        if (context == null || textView == null || config == null) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)textViewFont) && CalligraphyUtils.applyFontToTextView(context, textView, textViewFont, deferred)) {
            return;
        }
        CalligraphyUtils.applyFontToTextView(context, textView, config, deferred);
    }

    static String pullFontPathFromView(Context context, AttributeSet attrs, int attributeId) {
        String attributeName;
        if (attributeId == -1 || attrs == null) {
            return null;
        }
        try {
            attributeName = context.getResources().getResourceEntryName(attributeId);
        }
        catch (Resources.NotFoundException e) {
            return null;
        }
        int stringResourceId = attrs.getAttributeResourceValue(null, attributeName, -1);
        return stringResourceId > 0 ? context.getString(stringResourceId) : attrs.getAttributeValue(null, attributeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String pullFontPathFromStyle(Context context, AttributeSet attrs, int attributeId) {
        if (attributeId == -1 || attrs == null) {
            return null;
        }
        TypedArray typedArray = context.obtainStyledAttributes(attrs, new int[]{attributeId});
        if (typedArray != null) {
            try {
                String fontFromAttribute = typedArray.getString(0);
                if (!TextUtils.isEmpty((CharSequence)fontFromAttribute)) {
                    String string2 = fontFromAttribute;
                    return string2;
                }
            }
            catch (Exception ignore) {
            }
            finally {
                typedArray.recycle();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String pullFontPathFromTextAppearance(Context context, AttributeSet attrs, int attributeId) {
        TypedArray textAppearanceAttrs;
        if (attributeId == -1 || attrs == null) {
            return null;
        }
        int textAppearanceId = -1;
        TypedArray typedArrayAttr = context.obtainStyledAttributes(attrs, new int[]{16842804});
        if (typedArrayAttr != null) {
            try {
                textAppearanceId = typedArrayAttr.getResourceId(0, -1);
            }
            catch (Exception ignored) {
                String string2 = null;
                return string2;
            }
            finally {
                typedArrayAttr.recycle();
            }
        }
        if ((textAppearanceAttrs = context.obtainStyledAttributes(textAppearanceId, new int[]{attributeId})) != null) {
            try {
                String string3 = textAppearanceAttrs.getString(0);
                return string3;
            }
            catch (Exception ignore) {
                String string4 = null;
                return string4;
            }
            finally {
                textAppearanceAttrs.recycle();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String pullFontPathFromTheme(Context context, int styleAttrId, int attributeId) {
        if (styleAttrId == -1 || attributeId == -1) {
            return null;
        }
        Resources.Theme theme = context.getTheme();
        TypedValue value = new TypedValue();
        theme.resolveAttribute(styleAttrId, value, true);
        TypedArray typedArray = theme.obtainStyledAttributes(value.resourceId, new int[]{attributeId});
        try {
            String font;
            String string2 = font = typedArray.getString(0);
            return string2;
        }
        catch (Exception ignore) {
            String string3 = null;
            return string3;
        }
        finally {
            typedArray.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String pullFontPathFromTheme(Context context, int styleAttrId, int subStyleAttrId, int attributeId) {
        if (styleAttrId == -1 || attributeId == -1) {
            return null;
        }
        Resources.Theme theme = context.getTheme();
        TypedValue value = new TypedValue();
        theme.resolveAttribute(styleAttrId, value, true);
        int subStyleResId = -1;
        TypedArray parentTypedArray = theme.obtainStyledAttributes(value.resourceId, new int[]{subStyleAttrId});
        try {
            subStyleResId = parentTypedArray.getResourceId(0, -1);
        }
        catch (Exception ignore) {
            String string2 = null;
            return string2;
        }
        finally {
            parentTypedArray.recycle();
        }
        if (subStyleResId == -1) {
            return null;
        }
        TypedArray subTypedArray = context.obtainStyledAttributes(subStyleResId, new int[]{attributeId});
        if (subTypedArray != null) {
            try {
                String string3 = subTypedArray.getString(0);
                return string3;
            }
            catch (Exception ignore) {
                String string4 = null;
                return string4;
            }
            finally {
                subTypedArray.recycle();
            }
        }
        return null;
    }

    static boolean canCheckForV7Toolbar() {
        if (sToolbarCheck == null) {
            try {
                Class.forName("android.support.v7.widget.Toolbar");
                sToolbarCheck = Boolean.TRUE;
            }
            catch (ClassNotFoundException e) {
                sToolbarCheck = Boolean.FALSE;
            }
        }
        return sToolbarCheck;
    }

    private CalligraphyUtils() {
    }
}

