/*
 * Decompiled with CFR 0.152.
 */
package uk.co.chrisjenx.calligraphy;

import android.annotation.SuppressLint;
import android.content.Context;
import android.support.v7.widget.Toolbar;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.AutoCompleteTextView;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.MultiAutoCompleteTextView;
import android.widget.RadioButton;
import android.widget.TextView;
import android.widget.ToggleButton;
import java.util.HashMap;
import java.util.Map;
import uk.co.chrisjenx.calligraphy.CalligraphyConfig;
import uk.co.chrisjenx.calligraphy.CalligraphyUtils;
import uk.co.chrisjenx.calligraphy.TypefaceUtils;

class CalligraphyFactory
implements LayoutInflater.Factory {
    private static final String[] sClassPrefixList = new String[]{"android.widget.", "android.webkit."};
    private static final String ACTION_BAR_TITLE = "action_bar_title";
    private static final String ACTION_BAR_SUBTITLE = "action_bar_subtitle";
    private static final Map<Class<? extends TextView>, Integer> sStyles = new HashMap<Class<? extends TextView>, Integer>(){
        {
            this.put(TextView.class, 16842884);
            this.put(Button.class, 16842824);
            this.put(EditText.class, 16842862);
            this.put(AutoCompleteTextView.class, 16842859);
            this.put(MultiAutoCompleteTextView.class, 16842859);
            this.put(CheckBox.class, 16842860);
            this.put(RadioButton.class, 16842878);
            this.put(ToggleButton.class, 16842827);
        }
    };
    private final LayoutInflater.Factory factory;
    private final int mAttributeId;

    protected static int[] getStyleForTextView(TextView view) {
        int[] styleIds = new int[]{-1, -1};
        if (CalligraphyFactory.isActionBarTitle(view)) {
            styleIds[0] = 16843470;
            styleIds[1] = 16843512;
        } else if (CalligraphyFactory.isActionBarSubTitle(view)) {
            styleIds[0] = 16843470;
            styleIds[1] = 16843513;
        }
        if (styleIds[0] == -1) {
            styleIds[0] = sStyles.containsKey(view.getClass()) ? sStyles.get(view.getClass()) : 16842804;
        }
        return styleIds;
    }

    @SuppressLint(value={"NewApi"})
    protected static boolean isActionBarTitle(TextView view) {
        if (CalligraphyFactory.matchesResourceIdName((View)view, ACTION_BAR_TITLE)) {
            return true;
        }
        if (CalligraphyFactory.parentIsToolbarV7((View)view)) {
            Toolbar parent = (Toolbar)view.getParent();
            return TextUtils.equals((CharSequence)parent.getTitle(), (CharSequence)view.getText());
        }
        return false;
    }

    @SuppressLint(value={"NewApi"})
    protected static boolean isActionBarSubTitle(TextView view) {
        if (CalligraphyFactory.matchesResourceIdName((View)view, ACTION_BAR_SUBTITLE)) {
            return true;
        }
        if (CalligraphyFactory.parentIsToolbarV7((View)view)) {
            Toolbar parent = (Toolbar)view.getParent();
            return TextUtils.equals((CharSequence)parent.getSubtitle(), (CharSequence)view.getText());
        }
        return false;
    }

    protected static boolean parentIsToolbarV7(View view) {
        return CalligraphyUtils.canCheckForV7Toolbar() && view.getParent() != null && view.getParent() instanceof Toolbar;
    }

    protected static boolean matchesResourceIdName(View view, String matches) {
        if (view.getId() == -1) {
            return false;
        }
        String resourceEntryName = view.getResources().getResourceEntryName(view.getId());
        return resourceEntryName.equalsIgnoreCase(matches);
    }

    public CalligraphyFactory(LayoutInflater.Factory factory, int attributeId) {
        this.factory = factory;
        this.mAttributeId = attributeId;
    }

    public View onCreateView(String name, Context context, AttributeSet attrs) {
        View view = null;
        if (context instanceof LayoutInflater.Factory) {
            view = ((LayoutInflater.Factory)context).onCreateView(name, context, attrs);
        }
        if (this.factory != null && view == null) {
            view = this.factory.onCreateView(name, context, attrs);
        }
        if (view == null) {
            view = this.createViewOrFailQuietly(name, context, attrs);
        }
        if (view != null) {
            this.onViewCreated(view, name, context, attrs);
        }
        return view;
    }

    protected View createViewOrFailQuietly(String name, Context context, AttributeSet attrs) {
        if (name.contains(".")) {
            return this.createViewOrFailQuietly(name, null, context, attrs);
        }
        for (String prefix : sClassPrefixList) {
            View view = this.createViewOrFailQuietly(name, prefix, context, attrs);
            if (view == null) continue;
            return view;
        }
        return null;
    }

    protected View createViewOrFailQuietly(String name, String prefix, Context context, AttributeSet attrs) {
        try {
            return LayoutInflater.from((Context)context).createView(name, prefix, attrs);
        }
        catch (Exception ignore) {
            return null;
        }
    }

    protected void onViewCreated(View view, String name, final Context context, AttributeSet attrs) {
        if (view instanceof TextView) {
            if (TypefaceUtils.isLoaded(((TextView)view).getTypeface())) {
                return;
            }
            String textViewFont = CalligraphyUtils.pullFontPathFromView(context, attrs, this.mAttributeId);
            if (TextUtils.isEmpty((CharSequence)textViewFont)) {
                textViewFont = CalligraphyUtils.pullFontPathFromStyle(context, attrs, this.mAttributeId);
            }
            if (TextUtils.isEmpty((CharSequence)textViewFont)) {
                textViewFont = CalligraphyUtils.pullFontPathFromTextAppearance(context, attrs, this.mAttributeId);
            }
            if (TextUtils.isEmpty((CharSequence)textViewFont)) {
                int[] styleForTextView = CalligraphyFactory.getStyleForTextView((TextView)view);
                textViewFont = styleForTextView[1] != -1 ? CalligraphyUtils.pullFontPathFromTheme(context, styleForTextView[0], styleForTextView[1], this.mAttributeId) : CalligraphyUtils.pullFontPathFromTheme(context, styleForTextView[0], this.mAttributeId);
            }
            boolean deferred = CalligraphyFactory.matchesResourceIdName(view, ACTION_BAR_TITLE) || CalligraphyFactory.matchesResourceIdName(view, ACTION_BAR_SUBTITLE);
            CalligraphyUtils.applyFontToTextView(context, (TextView)view, CalligraphyConfig.get(), textViewFont, deferred);
        }
        if (CalligraphyUtils.canCheckForV7Toolbar() && view instanceof Toolbar) {
            final ViewGroup parent = (ViewGroup)view;
            parent.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    if (parent.getChildCount() <= 0) {
                        return;
                    }
                    for (int i = 0; i < parent.getChildCount(); ++i) {
                        CalligraphyFactory.this.onViewCreated(parent.getChildAt(i), null, context, null);
                    }
                }
            });
        }
    }
}

