/*
 * Decompiled with CFR 0.152.
 */
package uk.co.chrisjenx.calligraphy;

import android.text.TextUtils;

public class CalligraphyConfig {
    private static CalligraphyConfig mInstance;
    private final String mFontPath;
    private final boolean mIsFontSet;
    private final int mAttrId;

    public static void initDefault(String defaultFontAssetPath) {
        mInstance = new CalligraphyConfig(defaultFontAssetPath);
    }

    public static void initDefault(int defaultAttributeId) {
        mInstance = new CalligraphyConfig(defaultAttributeId);
    }

    public static void initDefault(String defaultFontAssetPath, int defaultAttributeId) {
        mInstance = new CalligraphyConfig(defaultFontAssetPath, defaultAttributeId);
    }

    static CalligraphyConfig get() {
        if (mInstance == null) {
            mInstance = new CalligraphyConfig();
        }
        return mInstance;
    }

    private CalligraphyConfig() {
        this(null, -1);
    }

    private CalligraphyConfig(int attrId) {
        this(null, attrId);
    }

    private CalligraphyConfig(String defaultFontAssetPath) {
        this(defaultFontAssetPath, -1);
    }

    private CalligraphyConfig(String defaultFontAssetPath, int attrId) {
        this.mFontPath = defaultFontAssetPath;
        this.mIsFontSet = !TextUtils.isEmpty((CharSequence)defaultFontAssetPath);
        this.mAttrId = attrId != -1 ? attrId : -1;
    }

    String getFontPath() {
        return this.mFontPath;
    }

    boolean isFontSet() {
        return this.mIsFontSet;
    }

    public int getAttrId() {
        return this.mAttrId;
    }
}

