/*
 * Decompiled with CFR 0.152.
 */
package uk.co.chrisjenx.calligraphy;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.AutoCompleteTextView;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.MultiAutoCompleteTextView;
import android.widget.RadioButton;
import android.widget.TextView;
import android.widget.ToggleButton;
import java.util.HashMap;
import java.util.Map;
import uk.co.chrisjenx.calligraphy.CalligraphyConfig;
import uk.co.chrisjenx.calligraphy.CalligraphyUtils;

class CalligraphyFactory
implements LayoutInflater.Factory {
    private static final String[] sClassPrefixList = new String[]{"android.widget.", "android.webkit."};
    private static final Map<Class<? extends TextView>, Integer> sStyles = new HashMap<Class<? extends TextView>, Integer>(){
        {
            this.put(TextView.class, 16842884);
            this.put(Button.class, 16842824);
            this.put(EditText.class, 16842862);
            this.put(AutoCompleteTextView.class, 16842859);
            this.put(MultiAutoCompleteTextView.class, 16842859);
            this.put(CheckBox.class, 16842860);
            this.put(RadioButton.class, 16842878);
            this.put(ToggleButton.class, 16842827);
        }
    };
    private final LayoutInflater.Factory factory;
    private final int mAttributeId;

    public CalligraphyFactory(LayoutInflater.Factory factory, int attributeId) {
        this.factory = factory;
        this.mAttributeId = attributeId == 0 ? 16843692 : attributeId;
    }

    public View onCreateView(String name, Context context, AttributeSet attrs) {
        View view = null;
        if (context instanceof LayoutInflater.Factory) {
            view = ((LayoutInflater.Factory)context).onCreateView(name, context, attrs);
        }
        if (this.factory != null && view == null) {
            view = this.factory.onCreateView(name, context, attrs);
        }
        if (view == null) {
            view = this.createViewOrFailQuietly(name, context, attrs);
        }
        if (view != null) {
            this.onViewCreated(view, name, context, attrs);
        }
        return view;
    }

    protected View createViewOrFailQuietly(String name, Context context, AttributeSet attrs) {
        if (name.contains(".")) {
            return this.createViewOrFailQuietly(name, null, context, attrs);
        }
        for (String prefix : sClassPrefixList) {
            View view = this.createViewOrFailQuietly(name, prefix, context, attrs);
            if (view == null) continue;
            return view;
        }
        return null;
    }

    protected View createViewOrFailQuietly(String name, String prefix, Context context, AttributeSet attrs) {
        try {
            return LayoutInflater.from((Context)context).createView(name, prefix, attrs);
        }
        catch (Exception ignore) {
            return null;
        }
    }

    protected void onViewCreated(View view, String name, Context context, AttributeSet attrs) {
        if (view instanceof TextView) {
            String textViewFont = CalligraphyUtils.pullFontPath(context, attrs, this.mAttributeId);
            if (TextUtils.isEmpty((CharSequence)textViewFont)) {
                textViewFont = CalligraphyUtils.pullFontPathFromStyle(context, attrs, this.mAttributeId);
            }
            if (TextUtils.isEmpty((CharSequence)textViewFont)) {
                int styleId = sStyles.containsKey(view.getClass()) ? sStyles.get(view.getClass()) : 16842804;
                textViewFont = CalligraphyUtils.pullFontPathFromTheme(context, styleId, this.mAttributeId);
            }
            CalligraphyUtils.applyFontToTextView(context, (TextView)view, CalligraphyConfig.get(), textViewFont);
        }
    }
}

