/*
 * Decompiled with CFR 0.152.
 */
package uk.co.autotrader.traverson.link.hal;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import java.util.Collections;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import uk.co.autotrader.traverson.link.hal.HalEntityResolver;

class LinksResolver
implements HalEntityResolver {
    LinksResolver() {
    }

    @Override
    public JSONArray findJSONArrayRelation(JSONObject halResource, String relationType) {
        Object maybeJsonArray = this.getLinksSection(halResource).get(relationType);
        if (!(maybeJsonArray instanceof JSONArray)) {
            return new JSONArray();
        }
        return (JSONArray)maybeJsonArray;
    }

    @Override
    public String resolveLink(JSONObject jsonObject) {
        return jsonObject.getString("href");
    }

    @Override
    public Map<String, SortedSet<String>> describeRelations(JSONObject resource) {
        TreeSet sortedRels = new TreeSet();
        sortedRels.addAll(this.getLinksSection(resource).keySet());
        return Collections.singletonMap("'_links'", sortedRels);
    }

    private JSONObject getLinksSection(JSONObject halResource) {
        return halResource.getJSONObject("_links");
    }
}

