/*
 * Decompiled with CFR 0.152.
 */
package uk.co.autotrader.traverson.http;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import uk.co.autotrader.traverson.http.AuthCredential;
import uk.co.autotrader.traverson.http.Body;
import uk.co.autotrader.traverson.http.Method;

public class Request {
    private String url;
    private Method method;
    private String acceptMimeType;
    private final Map<String, String> headers;
    private final Map<String, List<String>> queryParameters = new HashMap<String, List<String>>();
    private final Map<String, List<String>> templateParams = new HashMap<String, List<String>>();
    private Body body;
    private final List<AuthCredential> authCredentials;

    public Request() {
        this.headers = new LinkedHashMap<String, String>();
        this.authCredentials = new LinkedList<AuthCredential>();
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Body getBody() {
        return this.body;
    }

    public void setBody(Body body) {
        this.body = body;
    }

    public List<AuthCredential> getAuthCredentials() {
        return this.authCredentials;
    }

    public String getAcceptMimeType() {
        return this.acceptMimeType;
    }

    public void setAcceptMimeType(String acceptMimeType) {
        this.acceptMimeType = acceptMimeType;
    }

    public void addHeader(String key, String value) {
        this.headers.put(key, value);
    }

    public void addAuthCredential(AuthCredential authCredential) {
        this.authCredentials.add(authCredential);
    }

    public Map<String, List<String>> getQueryParameters() {
        return this.queryParameters;
    }

    public void addQueryParam(String name, String ... values) {
        this.addParameters(this.queryParameters).accept(name, values);
    }

    public Map<String, List<String>> getTemplateParams() {
        return this.templateParams;
    }

    public void addTemplateParam(String name, String ... values) {
        this.addParameters(this.templateParams).accept(name, values);
    }

    private BiConsumer<String, String[]> addParameters(Map<String, List<String>> parameterMap) {
        return (name, values) -> {
            if (!parameterMap.containsKey(name)) {
                parameterMap.put((String)name, new LinkedList());
            }
            ((List)parameterMap.get(name)).addAll(Arrays.asList(values));
        };
    }
}

