/*
 * Decompiled with CFR 0.152.
 */
package uk.co.autotrader.traverson.conversion;

import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ServiceLoader;
import uk.co.autotrader.traverson.conversion.ByteArrayConverter;
import uk.co.autotrader.traverson.conversion.FastJsonResourceConverter;
import uk.co.autotrader.traverson.conversion.InputStreamConverter;
import uk.co.autotrader.traverson.conversion.ResourceConverter;
import uk.co.autotrader.traverson.conversion.StringResourceConverter;
import uk.co.autotrader.traverson.exception.ConversionException;

public class ResourceConversionService {
    private final Map<Class<?>, ResourceConverter<?>> convertersByClass;
    private static ResourceConversionService instance;

    ResourceConversionService(Map<Class<?>, ResourceConverter<?>> convertersByClass) {
        this.convertersByClass = convertersByClass;
    }

    public static ResourceConversionService getInstance() {
        if (instance == null) {
            ResourceConversionService conversionService = new ResourceConversionService(new LinkedHashMap());
            conversionService.addConverter(new FastJsonResourceConverter());
            conversionService.addConverter(new StringResourceConverter());
            conversionService.addConverter(new ByteArrayConverter());
            conversionService.addConverter(new InputStreamConverter());
            for (ResourceConverter resourceConverter : ServiceLoader.load(ResourceConverter.class)) {
                conversionService.addConverter(resourceConverter);
            }
            instance = conversionService;
        }
        return instance;
    }

    public void addConverter(ResourceConverter<?> resourceConverter) {
        this.convertersByClass.put(resourceConverter.getDestinationType(), resourceConverter);
    }

    public <T> T convert(InputStream resource, Class<T> returnType) {
        for (Class<T> classToConvert = returnType; classToConvert != null; classToConvert = classToConvert.getSuperclass()) {
            if (!this.convertersByClass.containsKey(classToConvert)) continue;
            return (T)this.convertersByClass.get(classToConvert).convert(resource, returnType);
        }
        throw new ConversionException("Unsupported return type of " + returnType.getCanonicalName());
    }

    Map<Class<?>, ResourceConverter<?>> getConvertersByClass() {
        return this.convertersByClass;
    }
}

