/*
 * Decompiled with CFR 0.152.
 */
package uk.co.autotrader.traverson.conversion;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONObject;
import java.io.InputStream;
import uk.co.autotrader.traverson.conversion.ResourceConverter;
import uk.co.autotrader.traverson.conversion.StringResourceConverter;
import uk.co.autotrader.traverson.exception.ConversionException;

class FastJsonResourceConverter
implements ResourceConverter<JSONObject> {
    FastJsonResourceConverter() {
    }

    @Override
    public Class<JSONObject> getDestinationType() {
        return JSONObject.class;
    }

    @Override
    public JSONObject convert(InputStream resource, Class<? extends JSONObject> returnType) {
        Object resourceAsString = null;
        try {
            resourceAsString = new StringResourceConverter().convert(resource, String.class);
            if (((String)resourceAsString).isEmpty()) {
                return null;
            }
            return JSON.parseObject((String)resourceAsString);
        }
        catch (JSONException ex) {
            throw new ConversionException("Failed to parse to JSONObject", (String)resourceAsString, ex);
        }
    }
}

