/*
 * Decompiled with CFR 0.152.
 */
package uk.co.alt236.resourcemirror.containers;

import android.graphics.ColorFilter;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.PorterDuff;
import android.widget.ImageView;

public class DrawableResourceContainer {
    private final int mResourceId;
    private final Integer mColourFilterColour;
    private final String mDrawableName;
    private ColorFilter mColourFilter;

    public DrawableResourceContainer(int resourceId, Integer colourFilterColour) {
        this(null, resourceId, colourFilterColour);
    }

    public DrawableResourceContainer(String drawableName, int resourceId, Integer colourFilterColour) {
        this.mResourceId = resourceId;
        this.mColourFilterColour = colourFilterColour;
        this.mDrawableName = drawableName;
    }

    public Integer getColourFilterColour() {
        return this.mColourFilterColour;
    }

    public String getDrawableName() {
        return this.mDrawableName;
    }

    private ColorFilter getOverridingColorFilter(int color) {
        if (this.mColourFilter == null) {
            int red = (color & 0xFF0000) / 65535;
            int green = (color & 0xFF00) / 255;
            int blue = color & 0xFF;
            float[] matrix = new float[]{0.0f, 0.0f, 0.0f, 0.0f, red, 0.0f, 0.0f, 0.0f, 0.0f, green, 0.0f, 0.0f, 0.0f, 0.0f, blue, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f};
            this.mColourFilter = new ColorMatrixColorFilter(matrix);
        }
        return this.mColourFilter;
    }

    public int getResourceId() {
        return this.mResourceId;
    }

    public boolean hasColourFilter() {
        return this.mColourFilterColour != null;
    }

    public void setDrawableWithColorOverrideMatrix(ImageView iv) {
        iv.setImageResource(this.mResourceId);
        if (this.hasColourFilter()) {
            iv.setColorFilter(this.getOverridingColorFilter(this.mColourFilterColour));
        } else {
            iv.setColorFilter(null);
        }
    }

    public void setDrawableWithPorterDuffMultiply(ImageView iv) {
        iv.setImageResource(this.mResourceId);
        if (this.hasColourFilter()) {
            iv.setColorFilter(this.mColourFilterColour.intValue(), PorterDuff.Mode.MULTIPLY);
        } else {
            iv.setColorFilter(null);
        }
    }
}

