/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bristol.star.cdf;

import java.io.IOException;
import java.lang.reflect.Array;
import uk.ac.bristol.star.cdf.CdfFormatException;
import uk.ac.bristol.star.cdf.CdfInfo;
import uk.ac.bristol.star.cdf.EpochFormatter;
import uk.ac.bristol.star.cdf.record.Buf;
import uk.ac.bristol.star.cdf.record.Pointer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DataType {
    private final String name_;
    private final int byteCount_;
    private final int groupSize_;
    private final Class<?> arrayElementClass_;
    private final Class<?> scalarClass_;
    private final Object dfltPadValueArray_;
    private boolean hasMultipleElementsPerItem_;
    public static final DataType INT1 = new Int1DataType("INT1");
    public static final DataType INT2 = new Int2DataType("INT2");
    public static final DataType INT4 = new Int4DataType("INT4");
    public static final DataType INT8 = new Int8DataType("INT8");
    public static final DataType UINT1 = new UInt1DataType("UINT1");
    public static final DataType UINT2 = new UInt2DataType("UINT2");
    public static final DataType UINT4 = new UInt4DataType("UINT4");
    public static final DataType REAL4 = new Real4DataType("REAL4");
    public static final DataType REAL8 = new Real8DataType("REAL8");
    public static final DataType CHAR = new CharDataType("CHAR");
    public static final DataType EPOCH16 = new Epoch16DataType("EPOCH16");
    public static final DataType BYTE = new Int1DataType("BYTE");
    public static final DataType FLOAT = new Real4DataType("FLOAT");
    public static final DataType DOUBLE = new Real8DataType("DOUBLE");
    public static final DataType EPOCH = new EpochDataType("EPOCH");
    public static final DataType TIME_TT2000 = new Tt2kDataType("TIME_TT2000", -1);
    public static final DataType UCHAR = new CharDataType("UCHAR");

    private DataType(String string, int n, int n2, Class<?> clazz, Class<?> clazz2, Object object, boolean bl) {
        this.name_ = string;
        this.byteCount_ = n;
        this.groupSize_ = n2;
        this.arrayElementClass_ = clazz;
        this.scalarClass_ = clazz2;
        this.dfltPadValueArray_ = object;
        this.hasMultipleElementsPerItem_ = bl;
    }

    private DataType(String string, int n, int n2, Class<?> clazz, Class<?> clazz2) {
        this(string, n, n2, clazz, clazz2, Array.newInstance(clazz, n2), false);
    }

    public String getName() {
        return this.name_;
    }

    public int getByteCount() {
        return this.byteCount_;
    }

    public Class<?> getArrayElementClass() {
        return this.arrayElementClass_;
    }

    public Class<?> getScalarClass() {
        return this.scalarClass_;
    }

    public int getGroupSize() {
        return this.groupSize_;
    }

    public int getArrayIndex(int n) {
        return this.groupSize_ * n;
    }

    public boolean hasMultipleElementsPerItem() {
        return this.hasMultipleElementsPerItem_;
    }

    public Object getDefaultPadValueArray() {
        return this.dfltPadValueArray_;
    }

    public abstract void readValues(Buf var1, long var2, int var4, Object var5, int var6) throws IOException;

    public abstract Object getScalar(Object var1, int var2);

    public String formatScalarValue(Object object) {
        return object == null ? "" : object.toString();
    }

    public String formatArrayValue(Object object, int n) {
        Object object2 = Array.get(object, n);
        return object2 == null ? "" : object2.toString();
    }

    public String toString() {
        return this.name_;
    }

    public static DataType getDataType(int n, CdfInfo cdfInfo) throws CdfFormatException {
        DataType dataType = DataType.getDataType(n);
        return dataType == TIME_TT2000 ? new Tt2kDataType(dataType.getName(), cdfInfo.getLeapSecondLastUpdated()) : dataType;
    }

    public static DataType getDataType(int n) throws CdfFormatException {
        switch (n) {
            case 1: {
                return INT1;
            }
            case 2: {
                return INT2;
            }
            case 4: {
                return INT4;
            }
            case 8: {
                return INT8;
            }
            case 11: {
                return UINT1;
            }
            case 12: {
                return UINT2;
            }
            case 14: {
                return UINT4;
            }
            case 41: {
                return BYTE;
            }
            case 21: {
                return REAL4;
            }
            case 22: {
                return REAL8;
            }
            case 44: {
                return FLOAT;
            }
            case 45: {
                return DOUBLE;
            }
            case 31: {
                return EPOCH;
            }
            case 32: {
                return EPOCH16;
            }
            case 33: {
                return TIME_TT2000;
            }
            case 51: {
                return CHAR;
            }
            case 52: {
                return UCHAR;
            }
        }
        throw new CdfFormatException("Unknown data type " + n);
    }

    private static class Epoch16DataType
    extends DataType {
        private final EpochFormatter formatter_ = new EpochFormatter();

        Epoch16DataType(String string) {
            super(string, 16, 2, Double.TYPE, double[].class);
        }

        public void readValues(Buf buf, long l, int n, Object object, int n2) throws IOException {
            buf.readDataDoubles(l, n2 * 2, (double[])object);
        }

        public Object getScalar(Object object, int n) {
            double[] dArray = (double[])object;
            return new double[]{dArray[n], dArray[n + 1]};
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String formatScalarValue(Object object) {
            double[] dArray = (double[])object;
            EpochFormatter epochFormatter = this.formatter_;
            synchronized (epochFormatter) {
                return this.formatter_.formatEpoch16(dArray[0], dArray[1]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String formatArrayValue(Object object, int n) {
            double[] dArray = (double[])object;
            EpochFormatter epochFormatter = this.formatter_;
            synchronized (epochFormatter) {
                return this.formatter_.formatEpoch16(dArray[n], dArray[n + 1]);
            }
        }
    }

    private static class EpochDataType
    extends Real8DataType {
        private final EpochFormatter formatter_ = new EpochFormatter();

        EpochDataType(String string) {
            super(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String formatScalarValue(Object object) {
            EpochFormatter epochFormatter = this.formatter_;
            synchronized (epochFormatter) {
                return this.formatter_.formatEpoch((Double)object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String formatArrayValue(Object object, int n) {
            EpochFormatter epochFormatter = this.formatter_;
            synchronized (epochFormatter) {
                return this.formatter_.formatEpoch(((double[])object)[n]);
            }
        }
    }

    private static class CharDataType
    extends DataType {
        CharDataType(String string) {
            super(string, 1, 1, String.class, String.class, new String[]{null}, true);
        }

        public void readValues(Buf buf, long l, int n, Object object, int n2) throws IOException {
            String[] stringArray = (String[])object;
            byte[] byArray = new byte[n * n2];
            buf.readDataBytes(l, n * n2, byArray);
            for (int i = 0; i < n2; ++i) {
                String string;
                stringArray[i] = string = new String(byArray, i * n, n);
            }
        }

        public Object getScalar(Object object, int n) {
            return ((String[])object)[n];
        }
    }

    private static class Tt2kDataType
    extends Int8DataType {
        final int leapSecondLastUpdated_;
        final EpochFormatter formatter_;
        final long[] dfltPad_ = new long[]{-9223372036854775807L};

        Tt2kDataType(String string, int n) {
            super(string);
            this.leapSecondLastUpdated_ = n;
            this.formatter_ = new EpochFormatter(n);
        }

        public Object getDefaultPadValueArray() {
            return this.dfltPad_;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String formatScalarValue(Object object) {
            EpochFormatter epochFormatter = this.formatter_;
            synchronized (epochFormatter) {
                return this.formatter_.formatTimeTt2000((Long)object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String formatArrayValue(Object object, int n) {
            EpochFormatter epochFormatter = this.formatter_;
            synchronized (epochFormatter) {
                return this.formatter_.formatTimeTt2000(((long[])object)[n]);
            }
        }

        public int hashCode() {
            int n = 392552;
            n = 23 * n + this.leapSecondLastUpdated_;
            return n;
        }

        public boolean equals(Object object) {
            if (object instanceof Tt2kDataType) {
                Tt2kDataType tt2kDataType = (Tt2kDataType)object;
                return this.leapSecondLastUpdated_ == tt2kDataType.leapSecondLastUpdated_;
            }
            return false;
        }
    }

    private static class Real8DataType
    extends DataType {
        Real8DataType(String string) {
            super(string, 8, 1, Double.TYPE, Double.class);
        }

        public void readValues(Buf buf, long l, int n, Object object, int n2) throws IOException {
            buf.readDataDoubles(l, n2, (double[])object);
        }

        public Object getScalar(Object object, int n) {
            return new Double(((double[])object)[n]);
        }
    }

    private static class Real4DataType
    extends DataType {
        Real4DataType(String string) {
            super(string, 4, 1, Float.TYPE, Float.class);
        }

        public void readValues(Buf buf, long l, int n, Object object, int n2) throws IOException {
            buf.readDataFloats(l, n2, (float[])object);
        }

        public Object getScalar(Object object, int n) {
            return new Float(((float[])object)[n]);
        }
    }

    private static class UInt4DataType
    extends DataType {
        UInt4DataType(String string) {
            super(string, 4, 1, Long.TYPE, Long.class);
        }

        public void readValues(Buf buf, long l, int n, Object object, int n2) throws IOException {
            Pointer pointer = new Pointer(l);
            long[] lArray = (long[])object;
            boolean bl = buf.isBigendian();
            for (int i = 0; i < n2; ++i) {
                long l2 = buf.readUnsignedByte(pointer);
                long l3 = buf.readUnsignedByte(pointer);
                long l4 = buf.readUnsignedByte(pointer);
                long l5 = buf.readUnsignedByte(pointer);
                lArray[i] = bl ? l5 | l4 << 8 | l3 << 16 | l2 << 24 : l2 | l3 << 8 | l4 << 16 | l5 << 24;
            }
        }

        public Object getScalar(Object object, int n) {
            return new Long(((long[])object)[n]);
        }
    }

    private static class UInt2DataType
    extends DataType {
        UInt2DataType(String string) {
            super(string, 2, 1, Integer.TYPE, Integer.class);
        }

        public void readValues(Buf buf, long l, int n, Object object, int n2) throws IOException {
            Pointer pointer = new Pointer(l);
            int[] nArray = (int[])object;
            boolean bl = buf.isBigendian();
            for (int i = 0; i < n2; ++i) {
                int n3 = buf.readUnsignedByte(pointer);
                int n4 = buf.readUnsignedByte(pointer);
                nArray[i] = bl ? n4 | n3 << 8 : n3 | n4 << 8;
            }
        }

        public Object getScalar(Object object, int n) {
            return new Integer(((int[])object)[n]);
        }
    }

    private static class UInt1DataType
    extends DataType {
        UInt1DataType(String string) {
            super(string, 1, 1, Short.TYPE, Short.class);
        }

        public void readValues(Buf buf, long l, int n, Object object, int n2) throws IOException {
            Pointer pointer = new Pointer(l);
            short[] sArray = (short[])object;
            for (int i = 0; i < n2; ++i) {
                sArray[i] = (short)buf.readUnsignedByte(pointer);
            }
        }

        public Object getScalar(Object object, int n) {
            return new Short(((short[])object)[n]);
        }
    }

    private static class Int8DataType
    extends DataType {
        Int8DataType(String string) {
            super(string, 8, 1, Long.TYPE, Long.class);
        }

        public void readValues(Buf buf, long l, int n, Object object, int n2) throws IOException {
            buf.readDataLongs(l, n2, (long[])object);
        }

        public Object getScalar(Object object, int n) {
            return new Long(((long[])object)[n]);
        }
    }

    private static final class Int4DataType
    extends DataType {
        Int4DataType(String string) {
            super(string, 4, 1, Integer.TYPE, Integer.class);
        }

        public void readValues(Buf buf, long l, int n, Object object, int n2) throws IOException {
            buf.readDataInts(l, n2, (int[])object);
        }

        public Object getScalar(Object object, int n) {
            return new Integer(((int[])object)[n]);
        }
    }

    private static final class Int2DataType
    extends DataType {
        Int2DataType(String string) {
            super(string, 2, 1, Short.TYPE, Short.class);
        }

        public void readValues(Buf buf, long l, int n, Object object, int n2) throws IOException {
            buf.readDataShorts(l, n2, (short[])object);
        }

        public Object getScalar(Object object, int n) {
            return new Short(((short[])object)[n]);
        }
    }

    private static final class Int1DataType
    extends DataType {
        Int1DataType(String string) {
            super(string, 1, 1, Byte.TYPE, Byte.class);
        }

        public void readValues(Buf buf, long l, int n, Object object, int n2) throws IOException {
            buf.readDataBytes(l, n2, (byte[])object);
        }

        public Object getScalar(Object object, int n) {
            return new Byte(((byte[])object)[n]);
        }
    }
}

