/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.horizon.artcodes.process;

import android.content.Context;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.opencv.core.Core;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.MatOfInt;
import uk.ac.horizon.artcodes.detect.DetectorSetting;
import uk.ac.horizon.artcodes.detect.ImageBuffers;
import uk.ac.horizon.artcodes.detect.handler.MarkerDetectionHandler;
import uk.ac.horizon.artcodes.model.Experience;
import uk.ac.horizon.artcodes.process.ImageProcessor;
import uk.ac.horizon.artcodes.process.ImageProcessorFactory;

public class RgbColourFilter {

    public static class RgbColourFilter_StoricodesImpl
    implements ImageProcessor {
        private final Channel channel;
        private byte[] pixelBuffer;

        public RgbColourFilter_StoricodesImpl(Channel channel) {
            this.channel = channel;
        }

        @Override
        public void process(ImageBuffers buffers) {
            Mat greyscaleImage = buffers.getGreyBuffer();
            Mat colorImage = buffers.getImageInBgr();
            int desiredColorBufferSize = colorImage.rows() * colorImage.cols() * colorImage.channels();
            if (this.pixelBuffer == null || this.pixelBuffer.length < desiredColorBufferSize) {
                this.pixelBuffer = new byte[desiredColorBufferSize];
            }
            int desiredGreyBufferSize = colorImage.rows() * colorImage.cols();
            colorImage.get(0, 0, this.pixelBuffer);
            int c = this.channel == Channel.red ? 2 : (this.channel == Channel.green ? 1 : 0);
            int g = 0;
            int channels = colorImage.channels();
            while (g < desiredGreyBufferSize) {
                this.pixelBuffer[g] = this.pixelBuffer[c];
                ++g;
                c += channels;
            }
            greyscaleImage.put(0, 0, this.pixelBuffer);
            buffers.setImage(greyscaleImage);
        }

        @Override
        public void getSettings(List<DetectorSetting> settings) {
        }
    }

    public static class RgbColourFilter_YUV2ChannelImpl
    implements ImageProcessor {
        private final Channel channel;
        private final UvProcessor uvProcessor;
        private byte[] yRow1;
        private byte[] yRow2;
        private byte[] uvRow;

        public RgbColourFilter_YUV2ChannelImpl(Channel channel) {
            this.channel = channel;
            this.uvProcessor = channel == Channel.red ? new UvProcessor(){

                @Override
                public int process(byte[] uvData, int index) {
                    return (int)(1.370705 * (double)((uvData[index] & 0xFF) - 128));
                }
            } : (channel == Channel.green ? new UvProcessor(){

                @Override
                public int process(byte[] uvData, int index) {
                    return (int)(-(0.698001 * (double)((uvData[index] & 0xFF) - 128)) - 0.337633 * (double)((uvData[index + 1] & 0xFF) - 128));
                }
            } : new UvProcessor(){

                @Override
                public int process(byte[] uvData, int index) {
                    return (int)(1.732446 * (double)((uvData[index + 1] & 0xFF) - 128));
                }
            });
        }

        @Override
        public void process(ImageBuffers buffers) {
            Mat greyscaleImage = buffers.getGreyBuffer();
            Mat yuvImage = buffers.getImageInYuv();
            int yBufferSize = yuvImage.cols();
            int uvBufferSize = yuvImage.cols();
            if (this.yRow1 == null || this.yRow1.length != yBufferSize) {
                this.yRow1 = new byte[yBufferSize];
            }
            if (this.yRow2 == null || this.yRow2.length != yBufferSize) {
                this.yRow2 = new byte[yBufferSize];
            }
            if (this.uvRow == null || this.uvRow.length != uvBufferSize) {
                this.uvRow = new byte[uvBufferSize];
            }
            int totalUvRows = yuvImage.rows() / 3;
            int uvRowOffset = totalUvRows * 2;
            int width = yuvImage.cols();
            for (int uvRowIndex = 0; uvRowIndex < totalUvRows; ++uvRowIndex) {
                yuvImage.get(uvRowIndex * 2, 0, this.yRow1);
                yuvImage.get(uvRowIndex * 2 + 1, 0, this.yRow2);
                yuvImage.get(uvRowIndex + uvRowOffset, 0, this.uvRow);
                int uvComponent = 0;
                for (int uvColIndex = 0; uvColIndex < width; uvColIndex += 2) {
                    uvComponent = this.uvProcessor.process(this.uvRow, uvColIndex);
                    this.yRow1[uvColIndex] = (byte)((this.yRow1[uvColIndex] & 0xFF) + uvComponent);
                    this.yRow1[uvColIndex + 1] = (byte)((this.yRow1[uvColIndex + 1] & 0xFF) + uvComponent);
                    this.yRow2[uvColIndex] = (byte)((this.yRow2[uvColIndex] & 0xFF) + uvComponent);
                    this.yRow2[uvColIndex + 1] = (byte)((this.yRow2[uvColIndex + 1] & 0xFF) + uvComponent);
                }
                greyscaleImage.put(uvRowIndex * 2, 0, this.yRow1);
                greyscaleImage.put(uvRowIndex * 2 + 1, 0, this.yRow2);
            }
            buffers.setImage(greyscaleImage);
        }

        @Override
        public void getSettings(List<DetectorSetting> settings) {
        }

        private static interface UvProcessor {
            public int process(byte[] var1, int var2);
        }
    }

    public static class RgbColourFilter_SplitImpl
    implements ImageProcessor {
        private final Channel channel;

        public RgbColourFilter_SplitImpl(Channel channel) {
            this.channel = channel;
        }

        @Override
        public void process(ImageBuffers buffers) {
            Mat greyscaleImage = buffers.getGreyBuffer();
            Mat colorImage = buffers.getImageInBgr();
            ArrayList dst = new ArrayList(3);
            Core.split((Mat)colorImage, dst);
            if (this.channel == Channel.red) {
                ((Mat)dst.get(2)).copyTo(greyscaleImage);
            } else if (this.channel == Channel.green) {
                ((Mat)dst.get(1)).copyTo(greyscaleImage);
            } else if (this.channel == Channel.blue) {
                ((Mat)dst.get(0)).copyTo(greyscaleImage);
            }
            buffers.setImage(greyscaleImage);
        }

        @Override
        public void getSettings(List<DetectorSetting> settings) {
        }
    }

    public static class RgbColourFilter_MixChannelsImpl
    implements ImageProcessor {
        private final Channel channel;
        private Mat extraChannelMat;
        private MatOfInt mix;

        public Channel getChannel() {
            return this.channel;
        }

        public RgbColourFilter_MixChannelsImpl(Channel channel) {
            this.channel = channel;
        }

        @Override
        public void process(ImageBuffers buffers) {
            Mat greyscaleImage = buffers.getGreyBuffer();
            Mat colorImage = buffers.getImageInBgr();
            ArrayList<Mat> src = new ArrayList<Mat>(1);
            ArrayList<Mat> dst = new ArrayList<Mat>(1);
            src.add(colorImage);
            dst.add(greyscaleImage);
            if (this.mix == null) {
                if (colorImage.channels() == 3) {
                    if (this.channel == Channel.red) {
                        this.mix = new MatOfInt(new int[]{2, 0, 1, 1, 0, 2});
                    } else if (this.channel == Channel.green) {
                        this.mix = new MatOfInt(new int[]{2, 1, 1, 0, 0, 2});
                    } else if (this.channel == Channel.blue) {
                        this.mix = new MatOfInt(new int[]{2, 2, 1, 1, 0, 0});
                    }
                } else if (colorImage.channels() == 4) {
                    if (this.channel == Channel.red) {
                        this.mix = new MatOfInt(new int[]{2, 0, 1, 1, 0, 2, 3, 3});
                    } else if (this.channel == Channel.green) {
                        this.mix = new MatOfInt(new int[]{2, 1, 1, 0, 0, 2, 3, 3});
                    } else if (this.channel == Channel.blue) {
                        this.mix = new MatOfInt(new int[]{2, 2, 1, 1, 0, 0, 3, 3});
                    }
                } else {
                    Log.w((String)this.getClass().getSimpleName(), (String)("Colour image has unsupported number of channels: " + colorImage.channels()));
                }
            }
            if (this.extraChannelMat == null) {
                if (colorImage.channels() == 3) {
                    this.extraChannelMat = new Mat(greyscaleImage.rows(), greyscaleImage.cols(), CvType.CV_8UC2);
                } else if (colorImage.channels() == 4) {
                    this.extraChannelMat = new Mat(greyscaleImage.rows(), greyscaleImage.cols(), CvType.CV_8UC3);
                }
            }
            dst.add(this.extraChannelMat);
            Core.mixChannels(src, dst, (MatOfInt)this.mix);
            buffers.setImage(greyscaleImage);
        }

        @Override
        public void getSettings(List<DetectorSetting> settings) {
        }
    }

    public static class BlueFactory
    implements ImageProcessorFactory {
        @Override
        public String getName() {
            return "blueFilter";
        }

        @Override
        public ImageProcessor create(Context context, Experience experience, MarkerDetectionHandler handler, Map<String, String> args) {
            return new RgbColourFilter_MixChannelsImpl(Channel.blue);
        }
    }

    public static class GreenFactory
    implements ImageProcessorFactory {
        @Override
        public String getName() {
            return "greenFilter";
        }

        @Override
        public ImageProcessor create(Context context, Experience experience, MarkerDetectionHandler handler, Map<String, String> args) {
            return new RgbColourFilter_MixChannelsImpl(Channel.green);
        }
    }

    public static class RedFactory
    implements ImageProcessorFactory {
        @Override
        public String getName() {
            return "redFilter";
        }

        @Override
        public ImageProcessor create(Context context, Experience experience, MarkerDetectionHandler handler, Map<String, String> args) {
            return new RgbColourFilter_MixChannelsImpl(Channel.red);
        }
    }

    public static enum Channel {
        red,
        green,
        blue;

    }
}

