/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.horizon.artcodes.detect;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.support.v7.app.AlertDialog;
import android.util.Log;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opencv.core.Rect;
import uk.ac.horizon.artcodes.detect.Detector;
import uk.ac.horizon.artcodes.detect.handler.MarkerDetectionHandler;
import uk.ac.horizon.artcodes.detect.marker.MarkerAreaOrderDetector;
import uk.ac.horizon.artcodes.detect.marker.MarkerDetector;
import uk.ac.horizon.artcodes.detect.marker.MarkerEmbeddedChecksumAreaOrderDetector;
import uk.ac.horizon.artcodes.detect.marker.MarkerEmbeddedChecksumDetector;
import uk.ac.horizon.artcodes.model.Experience;
import uk.ac.horizon.artcodes.process.CmykColourFilter;
import uk.ac.horizon.artcodes.process.HlsEditImageProcessor;
import uk.ac.horizon.artcodes.process.ImageProcessor;
import uk.ac.horizon.artcodes.process.ImageProcessorFactory;
import uk.ac.horizon.artcodes.process.IntensityFilter;
import uk.ac.horizon.artcodes.process.Inverter;
import uk.ac.horizon.artcodes.process.RgbColourFilter;
import uk.ac.horizon.artcodes.process.TileThresholder;
import uk.ac.horizon.artcodes.process.WhiteBalanceImageProcessor;

public class ArtcodeDetector
extends Detector {
    private static final Map<String, ImageProcessorFactory> factoryRegistry = new HashMap<String, ImageProcessorFactory>();

    public ArtcodeDetector(final Context context, Experience experience, MarkerDetectionHandler handler) {
        boolean missingProcessors = false;
        for (String processorName : experience.getPipeline()) {
            ImageProcessor processor = ArtcodeDetector.getProcessor(context, processorName, experience, handler);
            if (processor != null) {
                this.pipeline.add(processor);
                continue;
            }
            missingProcessors = true;
        }
        if (missingProcessors) {
            new AlertDialog.Builder(context).setTitle((CharSequence)"Hmm...").setMessage((CharSequence)"This experience uses features not in this version of Artcodes. It might work fine or you can check Google Play for updates.").setPositiveButton((CharSequence)"Update", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    String appPackageName = context.getPackageName();
                    try {
                        context.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)("market://details?id=" + appPackageName))));
                    }
                    catch (ActivityNotFoundException e) {
                        context.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)("https://play.google.com/store/apps/details?id=" + appPackageName))));
                    }
                }
            }).setNegativeButton((CharSequence)"Continue", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                }
            }).setIcon(17301543).show();
        }
        if (this.pipeline.isEmpty()) {
            this.pipeline.add(new TileThresholder());
            this.pipeline.add(new MarkerDetector(experience, handler));
        }
    }

    private static void register(ImageProcessorFactory factory) {
        factoryRegistry.put(factory.getName(), factory);
    }

    private static ImageProcessor getProcessor(Context context, String string2, Experience experience, MarkerDetectionHandler handler) {
        String pattern = "([^\\(\\)]+)(?:\\(([^\\(\\)]*)\\))?";
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(string2);
        if (m.find()) {
            String imageProcessorName = m.group(1);
            String imageProcessorArgs = m.group(2);
            Log.i((String)"ArtcodeDetector", (String)("Attempting to create image processor '" + imageProcessorName + "' with args '" + imageProcessorArgs + "'"));
            ImageProcessorFactory factory = factoryRegistry.get(imageProcessorName);
            if (factory != null) {
                try {
                    return factory.create(context, experience, handler, ArtcodeDetector.getImageProcessorArgs(imageProcessorArgs));
                }
                catch (Exception e) {
                    Log.w((String)"detector", (String)e.getMessage(), (Throwable)e);
                }
            }
        } else {
            Log.i((String)"ArtcodeDetector", (String)("Regex error: '" + pattern + "' did not match '" + string2 + "'"));
        }
        return null;
    }

    private static Map<String, String> getImageProcessorArgs(String fromString) {
        HashMap<String, String> imageProcessorArgs = new HashMap<String, String>();
        if (fromString != null) {
            String[] args;
            for (String arg : args = fromString.split(",")) {
                String[] argArray = arg.trim().split("=");
                if (argArray.length == 1) {
                    imageProcessorArgs.put(argArray[0], argArray[0]);
                    continue;
                }
                if (argArray.length < 2) continue;
                imageProcessorArgs.put(argArray[0].trim(), argArray[1].trim());
            }
        }
        return imageProcessorArgs;
    }

    @Override
    protected Rect createROI(int imageWidth, int imageHeight, int surfaceWidth, int surfaceHeight) {
        int size = Math.min(imageWidth, imageHeight);
        int colStart = (imageWidth - size) / 2;
        int rowStart = (imageHeight - size) / 2;
        float surfaceMax = Math.max(surfaceHeight, surfaceWidth);
        float sizeRatio = surfaceMax / (float)Math.max(imageWidth, imageHeight);
        Log.i((String)"Detector", (String)("Size ratio = " + sizeRatio));
        if (this.callback != null) {
            int margin = (int)((float)Math.max(colStart, rowStart) * sizeRatio);
            Log.i((String)"Detector", (String)("Size = " + size + ", margin = " + margin));
            this.callback.detectionStart(margin);
        }
        return new Rect(colStart, rowStart, size, size);
    }

    static {
        ArtcodeDetector.register(new MarkerDetector.Factory());
        ArtcodeDetector.register(new MarkerEmbeddedChecksumDetector.Factory());
        ArtcodeDetector.register(new MarkerAreaOrderDetector.Factory());
        ArtcodeDetector.register(new MarkerEmbeddedChecksumAreaOrderDetector.Factory());
        ArtcodeDetector.register(new TileThresholder.Factory());
        ArtcodeDetector.register(new IntensityFilter.IntensityFilterFactory());
        ArtcodeDetector.register(new Inverter.InverterFactory());
        ArtcodeDetector.register(new WhiteBalanceImageProcessor.WhiteBalanceImageProcessorFactory());
        ArtcodeDetector.register(new HlsEditImageProcessor.HlsEditImageProcessorFactory());
        ArtcodeDetector.register(new RgbColourFilter.RedFactory());
        ArtcodeDetector.register(new RgbColourFilter.GreenFactory());
        ArtcodeDetector.register(new RgbColourFilter.BlueFactory());
        ArtcodeDetector.register(new CmykColourFilter.CyanCmykColourFilterFactory());
        ArtcodeDetector.register(new CmykColourFilter.MagentaCmykColourFilterFactory());
        ArtcodeDetector.register(new CmykColourFilter.YellowCmykColourFilterFactory());
        ArtcodeDetector.register(new CmykColourFilter.BlackCmykColourFilterFactory());
    }
}

