/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.horizon.artcodes.process;

import android.content.Context;
import java.util.List;
import java.util.Map;
import org.opencv.core.Mat;
import uk.ac.horizon.artcodes.detect.DetectorSetting;
import uk.ac.horizon.artcodes.detect.ImageBuffers;
import uk.ac.horizon.artcodes.detect.handler.MarkerDetectionHandler;
import uk.ac.horizon.artcodes.model.Experience;
import uk.ac.horizon.artcodes.process.ImageProcessor;
import uk.ac.horizon.artcodes.process.ImageProcessorFactory;

public class CmykColourFilter {

    public static class CmykColourFilter_UpdatedKImpl
    implements ImageProcessor {
        private byte[] pixelBuffer;
        private byte[] rowBuffer;

        @Override
        public void process(ImageBuffers buffers) {
            Mat greyscaleImage = buffers.getGreyBuffer();
            Mat colorImage = buffers.getImageInBgr();
            int desiredBufferSize = colorImage.rows() * colorImage.cols() * colorImage.channels();
            int desiredRowBufferSize = greyscaleImage.cols();
            if (this.pixelBuffer == null || this.pixelBuffer.length < desiredBufferSize) {
                this.pixelBuffer = new byte[desiredBufferSize];
            }
            if (this.rowBuffer == null || this.rowBuffer.length != desiredBufferSize) {
                this.rowBuffer = new byte[desiredRowBufferSize];
            }
            colorImage.get(0, 0, this.pixelBuffer);
            int rows = colorImage.rows();
            int colorChannels = colorImage.channels();
            int colorImageIndex = 0;
            for (int rowIndex = 0; rowIndex < rows; ++rowIndex) {
                for (int colIndex = 0; colIndex < desiredRowBufferSize; ++colIndex) {
                    this.rowBuffer[colIndex] = (byte)(255 - Math.max(this.pixelBuffer[colorImageIndex] & 0xFF, Math.max(this.pixelBuffer[colorImageIndex + 1] & 0xFF, this.pixelBuffer[colorImageIndex + 2] & 0xFF)));
                    colorImageIndex += colorChannels;
                }
                greyscaleImage.put(rowIndex, 0, this.rowBuffer);
            }
            buffers.setImage(greyscaleImage);
        }

        @Override
        public void getSettings(List<DetectorSetting> settings) {
        }
    }

    public static class CmykColourFilter_UpdatedCMYImpl
    implements ImageProcessor {
        private final Channel channel;
        private final int channelIndex;
        private byte[] colorPixelBuffer;
        private byte[] rowBuffer;

        public CmykColourFilter_UpdatedCMYImpl(Channel channel) {
            this.channel = channel;
            this.channelIndex = channel == Channel.cyan ? 2 : (channel == Channel.magenta ? 1 : 0);
        }

        @Override
        public void process(ImageBuffers buffers) {
            Mat greyscaleImage = buffers.getGreyBuffer();
            Mat colorImage = buffers.getImageInBgr();
            int desiredBufferSize = colorImage.rows() * colorImage.cols() * colorImage.channels();
            int desiredRowBufferSize = greyscaleImage.cols();
            if (this.colorPixelBuffer == null || this.colorPixelBuffer.length < desiredBufferSize) {
                this.colorPixelBuffer = new byte[desiredBufferSize];
            }
            if (this.rowBuffer == null || this.rowBuffer.length != desiredBufferSize) {
                this.rowBuffer = new byte[desiredRowBufferSize];
            }
            colorImage.get(0, 0, this.colorPixelBuffer);
            int colorPixelBufferIndex = 0;
            int colIndex = 0;
            int rowIndex = 0;
            while (colorPixelBufferIndex < desiredBufferSize) {
                for (colIndex = 0; colIndex < desiredRowBufferSize; ++colIndex) {
                    int result;
                    int k = 255 - Math.max(this.colorPixelBuffer[colorPixelBufferIndex] & 0xFF, Math.max(this.colorPixelBuffer[colorPixelBufferIndex + 1] & 0xFF, this.colorPixelBuffer[colorPixelBufferIndex + 2] & 0xFF));
                    int n = result = k == 255 ? 0 : 255 - (this.colorPixelBuffer[colorPixelBufferIndex + this.channelIndex] & 0xFF) - k;
                    this.rowBuffer[colIndex] = (byte)(result > 255 ? 255 : (result < 0 ? 0 : result));
                    colorPixelBufferIndex += 3;
                }
                greyscaleImage.put(rowIndex++, 0, this.rowBuffer);
            }
            buffers.setImage(greyscaleImage);
        }

        @Override
        public void getSettings(List<DetectorSetting> settings) {
        }
    }

    public static class CmykColourFilter_StoricodesImpl
    implements ImageProcessor {
        private final Channel channel;
        private byte[] pixelBuffer;

        public CmykColourFilter_StoricodesImpl(Channel channel) {
            this.channel = channel;
        }

        @Override
        public void process(ImageBuffers buffers) {
            Mat greyscaleImage = buffers.getGreyBuffer();
            Mat colorImage = buffers.getImageInBgr();
            int desiredBufferSize = colorImage.rows() * colorImage.cols() * colorImage.channels();
            if (this.pixelBuffer == null || this.pixelBuffer.length < desiredBufferSize) {
                this.pixelBuffer = new byte[desiredBufferSize];
            }
            colorImage.get(0, 0, this.pixelBuffer);
            if (this.channel == Channel.black) {
                int i = 0;
                int j = 0;
                while (i < desiredBufferSize) {
                    this.pixelBuffer[j] = (byte)Math.min(255 - (this.pixelBuffer[i] & 0xFF), Math.min(255 - (this.pixelBuffer[i + 1] & 0xFF), 255 - (this.pixelBuffer[i + 2] & 0xFF)));
                    i += 3;
                    ++j;
                }
            } else {
                int channelIndex = this.channel == Channel.cyan ? 2 : (this.channel == Channel.magenta ? 1 : 0);
                float[] bgr = new float[3];
                int i = 0;
                int j = 0;
                while (i < desiredBufferSize) {
                    bgr[0] = (float)(this.pixelBuffer[i] & 0xFF) / 255.0f;
                    bgr[1] = (float)(this.pixelBuffer[i + 1] & 0xFF) / 255.0f;
                    bgr[2] = (float)(this.pixelBuffer[i + 2] & 0xFF) / 255.0f;
                    float k = Math.min(1.0f - bgr[0], Math.min(1.0f - bgr[1], 1.0f - bgr[2]));
                    float result = k == 1.0f ? 0.0f : 1.0f - bgr[channelIndex] - k;
                    this.pixelBuffer[j] = (byte)(result * 255.0f);
                    i += 3;
                    ++j;
                }
            }
            greyscaleImage.put(0, 0, this.pixelBuffer);
            buffers.setImage(greyscaleImage);
        }

        @Override
        public void getSettings(List<DetectorSetting> settings) {
        }
    }

    public static class BlackCmykColourFilterFactory
    implements ImageProcessorFactory {
        @Override
        public String getName() {
            return "blackKFilter";
        }

        @Override
        public ImageProcessor create(Context context, Experience experience, MarkerDetectionHandler handler, Map<String, String> args) {
            return new CmykColourFilter_UpdatedKImpl();
        }
    }

    public static class YellowCmykColourFilterFactory
    implements ImageProcessorFactory {
        @Override
        public String getName() {
            return "yellowKFilter";
        }

        @Override
        public ImageProcessor create(Context context, Experience experience, MarkerDetectionHandler handler, Map<String, String> args) {
            return new CmykColourFilter_UpdatedCMYImpl(Channel.yellow);
        }
    }

    public static class MagentaCmykColourFilterFactory
    implements ImageProcessorFactory {
        @Override
        public String getName() {
            return "magentaKFilter";
        }

        @Override
        public ImageProcessor create(Context context, Experience experience, MarkerDetectionHandler handler, Map<String, String> args) {
            return new CmykColourFilter_UpdatedCMYImpl(Channel.magenta);
        }
    }

    public static class CyanCmykColourFilterFactory
    implements ImageProcessorFactory {
        @Override
        public String getName() {
            return "cyanKFilter";
        }

        @Override
        public ImageProcessor create(Context context, Experience experience, MarkerDetectionHandler handler, Map<String, String> args) {
            return new CmykColourFilter_UpdatedCMYImpl(Channel.cyan);
        }
    }

    public static enum Channel {
        cyan,
        magenta,
        yellow,
        black;

    }
}

