/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.horizon.artcodes.detect.handler;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.opencv.core.Mat;
import org.opencv.core.MatOfPoint;
import org.opencv.core.Size;
import uk.ac.horizon.artcodes.detect.handler.CodeDetectionHandler;
import uk.ac.horizon.artcodes.detect.handler.MarkerDetectionHandler;
import uk.ac.horizon.artcodes.detect.marker.Marker;
import uk.ac.horizon.artcodes.model.Action;
import uk.ac.horizon.artcodes.model.Experience;

public class MarkerCodeDetectionHandler
implements MarkerDetectionHandler {
    protected static final int REQUIRED = 20;
    protected static final int MAX_MULTIPLIER = 4;
    protected static final int OCCURRENCES = 2;
    protected final Multiset<String> markerCounts = HashMultiset.create();
    private Experience experience;
    private final CodeDetectionHandler markerCodeHandler;

    public MarkerCodeDetectionHandler(Experience experience, CodeDetectionHandler markerCodeHandler) {
        this.experience = experience;
        this.markerCodeHandler = markerCodeHandler;
    }

    @Override
    public void onMarkersDetected(Collection<Marker> markers, ArrayList<MatOfPoint> contours, Mat hierarchy, Size sourceImageSize) {
        this.countMarkers(markers);
        int best = 0;
        String selected = null;
        for (String code : this.markerCounts.elementSet()) {
            int count = this.markerCounts.count((Object)code);
            if (count <= best) continue;
            selected = code;
            best = count;
        }
        if (selected != null || best >= this.requiredFor(selected)) {
            this.markerCodeHandler.onMarkerCodeDetected(selected);
        }
    }

    protected Multiset<String> countMarkers(Collection<Marker> markers) {
        HashSet removals = new HashSet(this.markerCounts.elementSet());
        for (Marker marker : markers) {
            int max;
            String markerCode = marker.toString();
            int count = this.markerCounts.count((Object)markerCode);
            if (count > (max = this.maxFor(markerCode))) {
                this.markerCounts.setCount((Object)markerCode, max);
            }
            this.markerCounts.add((Object)markerCode, this.awardFor(markerCode));
            removals.remove(markerCode);
        }
        Multisets.removeOccurrences(this.markerCounts, removals);
        return this.markerCounts;
    }

    private int awardFor(String code) {
        Action action;
        if (this.experience != null && (action = this.experience.getActionForCode(code)) != null && action.getFramesAwarded() != null) {
            return action.getFramesAwarded();
        }
        return 2;
    }

    private int requiredFor(String code) {
        Action action;
        if (this.experience != null && (action = this.experience.getActionForCode(code)) != null && action.getFramesRequired() != null) {
            return action.getFramesRequired();
        }
        return 20;
    }

    private int maxFor(String code) {
        return this.requiredFor(code) * 4;
    }
}

