/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.horizon.artcodes.process;

import java.util.List;
import org.opencv.core.Mat;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;
import uk.ac.horizon.artcodes.detect.DetectorSetting;
import uk.ac.horizon.artcodes.detect.ImageBuffers;
import uk.ac.horizon.artcodes.detect.marker.MarkerDetectionHandler;
import uk.ac.horizon.artcodes.model.Experience;
import uk.ac.horizon.artcodes.process.ImageProcessor;
import uk.ac.horizon.artcodes.process.ImageProcessorFactory;
import uk.ac.horizon.artcodes.scanner.R;

public class TileThresholder
implements ImageProcessor {
    private transient int tiles = 1;
    private Display display = Display.none;

    @Override
    public void process(ImageBuffers buffers) {
        Imgproc.GaussianBlur((Mat)buffers.getImage(), (Mat)buffers.getImage(), (Size)new Size(5.0, 5.0), (double)0.0);
        if (this.display == Display.greyscale) {
            Imgproc.cvtColor((Mat)buffers.getImage(), (Mat)buffers.getOverlay(false), (int)9);
        }
        if (!buffers.hasDetected()) {
            this.tiles = this.tiles % 9 + 1;
        }
        int tileHeight = (int)buffers.getImage().size().height / this.tiles;
        int tileWidth = (int)buffers.getImage().size().width / this.tiles;
        for (int tileRow = 0; tileRow < this.tiles; ++tileRow) {
            int startRow = tileRow * tileHeight;
            int endRow = tileRow < this.tiles - 1 ? (tileRow + 1) * tileHeight : (int)buffers.getImage().size().height;
            for (int tileCol = 0; tileCol < this.tiles; ++tileCol) {
                int startCol = tileCol * tileWidth;
                int endCol = tileCol < this.tiles - 1 ? (tileCol + 1) * tileWidth : (int)buffers.getImage().size().width;
                Mat tileMat = buffers.getImage().submat(startRow, endRow, startCol, endCol);
                Imgproc.threshold((Mat)tileMat, (Mat)tileMat, (double)127.0, (double)255.0, (int)8);
                tileMat.release();
            }
        }
        if (this.display == Display.threshold) {
            Imgproc.cvtColor((Mat)buffers.getImage(), (Mat)buffers.getOverlay(false), (int)9);
        }
    }

    @Override
    public void getSettings(List<DetectorSetting> settings) {
        settings.add(new DetectorSetting(){

            @Override
            public void nextValue() {
                TileThresholder.this.display = TileThresholder.this.display.next();
            }

            @Override
            public int getIcon() {
                switch (TileThresholder.this.display) {
                    case none: {
                        return R.drawable.ic_image_24dp;
                    }
                    case greyscale: {
                        return R.drawable.ic_gradient_24dp;
                    }
                    case threshold: {
                        return R.drawable.ic_filter_b_and_w_24dp;
                    }
                }
                return 0;
            }

            @Override
            public int getText() {
                switch (TileThresholder.this.display) {
                    case none: {
                        return R.string.draw_threshold_off;
                    }
                    case greyscale: {
                        return R.string.draw_threshold_greyscale;
                    }
                    case threshold: {
                        return R.string.draw_threshold_on;
                    }
                }
                return 0;
            }
        });
    }

    private static enum Display {
        none,
        greyscale,
        threshold;

        private static final Display[] vals;

        public Display next() {
            return vals[(this.ordinal() + 1) % vals.length];
        }

        static {
            vals = Display.values();
        }
    }

    public static class Factory
    implements ImageProcessorFactory {
        @Override
        public String getName() {
            return "tile";
        }

        @Override
        public ImageProcessor create(Experience experience, MarkerDetectionHandler handler) {
            return new TileThresholder();
        }
    }
}

