/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.horizon.artcodes.process;

import android.util.Log;
import java.util.List;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.imgproc.Imgproc;
import uk.ac.horizon.artcodes.detect.DetectorSetting;
import uk.ac.horizon.artcodes.detect.ImageBuffers;
import uk.ac.horizon.artcodes.process.ImageProcessor;

public class HueShifter
implements ImageProcessor {
    private int hueShift;
    private transient Mat threeChannelBuffer = null;
    private transient byte[] colorPixelBuffer = null;

    public HueShifter() {
    }

    public HueShifter(int hueShift) {
        this.hueShift = hueShift;
    }

    public int getHueShift() {
        return this.hueShift;
    }

    public void setHueShift(int hueShift) {
        this.hueShift = hueShift;
    }

    @Override
    public void process(ImageBuffers buffers) {
        int desiredRows = buffers.getImage().rows() / 3 * 2;
        int desiredCols = buffers.getImage().cols();
        if (this.threeChannelBuffer == null || this.threeChannelBuffer.rows() != desiredRows || this.threeChannelBuffer.cols() != desiredCols) {
            Log.i((String)"hue", (String)"Creating new Mat buffer (1)");
            this.threeChannelBuffer = new Mat(desiredRows, desiredCols, CvType.CV_8UC3);
        }
        Imgproc.cvtColor((Mat)buffers.getImage(), (Mat)this.threeChannelBuffer, (int)93);
        this.justHueShiftImage(this.threeChannelBuffer, this.threeChannelBuffer);
    }

    @Override
    public void getSettings(List<DetectorSetting> settings) {
    }

    private void justHueShiftImage(Mat colorImage, Mat resultImage) {
        if (this.hueShift != 0) {
            Imgproc.cvtColor((Mat)colorImage, (Mat)resultImage, (int)52);
            int desiredBufferSize = colorImage.rows() * colorImage.cols() * colorImage.channels();
            if (this.colorPixelBuffer == null || this.colorPixelBuffer.length < desiredBufferSize) {
                Log.i((String)"hue", (String)("Creating new byte[" + desiredBufferSize + "] buffer (2)"));
                this.colorPixelBuffer = new byte[desiredBufferSize];
            }
            colorImage.get(0, 0, this.colorPixelBuffer);
            for (int i = 0; i < this.colorPixelBuffer.length; i += colorImage.channels()) {
                this.colorPixelBuffer[i] = (byte)((this.colorPixelBuffer[i] + this.hueShift) % 181);
            }
            colorImage.put(0, 0, this.colorPixelBuffer);
            Imgproc.cvtColor((Mat)resultImage, (Mat)resultImage, (int)60);
        }
    }
}

