/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.horizon.artcodes.detect;

import android.graphics.Bitmap;
import org.opencv.android.Utils;
import org.opencv.core.Core;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.Rect;
import org.opencv.core.Scalar;

public class ImageBuffers {
    private byte[] buffer;
    private Mat cameraImage;
    private Mat image;
    private Mat overlay;
    private Mat temp;
    private Bitmap overlayBitmap;
    private boolean overlayReady = false;
    private boolean detected = false;
    private boolean flip = false;
    private int rotations = 0;

    public Mat getImage() {
        return this.image;
    }

    public void setImage(byte[] data) {
        this.overlayReady = false;
        this.cameraImage.put(0, 0, data);
    }

    public byte[] createBuffer(int imageWidth, int imageHeight, int imageDepth) {
        this.buffer = new byte[imageWidth * imageHeight * imageDepth / 8];
        this.cameraImage = new Mat(imageHeight, imageWidth, CvType.CV_8UC1);
        return this.buffer;
    }

    public void setROI(Rect rect) {
        this.image = rect == null ? this.cameraImage : this.cameraImage.submat(rect);
    }

    public boolean hasDetected() {
        return this.detected;
    }

    public void setDetected(boolean detected) {
        this.detected = detected;
    }

    public Mat getOverlay() {
        return this.getOverlay(true);
    }

    public Bitmap createOverlayBitmap() {
        if (this.overlayReady) {
            if (this.overlayBitmap == null) {
                this.overlayBitmap = Bitmap.createBitmap((int)this.overlay.cols(), (int)this.overlay.rows(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            }
            Utils.matToBitmap((Mat)this.overlay, (Bitmap)this.overlayBitmap);
            return this.overlayBitmap;
        }
        if (this.overlayBitmap != null) {
            this.overlayBitmap = null;
        }
        return null;
    }

    public void setRotation(int rotation) {
        this.rotations = rotation / 90;
    }

    public void setFrontFacing(boolean frontFacing) {
        this.flip = frontFacing;
    }

    public Mat getTemp() {
        if (this.temp == null) {
            this.temp = new Mat(this.image.rows(), this.image.cols(), CvType.CV_8UC3);
        }
        return this.temp;
    }

    public Mat getOverlay(boolean clear) {
        if (this.overlayReady) {
            return this.overlay;
        }
        this.rotate(this.image);
        if (this.overlay == null) {
            this.overlay = new Mat(this.image.rows(), this.image.cols(), CvType.CV_8UC4);
        }
        if (clear) {
            this.overlay.setTo(new Scalar(0.0, 0.0, 0.0, 0.0));
        }
        this.overlayReady = true;
        return this.overlay;
    }

    private void rotate(Mat image) {
        int flip_horizontal_or_vertical;
        int n = flip_horizontal_or_vertical = this.rotations > 0 ? 1 : 0;
        if (this.flip) {
            flip_horizontal_or_vertical = -1;
        }
        for (int i = 0; i != this.rotations; ++i) {
            Core.transpose((Mat)image, (Mat)image);
            Core.flip((Mat)image, (Mat)image, (int)flip_horizontal_or_vertical);
        }
    }
}

