/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.horizon.artcodes.process;

import java.util.List;
import org.opencv.core.Size;
import uk.ac.horizon.artcodes.detect.DetectorSetting;
import uk.ac.horizon.artcodes.detect.ImageBuffers;
import uk.ac.horizon.artcodes.detect.marker.MarkerDetectionHandler;
import uk.ac.horizon.artcodes.model.Experience;
import uk.ac.horizon.artcodes.process.ImageProcessor;
import uk.ac.horizon.artcodes.process.ImageProcessorFactory;

public class RedFilter
implements ImageProcessor {
    @Override
    public void process(ImageBuffers buffers) {
        Size size = buffers.getTemp().size();
        int row = 0;
        while ((double)row < size.height) {
            int col = 0;
            while ((double)col < size.width) {
                byte[] data = new byte[4];
                buffers.getImage().get(row, col, data);
                byte y1 = data[0];
                byte y2 = data[2];
                byte v = data[2];
                byte rcomp = (byte)(1.14 * (double)v);
                int r1 = y1 + rcomp;
                int r2 = y2 + rcomp;
                data[0] = (byte)(0.299 * (double)r1);
                data[1] = 0;
                data[2] = (byte)(0.299 * (double)r2);
                data[3] = 0;
                buffers.getImage().put(row, col, data);
                col += 2;
            }
            ++row;
        }
    }

    @Override
    public void getSettings(List<DetectorSetting> settings) {
    }

    public static class Factory
    implements ImageProcessorFactory {
        @Override
        public String getName() {
            return "filter:red";
        }

        @Override
        public ImageProcessor create(Experience experience, MarkerDetectionHandler handler) {
            return new RedFilter();
        }
    }
}

