/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.horizon.artcodes.detect.marker;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.opencv.core.Mat;
import org.opencv.core.MatOfPoint;
import uk.ac.horizon.artcodes.detect.marker.Marker;
import uk.ac.horizon.artcodes.detect.marker.MarkerDetectionHandler;

public class MarkerCodeDetectionHandler
implements MarkerDetectionHandler {
    protected static final int REQUIRED = 20;
    protected static final int MAX = 80;
    protected static final int OCCURENCES = 2;
    protected final Multiset<String> markerCounts = HashMultiset.create();
    private CodeDetectionHandler markerCodeHandler;

    public MarkerCodeDetectionHandler(CodeDetectionHandler markerCodeHandler) {
        this.markerCodeHandler = markerCodeHandler;
    }

    @Override
    public void onMarkersDetected(Collection<Marker> markers, ArrayList<MatOfPoint> contours, Mat hierarchy) {
        this.actOnMarkers(this.countMarkers(markers));
    }

    protected void actOnMarkers(Multiset<String> markers) {
        int best = 0;
        String selected = null;
        for (String code : markers.elementSet()) {
            int count = markers.count((Object)code);
            if (count <= best) continue;
            selected = code;
            best = count;
        }
        if (selected != null || best >= 20) {
            this.markerCodeHandler.onMarkerCodeDetected(selected);
        }
    }

    protected Multiset<String> countMarkers(Collection<Marker> markers) {
        HashSet removals = new HashSet(this.markerCounts.elementSet());
        for (Marker marker : markers) {
            String markerCode = marker.toString();
            int count = this.markerCounts.count((Object)markerCode);
            if (count > 80) {
                this.markerCounts.setCount((Object)markerCode, 80);
            }
            this.markerCounts.add((Object)markerCode, 2);
            removals.remove(markerCode);
        }
        Multisets.removeOccurrences(this.markerCounts, removals);
        return this.markerCounts;
    }

    public static interface CodeDetectionHandler {
        public void onMarkerCodeDetected(String var1);
    }
}

