/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.horizon.artcodes;

import android.content.Context;
import android.content.SharedPreferences;

public final class Feature {
    private final Context context;
    private final int featureID;

    private Feature(Context context, int featureID) {
        this.context = context;
        this.featureID = featureID;
    }

    public static Feature get(Context context, int feature) {
        return new Feature(context, feature);
    }

    public int getId() {
        return this.featureID;
    }

    public String getName() {
        return this.context.getResources().getResourceEntryName(this.featureID);
    }

    public boolean isEnabled() {
        String featureName;
        SharedPreferences preferences = this.context.getSharedPreferences(Feature.class.getName(), 0);
        if (preferences.contains(featureName = this.getName())) {
            return preferences.getBoolean(featureName, false);
        }
        return this.context.getResources().getBoolean(this.featureID);
    }

    public void setEnabled(boolean enabled) {
        SharedPreferences preferences = this.context.getSharedPreferences(Feature.class.getName(), 0);
        String featureName = this.getName();
        preferences.edit().putBoolean(featureName, enabled).apply();
    }
}

