/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.horizon.artcodes.model;

import java.util.ArrayList;
import java.util.List;

public class Action {
    public static final String HTTP_PREFIX = "http://";
    private List<String> codes = new ArrayList<String>();
    private Match match = Match.any;
    private String url;
    private String name;
    private String description;
    private String image;
    private String owner;

    public List<String> getCodes() {
        return this.codes;
    }

    public String getDescription() {
        return this.description;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public Match getMatch() {
        return this.match;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUrl() {
        return this.url;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getDisplayUrl() {
        if (this.url != null && this.url.startsWith(HTTP_PREFIX)) {
            return this.url.substring(HTTP_PREFIX.length());
        }
        return this.url;
    }

    public void setMatch(Match match) {
        this.match = match;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Action ");
        builder.append(this.name);
        builder.append(" (");
        boolean comma = false;
        for (String code : this.codes) {
            if (comma) {
                if (this.match == Match.all) {
                    builder.append(" + ");
                } else if (this.match == Match.any) {
                    builder.append(", ");
                } else if (this.match == Match.sequence) {
                    builder.append(" -> ");
                }
            } else {
                comma = true;
            }
            builder.append(code);
        }
        builder.append(")");
        return builder.toString();
    }

    public static enum Match {
        any,
        all,
        sequence;

    }
}

