/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.horizon.artcodes.detect.marker;

import com.google.common.collect.Multiset;
import java.util.Collection;
import uk.ac.horizon.artcodes.detect.marker.Marker;
import uk.ac.horizon.artcodes.detect.marker.MarkerCodeDetectionHandler;
import uk.ac.horizon.artcodes.model.Action;
import uk.ac.horizon.artcodes.model.Experience;

public class MarkerActionDetectionHandler
extends MarkerCodeDetectionHandler {
    private ActionDetectionHandler markerActionHandler;
    private Experience experience;
    private Action currentAction;

    public MarkerActionDetectionHandler(ActionDetectionHandler markerActionHandler, Experience experience) {
        super(null);
        this.markerActionHandler = markerActionHandler;
        this.experience = experience;
    }

    @Override
    protected void actOnMarkers(Multiset<String> markers) {
        int best = 0;
        Action selected = null;
        for (Action action : this.experience.getActions()) {
            if (action.getMatch() == Action.Match.any) {
                for (String code : action.getCodes()) {
                    int count = markers.count((Object)code);
                    if (count <= best) continue;
                    selected = action;
                    best = count;
                }
                continue;
            }
            if (action.getMatch() != Action.Match.all) continue;
            int min = 80;
            int total = 0;
            for (String code : action.getCodes()) {
                int count = markers.count((Object)code);
                min = Math.min(min, count);
                total += count * 2;
            }
            if (min <= 20 || total <= best) continue;
            best = total;
            selected = action;
        }
        if (selected == null || best < 20) {
            if (this.currentAction != null) {
                this.currentAction = null;
                this.markerActionHandler.onMarkerActionDetected(null, null, null);
            }
        } else if (selected != this.currentAction) {
            this.currentAction = selected;
            this.markerActionHandler.onMarkerActionDetected(this.currentAction, null, null);
        }
    }

    public static interface ActionDetectionHandler {
        public void onMarkerActionDetected(Action var1, Collection<Marker> var2, Action var3);
    }
}

