/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.horizon.artcodes.detect;

import android.util.Log;
import java.util.StringTokenizer;
import org.opencv.core.Core;

class OpenCV {
    private static final String TAG = "OpenCV/OpenCV";

    OpenCV() {
    }

    public static boolean initOpenCV() {
        boolean result;
        String libs = "";
        Log.d((String)TAG, (String)"Trying to get library list");
        try {
            System.loadLibrary("opencv_info");
            libs = OpenCV.getLibraryList();
        }
        catch (UnsatisfiedLinkError e) {
            Log.e((String)TAG, (String)"OpenCV error: Cannot load info library for OpenCV");
        }
        Log.d((String)TAG, (String)("Library list: \"" + libs + "\""));
        Log.d((String)TAG, (String)"First attempt to load libs");
        if (OpenCV.initOpenCVLibs(libs)) {
            Log.d((String)TAG, (String)"First attempt to load libs is OK");
            String eol = System.getProperty("line.separator");
            for (String str : Core.getBuildInformation().split(eol)) {
                Log.i((String)TAG, (String)str);
            }
            result = true;
        } else {
            Log.d((String)TAG, (String)"First attempt to load libs fails");
            result = false;
        }
        return result;
    }

    private static boolean loadLibrary(String Name) {
        boolean result = true;
        Log.d((String)TAG, (String)("Trying to load library " + Name));
        try {
            System.loadLibrary(Name);
            Log.d((String)TAG, (String)"OpenCV libs init was ok!");
        }
        catch (UnsatisfiedLinkError e) {
            Log.d((String)TAG, (String)("Cannot load library \"" + Name + "\""));
            e.printStackTrace();
            result &= false;
        }
        return result;
    }

    private static boolean initOpenCVLibs(String Libs) {
        Log.d((String)TAG, (String)"Trying to init OpenCV libs");
        boolean result = true;
        if (null != Libs && Libs.length() != 0) {
            Log.d((String)TAG, (String)"Trying to load libs by dependency list");
            StringTokenizer splitter = new StringTokenizer(Libs, ";");
            while (splitter.hasMoreTokens()) {
                result &= OpenCV.loadLibrary(splitter.nextToken());
            }
        } else {
            result &= OpenCV.loadLibrary("opencv_java");
        }
        return result;
    }

    private static native String getLibraryList();
}

