/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.horizon.artcodes.detect;

import android.util.Log;
import java.util.HashMap;
import java.util.Map;
import org.opencv.core.Rect;
import uk.ac.horizon.artcodes.detect.Detector;
import uk.ac.horizon.artcodes.detect.marker.MarkerAreaOrderDetector;
import uk.ac.horizon.artcodes.detect.marker.MarkerDetectionHandler;
import uk.ac.horizon.artcodes.detect.marker.MarkerDetector;
import uk.ac.horizon.artcodes.detect.marker.MarkerEmbeddedChecksumDetector;
import uk.ac.horizon.artcodes.model.Experience;
import uk.ac.horizon.artcodes.process.ImageProcessor;
import uk.ac.horizon.artcodes.process.ImageProcessorFactory;
import uk.ac.horizon.artcodes.process.RedFilter;
import uk.ac.horizon.artcodes.process.TileThresholder;

public class ArtcodeDetector
extends Detector {
    private static final Map<String, ImageProcessorFactory> factoryRegistry = new HashMap<String, ImageProcessorFactory>();

    public ArtcodeDetector(Experience experience, MarkerDetectionHandler handler) {
        for (String processorName : experience.getPipeline()) {
            ImageProcessor processor = ArtcodeDetector.getProcessor(processorName, experience, handler);
            if (processor == null) continue;
            this.pipeline.add(processor);
        }
        if (this.pipeline.isEmpty()) {
            this.pipeline.add(new TileThresholder());
            this.pipeline.add(new MarkerDetector(experience, handler));
        }
    }

    private static void register(ImageProcessorFactory factory) {
        factoryRegistry.put(factory.getName(), factory);
    }

    private static ImageProcessor getProcessor(String string2, Experience experience, MarkerDetectionHandler handler) {
        ImageProcessorFactory factory = factoryRegistry.get(string2);
        if (factory != null) {
            try {
                return factory.create(experience, handler);
            }
            catch (Exception e) {
                Log.w((String)"detector", (String)e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    @Override
    protected Rect createROI(int imageWidth, int imageHeight, int surfaceWidth, int surfaceHeight) {
        int size = Math.min(imageWidth, imageHeight);
        int colStart = (imageWidth - size) / 2;
        int rowStart = (imageHeight - size) / 2;
        float surfaceMax = Math.max(surfaceHeight, surfaceWidth);
        float sizeRatio = surfaceMax / (float)Math.max(imageWidth, imageHeight);
        Log.i((String)"Detector", (String)("Size ratio = " + sizeRatio));
        if (this.callback != null) {
            int margin = (int)((float)Math.max(colStart, rowStart) * sizeRatio);
            Log.i((String)"Detector", (String)("Size = " + size + ", margin = " + margin));
            this.callback.detectionStart(margin);
        }
        return new Rect(colStart, rowStart, size, size);
    }

    static {
        ArtcodeDetector.register(new MarkerDetector.Factory());
        ArtcodeDetector.register(new MarkerEmbeddedChecksumDetector.Factory());
        ArtcodeDetector.register(new MarkerAreaOrderDetector.Factory());
        ArtcodeDetector.register(new TileThresholder.Factory());
        ArtcodeDetector.register(new RedFilter.Factory());
    }
}

