/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.horizon.artcodes;

import android.content.Context;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import uk.ac.horizon.artcodes.Feature;
import uk.ac.horizon.artcodes.model.Experience;
import uk.ac.horizon.artcodes.scanner.R;

public class ExperienceParser {
    private static Gson gson;

    public static Gson createGson(Context context) {
        if (gson == null) {
            GsonBuilder builder = new GsonBuilder();
            if (context == null || Feature.get(context, R.bool.feature_load_old_experiences).isEnabled()) {
                builder.registerTypeAdapterFactory((TypeAdapterFactory)new ExperienceTypeAdapterFactor());
            }
            gson = builder.create();
        }
        return gson;
    }

    private static class ExperienceTypeAdapterFactor
    implements TypeAdapterFactory {
        private ExperienceTypeAdapterFactor() {
        }

        public final <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            return type.getRawType() == Experience.class ? this.customizeMyClassAdapter(gson, type) : null;
        }

        private TypeAdapter<Experience> customizeMyClassAdapter(Gson gson, TypeToken<Experience> type) {
            final TypeAdapter delegate = gson.getDelegateAdapter((TypeAdapterFactory)this, type);
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            return new TypeAdapter<Experience>(){

                public Experience read(JsonReader in) throws IOException {
                    JsonElement tree = (JsonElement)elementAdapter.read(in);
                    if (tree.isJsonObject()) {
                        String id;
                        JsonObject jsonObject = tree.getAsJsonObject();
                        if (jsonObject.has("threshold") && jsonObject.get("threshold").isJsonPrimitive()) {
                            jsonObject.remove("threshold");
                        }
                        if (jsonObject.has("id") && !(id = jsonObject.get("id").getAsString()).contains(":")) {
                            jsonObject.addProperty("id", "http://aestheticodes.appspot.com/experience/" + id);
                        }
                        if (!jsonObject.has("pipeline")) {
                            JsonArray array = new JsonArray();
                            array.add((JsonElement)new JsonPrimitive("tile"));
                            if (jsonObject.has("embeddedChecksum") && jsonObject.get("embeddedChecksum") instanceof JsonPrimitive && jsonObject.get("embeddedChecksum").getAsBoolean()) {
                                array.add((JsonElement)new JsonPrimitive("detectEmbedded"));
                            } else {
                                array.add((JsonElement)new JsonPrimitive("detect"));
                            }
                            jsonObject.add("pipeline", (JsonElement)array);
                        }
                        if (jsonObject.has("markers")) {
                            JsonElement markers = jsonObject.get("markers");
                            jsonObject.add("actions", markers);
                            if (markers.isJsonArray()) {
                                JsonArray markerArray = markers.getAsJsonArray();
                                for (JsonElement element : markerArray) {
                                    if (!element.isJsonObject()) continue;
                                    JsonObject actionObject = element.getAsJsonObject();
                                    if (actionObject.has("title")) {
                                        actionObject.add("name", actionObject.get("title"));
                                    }
                                    if (actionObject.has("action")) {
                                        actionObject.add("url", actionObject.get("action"));
                                    }
                                    if (!actionObject.has("code")) continue;
                                    JsonArray codeArray = new JsonArray();
                                    codeArray.add(actionObject.get("code"));
                                    actionObject.add("codes", (JsonElement)codeArray);
                                }
                            }
                        }
                    }
                    return (Experience)delegate.fromJsonTree(tree);
                }

                public void write(JsonWriter out, Experience value) throws IOException {
                    delegate.write(out, (Object)value);
                }
            };
        }
    }
}

