/*
 * Decompiled with CFR 0.152.
 */
package hepple.postag;

import gate.util.BomStrippingInputStreamReader;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;

class Lexicon
extends HashMap<String, List<String>> {
    private static final long serialVersionUID = -2320126076517881896L;

    public Lexicon(URL lexiconURL) throws IOException {
        this(lexiconURL, null, " ");
    }

    public Lexicon(URL lexiconURL, String encoding) throws IOException {
        this(lexiconURL, encoding, " ");
    }

    public Lexicon(URL lexiconURL, String encoding, String separator) throws IOException {
        try (BomStrippingInputStreamReader lexiconReader = new BomStrippingInputStreamReader(lexiconURL.openStream(), encoding != null ? encoding : Charset.defaultCharset().name());){
            String line = lexiconReader.readLine();
            while (line != null) {
                int index = line.indexOf(separator.charAt(0));
                if (index < 0) {
                    throw new RuntimeException("Invalid lexicon file (no separator)!: " + line);
                }
                String entry = line.substring(0, index);
                StringTokenizer tokens = new StringTokenizer(line.substring(index + 1));
                ArrayList<String> categories = new ArrayList<String>();
                while (tokens.hasMoreTokens()) {
                    categories.add(tokens.nextToken());
                }
                this.put(entry, categories);
                line = lexiconReader.readLine();
            }
        }
    }
}

