/*
 * Decompiled with CFR 0.152.
 */
package gate.jape.parser;

import gate.event.StatusListener;
import gate.jape.BasicPatternElement;
import gate.jape.ComplexPatternElement;
import gate.jape.Constraint;
import gate.jape.ConstraintGroup;
import gate.jape.JapeConstants;
import gate.jape.JapeException;
import gate.jape.JapeFactory;
import gate.jape.KleeneOperator;
import gate.jape.LeftHandSide;
import gate.jape.MultiPhaseTransducer;
import gate.jape.PatternElement;
import gate.jape.RightHandSide;
import gate.jape.Rule;
import gate.jape.SinglePhaseTransducer;
import gate.jape.Transducer;
import gate.jape.constraint.AnnotationAccessor;
import gate.jape.constraint.SimpleAnnotationAccessor;
import gate.jape.parser.ParseCpslConstants;
import gate.jape.parser.ParseCpslTokenManager;
import gate.jape.parser.ParseException;
import gate.jape.parser.SimpleCharStream;
import gate.jape.parser.Token;
import gate.util.BomStrippingInputStreamReader;
import gate.util.Pair;
import gate.util.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParseCpsl
implements JapeConstants,
ParseCpslConstants {
    private static final long serialVersionUID = -2754817550046808372L;
    private static final Logger log = LoggerFactory.getLogger(ParseCpsl.class);
    private transient List<StatusListener> myStatusListeners = new LinkedList<StatusListener>();
    private int ruleNumber;
    private Set<String> bindingNameSet = null;
    protected Map<String, Object> macrosMap;
    protected Map<String, Pair> templatesMap;
    protected URL baseURL;
    protected String encoding;
    protected Class<? extends SinglePhaseTransducer> sptClass = SinglePhaseTransducer.class;
    protected SinglePhaseTransducer curSPT;
    public ParseCpslTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[53];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private final JJCalls[] jj_2_rtns = new JJCalls[2];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public ParseCpsl(URL url, String encoding) throws IOException {
        this(url, encoding, new HashMap<String, Object>());
    }

    public ParseCpsl(URL url, String encoding, Map<String, Object> existingMacros) throws IOException {
        this(url, encoding, existingMacros, new HashMap<String, Pair>());
    }

    public ParseCpsl(URL url, String encoding, Map<String, Object> existingMacros, Map<String, Pair> existingTemplates) throws IOException {
        this((Reader)new BomStrippingInputStreamReader(url.openStream(), encoding), existingMacros, existingTemplates);
        this.baseURL = url;
        this.encoding = encoding;
    }

    public ParseCpsl(Reader stream, Map<String, Object> existingMacros) {
        this(stream, existingMacros, new HashMap<String, Pair>());
    }

    public ParseCpsl(Reader stream, Map<String, Object> existingMacros, Map<String, Pair> existingTemplates) {
        this(stream);
        this.macrosMap = existingMacros;
        this.templatesMap = existingTemplates;
    }

    public void addStatusListener(StatusListener listener) {
        this.myStatusListeners.add(listener);
    }

    public void removeStatusListener(StatusListener listener) {
        this.myStatusListeners.remove(listener);
    }

    protected void fireStatusChangedEvent(String text) {
        Iterator<StatusListener> listenersIter = this.myStatusListeners.iterator();
        while (listenersIter.hasNext()) {
            listenersIter.next().statusChanged(text);
        }
    }

    protected SinglePhaseTransducer createSinglePhaseTransducer(String name) {
        try {
            Constructor<? extends SinglePhaseTransducer> c = this.sptClass.getConstructor(String.class);
            return c.newInstance(name);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    protected ParseCpsl spawn(URL sptURL) throws IOException {
        ParseCpsl newParser = new ParseCpsl(sptURL, this.encoding, this.macrosMap, this.templatesMap);
        newParser.setSptClass(this.sptClass);
        return newParser;
    }

    protected void finishSPT(SinglePhaseTransducer t) throws ParseException {
        if (this.ruleNumber == 0) {
            throw new ParseException("no rules defined in transducer " + t.getName());
        }
        t.setBaseURL(this.baseURL);
    }

    protected void finishBPE(BasicPatternElement bpe) {
    }

    public MultiPhaseTransducer MultiPhaseTransducer() throws ParseException {
        try {
            MultiPhaseTransducer multiPhaseTransducer = this._MultiPhaseTransducer();
            return multiPhaseTransducer;
        }
        finally {
            if (this.jj_input_stream.inputStream != null) {
                try {
                    this.jj_input_stream.inputStream.close();
                }
                catch (IOException e) {
                    log.warn("Couldn't close input stream while parsing " + this.baseURL, (Throwable)e);
                }
            }
        }
    }

    protected String toJavaIdentifier(String japeIdentifier) {
        return japeIdentifier.replace("-", "_");
    }

    protected String stringValueOf(Token tok) {
        if (tok.kind == 47) {
            return tok.image.substring(1, tok.image.length() - 1);
        }
        return tok.image;
    }

    protected void appendJavaStringLiteral(StringBuffer buf, String str) {
        if (str == null) {
            buf.append("null");
        } else {
            Formatter formatter = null;
            buf.append("\"");
            block10: for (int i = 0; i < str.length(); ++i) {
                char c = str.charAt(i);
                switch (c) {
                    case '\b': {
                        buf.append("\\b");
                        continue block10;
                    }
                    case '\f': {
                        buf.append("\\f");
                        continue block10;
                    }
                    case '\n': {
                        buf.append("\\n");
                        continue block10;
                    }
                    case '\r': {
                        buf.append("\\r");
                        continue block10;
                    }
                    case '\t': {
                        buf.append("\\t");
                        continue block10;
                    }
                    case '\"': {
                        buf.append("\\\"");
                        continue block10;
                    }
                    case '\'': {
                        buf.append("\\'");
                        continue block10;
                    }
                    case '\\': {
                        buf.append("\\\\");
                        continue block10;
                    }
                    default: {
                        if (c < ' ' || c > '\u007f') {
                            if (formatter == null) {
                                formatter = new Formatter(buf);
                            }
                            formatter.format("\\u%04X", c);
                            continue block10;
                        }
                        buf.append(c);
                    }
                }
            }
            buf.append("\"");
        }
    }

    protected void appendAnnotationAdd(StringBuffer blockBuffer, String newAnnotType, String annotSetName) {
        String nl = Strings.getNl();
        blockBuffer.append("      if(outputAS == inputAS) { // use nodes directly" + nl);
        blockBuffer.append("        outputAS.add(" + nl);
        blockBuffer.append("          " + annotSetName + ".firstNode(), ");
        blockBuffer.append(annotSetName + ".lastNode(), " + nl);
        blockBuffer.append("          ");
        this.appendJavaStringLiteral(blockBuffer, newAnnotType);
        blockBuffer.append(", features" + nl);
        blockBuffer.append("        );" + nl);
        blockBuffer.append("      }" + nl);
        blockBuffer.append("      else { // use offsets" + nl);
        blockBuffer.append("        try {" + nl);
        blockBuffer.append("          outputAS.add(" + nl);
        blockBuffer.append("            " + annotSetName + ".firstNode().getOffset(), ");
        blockBuffer.append(annotSetName + ".lastNode().getOffset(), " + nl);
        blockBuffer.append("            ");
        this.appendJavaStringLiteral(blockBuffer, newAnnotType);
        blockBuffer.append(", features" + nl);
        blockBuffer.append("          );" + nl);
        blockBuffer.append("        }" + nl);
        blockBuffer.append("        catch(gate.util.InvalidOffsetException ioe) {" + nl);
        blockBuffer.append("          throw new gate.util.GateRuntimeException(\"Invalid offset exception generated \" +" + nl);
        blockBuffer.append("               \"from offsets taken from same document!\");" + nl);
        blockBuffer.append("        }" + nl);
        blockBuffer.append("      }" + nl);
        blockBuffer.append("      // end of RHS assignment block");
    }

    protected Pair substituteTemplate(Token templateNameTok, Map<String, Object> values) throws ParseException {
        Pair template = this.templatesMap.get(templateNameTok.image);
        if (template == null) {
            throw new ParseException(this.errorMsgPrefix(templateNameTok) + "unknown template name " + templateNameTok.image);
        }
        Pair returnVal = null;
        HashSet<String> unusedParams = new HashSet<String>(values.keySet());
        if ((Integer)template.first == 47) {
            log.debug("Substituting template " + templateNameTok.image + " with map " + values + ". Template is " + template);
            StringBuffer buf = new StringBuffer();
            Matcher mat = Pattern.compile("\\$\\{([^\\}]+)\\}").matcher((String)template.second);
            while (mat.find()) {
                String key = mat.group(1);
                if (values.containsKey(key)) {
                    mat.appendReplacement(buf, Matcher.quoteReplacement(String.valueOf(values.get(key))));
                    unusedParams.remove(key);
                    continue;
                }
                mat.appendReplacement(buf, "\\${");
                buf.append(key);
                buf.append("}");
            }
            mat.appendTail(buf);
            returnVal = new Pair();
            returnVal.first = 47;
            returnVal.second = buf.toString();
            log.debug("Template substitution produced " + returnVal.second);
        } else {
            returnVal = template;
        }
        if (!unusedParams.isEmpty()) {
            throw new ParseException(this.errorMsgPrefix(templateNameTok) + "invalid parameters " + unusedParams + " for template " + templateNameTok.image);
        }
        return returnVal;
    }

    public void setBaseURL(URL newURL) {
        this.baseURL = newURL;
    }

    public void setEncoding(String newEncoding) {
        this.encoding = newEncoding;
    }

    public void setSptClass(Class<? extends SinglePhaseTransducer> sptClass) {
        this.sptClass = sptClass;
    }

    private String errorMsgPrefix(Token t) {
        return (this.baseURL != null ? this.baseURL.toExternalForm() : "(No URL)") + (t == null ? " " : ":" + t.beginLine + ":" + t.beginColumn + ": ");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final MultiPhaseTransducer _MultiPhaseTransducer() throws ParseException {
        MultiPhaseTransducer m;
        block36: {
            SinglePhaseTransducer s = null;
            m = new MultiPhaseTransducer();
            m.setBaseURL(this.baseURL);
            Token mptNameTok = null;
            Token phaseNameTok = null;
            String javaimportblock = null;
            String controllerstartedblock = null;
            String controllerfinishedblock = null;
            String controllerabortedblock = null;
            boolean haveControllerStartedBlock = false;
            boolean haveControllerFinishedBlock = false;
            boolean haveControllerAbortedBlock = false;
            switch (this.jj_nt.kind) {
                case 11: {
                    this.jj_consume_token(11);
                    mptNameTok = this.jj_consume_token(49);
                    m.setName(mptNameTok.image);
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                }
            }
            block6 : switch (this.jj_nt.kind) {
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: {
                    javaimportblock = this.JavaImportBlock();
                    block27: while (true) {
                        switch (this.jj_nt.kind) {
                            case 21: 
                            case 22: 
                            case 23: {
                                break;
                            }
                            default: {
                                this.jj_la1[1] = this.jj_gen;
                                break block6;
                            }
                        }
                        switch (this.jj_nt.kind) {
                            case 21: {
                                controllerstartedblock = this.ControllerStartedBlock();
                                if (haveControllerStartedBlock) {
                                    throw new ParseException("Only one ControllerStarted block allowed");
                                }
                                haveControllerStartedBlock = true;
                                continue block27;
                            }
                            case 22: {
                                controllerfinishedblock = this.ControllerFinishedBlock();
                                if (haveControllerFinishedBlock) {
                                    throw new ParseException("Only one ControllerFinished block allowed");
                                }
                                haveControllerFinishedBlock = true;
                                continue block27;
                            }
                            case 23: {
                                controllerabortedblock = this.ControllerAbortedBlock();
                                if (haveControllerAbortedBlock) {
                                    throw new ParseException("Only one ControllerAborted block allowed");
                                }
                                haveControllerAbortedBlock = true;
                                continue block27;
                            }
                        }
                        break;
                    }
                    this.jj_la1[2] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                case 12: {
                    this.jj_consume_token(12);
                    block28: while (true) {
                        List<Transducer> phases;
                        phaseNameTok = this.jj_consume_token(13);
                        ParseCpsl parser = null;
                        String sptPath = phaseNameTok.image + ".jape";
                        URL sptURL = null;
                        try {
                            sptURL = new URL(this.baseURL, sptPath);
                        }
                        catch (MalformedURLException mue) {
                            throw new ParseException(this.errorMsgPrefix(phaseNameTok) + "Read error " + mue.toString());
                        }
                        if (sptURL == null) {
                            throw new ParseException(this.errorMsgPrefix(phaseNameTok) + "Resource not found: base = " + this.baseURL.toString() + " path = " + sptPath);
                        }
                        this.fireStatusChangedEvent("Reading " + phaseNameTok.image + "...");
                        try {
                            parser = this.spawn(sptURL);
                        }
                        catch (IOException e) {
                            throw new ParseException(this.errorMsgPrefix(phaseNameTok) + "Cannot open URL " + sptURL.toExternalForm());
                        }
                        if (parser != null && (phases = parser.MultiPhaseTransducer().getPhases()) != null) {
                            for (int i = 0; i < phases.size(); ++i) {
                                m.addPhase(phases.get(i).getName(), phases.get(i));
                            }
                        }
                        switch (this.jj_nt.kind) {
                            case 13: {
                                continue block28;
                            }
                        }
                        break;
                    }
                    this.jj_la1[4] = this.jj_gen;
                    break block36;
                }
                default: {
                    this.jj_la1[5] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            block30: while (true) {
                try {
                    s = this.SinglePhaseTransducer(javaimportblock);
                    m.addPhase(s.getName(), s);
                    s.setBaseURL(this.baseURL);
                    s.setControllerEventBlocks(controllerstartedblock, controllerfinishedblock, controllerabortedblock, javaimportblock);
                    controllerstartedblock = null;
                    controllerfinishedblock = null;
                    controllerabortedblock = null;
                }
                catch (Throwable e) {
                    throw new ParseException("Cannot parse a phase in " + this.baseURL + ": " + e.getMessage());
                }
                switch (this.jj_nt.kind) {
                    case 24: {
                        continue block30;
                    }
                }
                break;
            }
            this.jj_la1[3] = this.jj_gen;
        }
        this.jj_consume_token(0);
        return m;
    }

    public final SinglePhaseTransducer SinglePhaseTransducer(String javaimportblock) throws ParseException {
        SinglePhaseTransducer t;
        block46: {
            Rule newRule;
            String phaseName;
            block45: {
                this.ruleNumber = 0;
                Token phaseNameTok = null;
                phaseName = null;
                Token inputTok = null;
                t = null;
                newRule = null;
                this.bindingNameSet = new HashSet<String>();
                Token optionNameTok = null;
                Token optionValueTok = null;
                this.jj_consume_token(24);
                phaseNameTok = this.jj_consume_token(49);
                phaseName = this.toJavaIdentifier(phaseNameTok.image);
                this.curSPT = t = this.createSinglePhaseTransducer(phaseName);
                block29: while (true) {
                    switch (this.jj_nt.kind) {
                        case 25: 
                        case 26: {
                            break;
                        }
                        default: {
                            this.jj_la1[6] = this.jj_gen;
                            break block45;
                        }
                    }
                    switch (this.jj_nt.kind) {
                        case 25: {
                            this.jj_consume_token(25);
                            while (true) {
                                switch (this.jj_nt.kind) {
                                    case 47: 
                                    case 49: {
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[7] = this.jj_gen;
                                        continue block29;
                                    }
                                }
                                switch (this.jj_nt.kind) {
                                    case 49: {
                                        inputTok = this.jj_consume_token(49);
                                        break;
                                    }
                                    case 47: {
                                        inputTok = this.jj_consume_token(47);
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[8] = this.jj_gen;
                                        this.jj_consume_token(-1);
                                        throw new ParseException();
                                    }
                                }
                                t.addInput(this.stringValueOf(inputTok));
                            }
                        }
                        case 26: {
                            this.jj_consume_token(26);
                            while (true) {
                                switch (this.jj_nt.kind) {
                                    case 49: {
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[9] = this.jj_gen;
                                        continue block29;
                                    }
                                }
                                optionNameTok = this.jj_consume_token(49);
                                this.jj_consume_token(63);
                                switch (this.jj_nt.kind) {
                                    case 49: {
                                        optionValueTok = this.jj_consume_token(49);
                                        break;
                                    }
                                    case 48: {
                                        optionValueTok = this.jj_consume_token(48);
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[10] = this.jj_gen;
                                        this.jj_consume_token(-1);
                                        throw new ParseException();
                                    }
                                }
                                t.setOption(optionNameTok.image, optionValueTok.image);
                                if (optionNameTok.image.equalsIgnoreCase("control")) {
                                    if (optionValueTok.image.equalsIgnoreCase("appelt")) {
                                        t.setRuleApplicationStyle(2);
                                        continue;
                                    }
                                    if (optionValueTok.image.equalsIgnoreCase("first")) {
                                        t.setRuleApplicationStyle(3);
                                        continue;
                                    }
                                    if (optionValueTok.image.equalsIgnoreCase("brill")) {
                                        t.setRuleApplicationStyle(1);
                                        continue;
                                    }
                                    if (optionValueTok.image.equalsIgnoreCase("once")) {
                                        t.setRuleApplicationStyle(4);
                                        continue;
                                    }
                                    if (optionValueTok.image.equalsIgnoreCase("all")) {
                                        t.setRuleApplicationStyle(5);
                                        continue;
                                    }
                                    System.err.println(this.errorMsgPrefix(optionValueTok) + "ignoring unknown control strategy " + 26 + " (should be brill, appelt, first, once or all)");
                                    continue;
                                }
                                if (optionNameTok.image.equalsIgnoreCase("debug")) {
                                    if (optionValueTok.image.equalsIgnoreCase("true") || optionValueTok.image.equalsIgnoreCase("yes") || optionValueTok.image.equalsIgnoreCase("y")) {
                                        t.setDebugMode(true);
                                        continue;
                                    }
                                    t.setDebugMode(false);
                                    continue;
                                }
                                if (optionNameTok.image.equalsIgnoreCase("matchGroup")) {
                                    if (optionValueTok.image.equalsIgnoreCase("true") || optionValueTok.image.equalsIgnoreCase("yes") || optionValueTok.image.equalsIgnoreCase("y")) {
                                        t.setMatchGroupMode(true);
                                        continue;
                                    }
                                    t.setMatchGroupMode(false);
                                    continue;
                                }
                                if (!optionNameTok.image.equalsIgnoreCase("negationGrouping")) continue;
                                if (optionValueTok.image.equalsIgnoreCase("false") || optionValueTok.image.equalsIgnoreCase("no") || optionValueTok.image.equalsIgnoreCase("n")) {
                                    t.setNegationCompatMode(true);
                                    continue;
                                }
                                t.setNegationCompatMode(false);
                            }
                        }
                    }
                    break;
                }
                this.jj_la1[11] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            block32: while (true) {
                switch (this.jj_nt.kind) {
                    case 27: 
                    case 28: 
                    case 29: {
                        break;
                    }
                    default: {
                        this.jj_la1[12] = this.jj_gen;
                        break block46;
                    }
                }
                switch (this.jj_nt.kind) {
                    case 27: {
                        newRule = this.Rule(phaseName, javaimportblock);
                        t.addRule(newRule);
                        continue block32;
                    }
                    case 28: {
                        this.MacroDef();
                        continue block32;
                    }
                    case 29: {
                        this.TemplateDef();
                        continue block32;
                    }
                }
                break;
            }
            this.jj_la1[13] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.finishSPT(t);
        if ("" != null) {
            return t;
        }
        throw new Error("Missing return statement in function");
    }

    public final String JavaImportBlock() throws ParseException {
        String defaultimportblock = "import gate.*;\nimport java.io.*;\nimport java.util.*;\nimport gate.util.*;\nimport gate.jape.*;\nimport gate.creole.ontology.*;\n";
        String importblock = null;
        switch (this.jj_nt.kind) {
            case 20: {
                this.jj_consume_token(20);
                this.jj_consume_token(57);
                importblock = this.ConsumeBlock();
                break;
            }
            default: {
                this.jj_la1[14] = this.jj_gen;
            }
        }
        if (importblock != null) {
            if ("" != null) {
                return defaultimportblock + importblock;
            }
        } else if ("" != null) {
            return defaultimportblock;
        }
        throw new Error("Missing return statement in function");
    }

    public final String ControllerStartedBlock() throws ParseException {
        String block = null;
        this.jj_consume_token(21);
        this.jj_consume_token(57);
        block = this.ConsumeBlock();
        if ("" != null) {
            return block;
        }
        throw new Error("Missing return statement in function");
    }

    public final String ControllerFinishedBlock() throws ParseException {
        String block = null;
        this.jj_consume_token(22);
        this.jj_consume_token(57);
        block = this.ConsumeBlock();
        if ("" != null) {
            return block;
        }
        throw new Error("Missing return statement in function");
    }

    public final String ControllerAbortedBlock() throws ParseException {
        String block = null;
        this.jj_consume_token(23);
        this.jj_consume_token(57);
        block = this.ConsumeBlock();
        if ("" != null) {
            return block;
        }
        throw new Error("Missing return statement in function");
    }

    public final Rule Rule(String phaseName, String currentImports) throws ParseException {
        Token ruleNameTok = null;
        String ruleName = null;
        Token priorityTok = null;
        int rulePriority = 0;
        LeftHandSide lhs = null;
        RightHandSide rhs = null;
        Rule newRule = null;
        this.bindingNameSet.clear();
        this.jj_consume_token(27);
        ruleNameTok = this.jj_consume_token(49);
        ruleName = this.toJavaIdentifier(ruleNameTok.image);
        switch (this.jj_nt.kind) {
            case 30: {
                this.jj_consume_token(30);
                priorityTok = this.jj_consume_token(35);
                try {
                    rulePriority = Integer.parseInt(priorityTok.image);
                }
                catch (NumberFormatException e) {
                    System.err.println(this.errorMsgPrefix(priorityTok) + "bad priority spec(" + priorityTok.image + "), rule(" + ruleName + ") - treating as 0");
                    rulePriority = 0;
                }
                break;
            }
            default: {
                this.jj_la1[15] = this.jj_gen;
            }
        }
        lhs = this.LeftHandSide();
        this.jj_consume_token(72);
        rhs = this.RightHandSide(phaseName, ruleName, lhs, currentImports);
        try {
            rhs.createActionClass();
        }
        catch (JapeException e) {
            throw new ParseException(this.errorMsgPrefix(null) + "couldn't create rule RHS: " + e.toString());
        }
        newRule = new Rule(ruleName, this.ruleNumber, rulePriority, lhs, rhs);
        if (this.curSPT.isInputRestricted()) {
            HashSet<String> set = new HashSet<String>();
            lhs.getConstraintGroup().getContainedAnnotationTypes(set);
            for (String type : set) {
                if (this.curSPT.hasInput(type)) continue;
                System.err.println(this.errorMsgPrefix(null) + "Rule " + ruleNameTok.image + " contains unlisted annotation type " + type);
            }
        }
        ++this.ruleNumber;
        if ("" != null) {
            return newRule;
        }
        throw new Error("Missing return statement in function");
    }

    public final void MacroDef() throws ParseException {
        Token macroNameTok = null;
        String[] body = null;
        this.jj_consume_token(28);
        macroNameTok = this.jj_consume_token(49);
        if (this.jj_2_1(2)) {
            body = this.PatternElement();
        } else {
            switch (this.jj_nt.kind) {
                case 49: 
                case 52: 
                case 57: 
                case 64: {
                    body = this.Action(false);
                    break;
                }
                default: {
                    this.jj_la1[16] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        this.macrosMap.put(macroNameTok.image, body);
    }

    public final void TemplateDef() throws ParseException {
        Token templateNameTok = null;
        Pair value = null;
        this.jj_consume_token(29);
        templateNameTok = this.jj_consume_token(49);
        this.jj_consume_token(63);
        value = this.AttrVal();
        this.templatesMap.put(templateNameTok.image, value);
    }

    public final LeftHandSide LeftHandSide() throws ParseException {
        ConstraintGroup cg = new ConstraintGroup();
        this.ConstraintGroup(cg);
        LeftHandSide lhs = new LeftHandSide(cg);
        Iterator<ComplexPatternElement> boundCPEs = cg.getCPEs();
        while (boundCPEs.hasNext()) {
            ComplexPatternElement cpe = boundCPEs.next();
            String bindingName = cpe.getBindingName();
            if (bindingName == null) continue;
            try {
                lhs.addBinding(bindingName, cpe, this.bindingNameSet);
            }
            catch (JapeException e) {
                System.err.println(this.errorMsgPrefix(null) + "duplicate binding name " + bindingName + " - ignoring this binding! exception was: " + e.toString());
            }
        }
        if ("" != null) {
            return lhs;
        }
        throw new Error("Missing return statement in function");
    }

    public final void ConstraintGroup(ConstraintGroup cg) throws ParseException {
        PatternElement pat = null;
        block9: while (true) {
            pat = this.PatternElement();
            cg.addPatternElement(pat);
            switch (this.jj_nt.kind) {
                case 47: 
                case 49: 
                case 57: 
                case 59: {
                    continue block9;
                }
            }
            break;
        }
        this.jj_la1[17] = this.jj_gen;
        block10: while (true) {
            switch (this.jj_nt.kind) {
                case 55: {
                    break;
                }
                default: {
                    this.jj_la1[18] = this.jj_gen;
                    break block10;
                }
            }
            this.jj_consume_token(55);
            cg.createDisjunction();
            block11: while (true) {
                pat = this.PatternElement();
                cg.addPatternElement(pat);
                switch (this.jj_nt.kind) {
                    case 47: 
                    case 49: 
                    case 57: 
                    case 59: {
                        continue block11;
                    }
                }
                break;
            }
            this.jj_la1[19] = this.jj_gen;
        }
    }

    public final PatternElement PatternElement() throws ParseException {
        PatternElement pat = null;
        Token macroRefTok = null;
        switch (this.jj_nt.kind) {
            case 49: {
                macroRefTok = this.jj_consume_token(49);
                Object macro = this.macrosMap.get(macroRefTok.image);
                if (macro == null) {
                    throw new ParseException(this.errorMsgPrefix(macroRefTok) + "unknown macro name " + macroRefTok.image);
                }
                if (macro instanceof String[]) {
                    throw new ParseException(this.errorMsgPrefix(macroRefTok) + "macro " + macroRefTok.image + " references an Action, not a PatternElement");
                }
                if (!(macro instanceof PatternElement)) {
                    throw new ParseException(this.errorMsgPrefix(macroRefTok) + "macro " + macroRefTok.image + " doesn't reference a PatternElement!");
                }
                pat = (PatternElement)((PatternElement)macro).clone();
                break;
            }
            case 47: 
            case 57: {
                pat = this.BasicPatternElement();
                break;
            }
            case 59: {
                pat = this.ComplexPatternElement();
                break;
            }
            default: {
                this.jj_la1[20] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return pat;
        }
        throw new Error("Missing return statement in function");
    }

    public final BasicPatternElement BasicPatternElement() throws ParseException {
        Token shortTok = null;
        Constraint c = null;
        BasicPatternElement bpe = new BasicPatternElement(this.curSPT);
        switch (this.jj_nt.kind) {
            case 57: {
                this.jj_consume_token(57);
                c = this.Constraint();
                bpe.addConstraint(c);
                block7: while (true) {
                    switch (this.jj_nt.kind) {
                        case 56: {
                            break;
                        }
                        default: {
                            this.jj_la1[21] = this.jj_gen;
                            break block7;
                        }
                    }
                    this.jj_consume_token(56);
                    c = this.Constraint();
                    bpe.addConstraint(c);
                }
                this.jj_consume_token(58);
                break;
            }
            case 47: {
                shortTok = this.jj_consume_token(47);
                System.err.println(this.errorMsgPrefix(shortTok) + "string shorthand not supported yet, ignoring: " + shortTok.image);
                break;
            }
            default: {
                this.jj_la1[22] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.finishBPE(bpe);
        if ("" != null) {
            return bpe;
        }
        throw new Error("Missing return statement in function");
    }

    public final ComplexPatternElement ComplexPatternElement() throws ParseException {
        KleeneOperator kleeneOperator = null;
        Token bindingNameTok = null;
        ConstraintGroup cg = new ConstraintGroup();
        this.jj_consume_token(59);
        this.ConstraintGroup(cg);
        this.jj_consume_token(60);
        switch (this.jj_nt.kind) {
            case 32: 
            case 61: {
                kleeneOperator = this.KleeneOperator();
                break;
            }
            default: {
                this.jj_la1[23] = this.jj_gen;
            }
        }
        block3 : switch (this.jj_nt.kind) {
            case 52: {
                this.jj_consume_token(52);
                switch (this.jj_nt.kind) {
                    case 49: {
                        bindingNameTok = this.jj_consume_token(49);
                        break block3;
                    }
                    case 35: {
                        bindingNameTok = this.jj_consume_token(35);
                        break block3;
                    }
                }
                this.jj_la1[24] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[25] = this.jj_gen;
            }
        }
        String bindingName = null;
        if (bindingNameTok != null) {
            bindingName = bindingNameTok.image;
        }
        if ("" != null) {
            return new ComplexPatternElement(cg, kleeneOperator, bindingName);
        }
        throw new Error("Missing return statement in function");
    }

    public final KleeneOperator KleeneOperator() throws ParseException {
        Token kleeneOpTok = null;
        Token minTok = null;
        Token maxTok = null;
        Integer min = null;
        Integer max = null;
        switch (this.jj_nt.kind) {
            case 32: {
                kleeneOpTok = this.jj_consume_token(32);
                if (kleeneOpTok == null && "" != null) {
                    return new KleeneOperator(KleeneOperator.Type.SINGLE);
                }
                KleeneOperator.Type type = KleeneOperator.Type.getFromSymbol(kleeneOpTok.image);
                if (type != null) {
                    if ("" == null) break;
                    return new KleeneOperator(type);
                }
                System.err.println(this.errorMsgPrefix(kleeneOpTok) + "ignoring uninterpretable Kleene op " + kleeneOpTok.image);
                if ("" == null) break;
                return new KleeneOperator(KleeneOperator.Type.SINGLE);
            }
            case 61: {
                this.jj_consume_token(61);
                minTok = this.jj_consume_token(35);
                switch (this.jj_nt.kind) {
                    case 56: {
                        this.jj_consume_token(56);
                        maxTok = this.jj_consume_token(35);
                        break;
                    }
                    default: {
                        this.jj_la1[26] = this.jj_gen;
                    }
                }
                this.jj_consume_token(62);
                if (minTok != null) {
                    min = new Integer(minTok.image);
                }
                max = maxTok != null ? new Integer(maxTok.image) : min;
                if ("" == null) break;
                return new KleeneOperator(min, max);
            }
            default: {
                this.jj_la1[27] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        throw new Error("Missing return statement in function");
    }

    public final Constraint Constraint() throws ParseException {
        Token annotTypeTok = null;
        Token metaPropertyTok = null;
        AnnotationAccessor accessor = null;
        Token opTok = null;
        Pair attrValPair = null;
        boolean negate = false;
        Constraint c = null;
        Constraint embeddedConstraint = null;
        String opString = null;
        switch (this.jj_nt.kind) {
            case 31: {
                this.jj_consume_token(31);
                negate = true;
                break;
            }
            default: {
                this.jj_la1[28] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 49: {
                annotTypeTok = this.jj_consume_token(49);
                break;
            }
            case 47: {
                annotTypeTok = this.jj_consume_token(47);
                break;
            }
            default: {
                this.jj_la1[29] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        c = JapeFactory.getConstraintFactory().createConstraint(this.stringValueOf(annotTypeTok));
        if (negate) {
            c.negate();
        }
        block7 : switch (this.jj_nt.kind) {
            case 34: 
            case 49: 
            case 54: {
                switch (this.jj_nt.kind) {
                    case 54: {
                        accessor = this.FeatureAccessor();
                        opTok = this.jj_consume_token(33);
                        attrValPair = this.AttrVal();
                        opString = opTok.image;
                        c.addAttribute(JapeFactory.getConstraintFactory().createPredicate(opString, accessor, attrValPair.second));
                        break block7;
                    }
                    case 34: {
                        this.jj_consume_token(34);
                        metaPropertyTok = this.jj_consume_token(49);
                        opTok = this.jj_consume_token(33);
                        attrValPair = this.AttrVal();
                        accessor = JapeFactory.getConstraintFactory().createMetaPropertyAccessor(metaPropertyTok.image);
                        opString = opTok.image;
                        c.addAttribute(JapeFactory.getConstraintFactory().createPredicate(opString, accessor, attrValPair.second));
                        break block7;
                    }
                    case 49: {
                        opTok = this.jj_consume_token(49);
                        switch (this.jj_nt.kind) {
                            case 57: {
                                this.jj_consume_token(57);
                                embeddedConstraint = this.Constraint();
                                this.jj_consume_token(58);
                                break;
                            }
                            case 31: 
                            case 47: 
                            case 49: {
                                embeddedConstraint = this.Constraint();
                                break;
                            }
                            default: {
                                this.jj_la1[30] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        opString = opTok.image;
                        accessor = new SimpleAnnotationAccessor();
                        c.addAttribute(JapeFactory.getConstraintFactory().createPredicate(opString, accessor, embeddedConstraint));
                        break block7;
                    }
                }
                this.jj_la1[31] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[32] = this.jj_gen;
            }
        }
        if ("" != null) {
            return c;
        }
        throw new Error("Missing return statement in function");
    }

    public final AnnotationAccessor FeatureAccessor() throws ParseException {
        Token attrNameTok = null;
        AnnotationAccessor accessor = null;
        this.jj_consume_token(54);
        switch (this.jj_nt.kind) {
            case 49: {
                attrNameTok = this.jj_consume_token(49);
                break;
            }
            case 47: {
                attrNameTok = this.jj_consume_token(47);
                break;
            }
            default: {
                this.jj_la1[33] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        accessor = JapeFactory.getConstraintFactory().createDefaultAccessor(this.stringValueOf(attrNameTok));
        if ("" != null) {
            return accessor;
        }
        throw new Error("Missing return statement in function");
    }

    public final Pair AttrVal() throws ParseException {
        Token attrValTok = null;
        Pair val = new Pair();
        switch (this.jj_nt.kind) {
            case 35: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                switch (this.jj_nt.kind) {
                    case 47: {
                        attrValTok = this.jj_consume_token(47);
                        break;
                    }
                    case 49: {
                        attrValTok = this.jj_consume_token(49);
                        break;
                    }
                    case 35: {
                        attrValTok = this.jj_consume_token(35);
                        break;
                    }
                    case 50: {
                        attrValTok = this.jj_consume_token(50);
                        break;
                    }
                    case 48: {
                        attrValTok = this.jj_consume_token(48);
                        break;
                    }
                    default: {
                        this.jj_la1[34] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                val.first = new Integer(attrValTok.kind);
                switch (attrValTok.kind) {
                    case 47: {
                        val.second = attrValTok.image.substring(1, attrValTok.image.length() - 1);
                        break;
                    }
                    case 35: {
                        try {
                            val.second = Long.valueOf(attrValTok.image);
                        }
                        catch (NumberFormatException e) {
                            System.err.println(this.errorMsgPrefix(attrValTok) + "couldn't parse integer " + attrValTok.image + " - treating as 0");
                            val.second = new Long(0L);
                        }
                        break;
                    }
                    case 49: {
                        val.second = new String(attrValTok.image);
                        break;
                    }
                    case 48: {
                        val.second = Boolean.valueOf(attrValTok.image);
                        break;
                    }
                    case 50: {
                        try {
                            val.second = Double.valueOf(attrValTok.image);
                        }
                        catch (NumberFormatException e) {
                            System.err.println(this.errorMsgPrefix(attrValTok) + "couldn't parse float " + attrValTok.image + " - treating as 0.0");
                            val.second = new Double(0.0);
                        }
                        break;
                    }
                    default: {
                        System.err.println(this.errorMsgPrefix(attrValTok) + "didn't understand type of " + attrValTok.image + ": ignoring");
                        val.second = new String("");
                    }
                }
                if ("" == null) break;
                return val;
            }
            case 61: {
                val = this.TemplateCall();
                if ("" == null) break;
                return val;
            }
            default: {
                this.jj_la1[35] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        throw new Error("Missing return statement in function");
    }

    public final Pair TemplateCall() throws ParseException {
        Token templateNameTok = null;
        Token attrNameTok = null;
        Pair attrVal = null;
        HashMap<String, Object> placeholders = new HashMap<String, Object>();
        this.jj_consume_token(61);
        templateNameTok = this.jj_consume_token(49);
        block6: while (true) {
            switch (this.jj_nt.kind) {
                case 49: {
                    break;
                }
                default: {
                    this.jj_la1[36] = this.jj_gen;
                    break block6;
                }
            }
            attrNameTok = this.jj_consume_token(49);
            this.jj_consume_token(63);
            attrVal = this.AttrVal();
            placeholders.put(attrNameTok.image, attrVal.second);
            switch (this.jj_nt.kind) {
                case 56: {
                    this.jj_consume_token(56);
                    continue block6;
                }
            }
            this.jj_la1[37] = this.jj_gen;
        }
        this.jj_consume_token(62);
        if ("" != null) {
            return this.substituteTemplate(templateNameTok, placeholders);
        }
        throw new Error("Missing return statement in function");
    }

    public final RightHandSide RightHandSide(String phaseName, String ruleName, LeftHandSide lhs, String imports) throws ParseException {
        String[] block = new String[2];
        RightHandSide rhs = new RightHandSide(phaseName, ruleName, lhs, imports);
        block = this.Action(true);
        rhs.addBlock(block[0], block[1]);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 56: {
                    break;
                }
                default: {
                    this.jj_la1[38] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(56);
            block = this.Action(true);
            rhs.addBlock(block[0], block[1]);
        }
        if ("" != null) {
            return rhs;
        }
        throw new Error("Missing return statement in function");
    }

    public final String[] Action(boolean checkLabel) throws ParseException {
        String[] block = new String[2];
        Token macroRefTok = null;
        if (this.jj_2_2(3)) {
            block = this.NamedJavaBlock(checkLabel);
        } else {
            switch (this.jj_nt.kind) {
                case 57: {
                    block = this.AnonymousJavaBlock();
                    break;
                }
                case 52: 
                case 64: {
                    block = this.AssignmentExpression(checkLabel);
                    break;
                }
                case 49: {
                    macroRefTok = this.jj_consume_token(49);
                    Object macro = this.macrosMap.get(macroRefTok.image);
                    if (macro == null) {
                        throw new ParseException(this.errorMsgPrefix(macroRefTok) + "unknown macro name " + macroRefTok.image);
                    }
                    if (macro instanceof PatternElement) {
                        throw new ParseException(this.errorMsgPrefix(macroRefTok) + "macro " + macroRefTok.image + " references a PatternElement, not an Action");
                    }
                    if (!(macro instanceof String[])) {
                        throw new ParseException(this.errorMsgPrefix(macroRefTok) + "macro " + macroRefTok.image + " doesn't reference an Action!");
                    }
                    block = (String[])macro;
                    if (block[0] == null || this.bindingNameSet.contains(block[0])) break;
                    throw new ParseException(this.errorMsgPrefix(macroRefTok) + "RHS macro reference " + macroRefTok.image + " refers to unknown label: " + block[0]);
                }
                default: {
                    this.jj_la1[39] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        if ("" != null) {
            return block;
        }
        throw new Error("Missing return statement in function");
    }

    public final String[] NamedJavaBlock(boolean checkLabel) throws ParseException {
        String[] block = new String[2];
        Token nameTok = null;
        this.jj_consume_token(52);
        nameTok = this.jj_consume_token(49);
        block[0] = nameTok.image;
        if (checkLabel && block[0] != null && !this.bindingNameSet.contains(block[0])) {
            throw new ParseException(this.errorMsgPrefix(nameTok) + "unknown label in RHS action: " + block[0]);
        }
        this.jj_consume_token(57);
        block[1] = this.ConsumeBlock();
        if ("" != null) {
            return block;
        }
        throw new Error("Missing return statement in function");
    }

    public final String[] AnonymousJavaBlock() throws ParseException {
        String[] block = new String[2];
        block[0] = null;
        this.jj_consume_token(57);
        block[1] = this.ConsumeBlock();
        if ("" != null) {
            return block;
        }
        throw new Error("Missing return statement in function");
    }

    public final String[] AssignmentExpression(boolean checkLabel) throws ParseException {
        String[] block = new String[2];
        StringBuffer blockBuffer = new StringBuffer();
        Token nameTok = null;
        Token opTok = null;
        String newAnnotType = null;
        String newAttrName = null;
        String nl = Strings.getNl();
        String annotSetName = null;
        Pair attrVal = null;
        String existingAnnotSetName = null;
        String existingAnnotType = null;
        String existingAttrName = null;
        String opName = null;
        blockBuffer.append("// RHS assignment block" + nl);
        blockBuffer.append("      gate.FeatureMap features = gate.Factory.newFeatureMap();" + nl);
        switch (this.jj_nt.kind) {
            case 52: {
                this.jj_consume_token(52);
                break;
            }
            case 64: {
                this.jj_consume_token(64);
                throw new ParseException(":+ not a legal operator (no multi-span annots)");
            }
            default: {
                this.jj_la1[40] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        nameTok = this.jj_consume_token(49);
        block[0] = nameTok.image;
        if (checkLabel && block[0] != null && !this.bindingNameSet.contains(block[0])) {
            throw new ParseException(this.errorMsgPrefix(nameTok) + "unknown label in RHS action: " + block[0]);
        }
        annotSetName = block[0] + "Annots";
        this.jj_consume_token(54);
        switch (this.jj_nt.kind) {
            case 49: {
                nameTok = this.jj_consume_token(49);
                break;
            }
            case 47: {
                nameTok = this.jj_consume_token(47);
                break;
            }
            default: {
                this.jj_la1[41] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        newAnnotType = this.stringValueOf(nameTok);
        blockBuffer.append("      java.lang.Object val = null;" + nl);
        this.jj_consume_token(63);
        this.jj_consume_token(57);
        block56: while (true) {
            switch (this.jj_nt.kind) {
                case 47: 
                case 49: 
                case 52: {
                    break;
                }
                default: {
                    this.jj_la1[42] = this.jj_gen;
                    break block56;
                }
            }
            block11 : switch (this.jj_nt.kind) {
                case 47: 
                case 49: {
                    switch (this.jj_nt.kind) {
                        case 49: {
                            nameTok = this.jj_consume_token(49);
                            break;
                        }
                        case 47: {
                            nameTok = this.jj_consume_token(47);
                            break;
                        }
                        default: {
                            this.jj_la1[43] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    this.jj_consume_token(63);
                    newAttrName = this.stringValueOf(nameTok);
                    switch (this.jj_nt.kind) {
                        case 35: 
                        case 47: 
                        case 48: 
                        case 49: 
                        case 50: 
                        case 61: {
                            attrVal = this.AttrVal();
                            switch ((Integer)attrVal.first) {
                                case 47: {
                                    blockBuffer.append("      val = ");
                                    this.appendJavaStringLiteral(blockBuffer, attrVal.second.toString());
                                    blockBuffer.append(";" + nl);
                                    break;
                                }
                                case 35: {
                                    blockBuffer.append("      try { val = java.lang.Long.valueOf(");
                                    this.appendJavaStringLiteral(blockBuffer, attrVal.second.toString());
                                    blockBuffer.append("); }" + nl + "      catch(java.lang.NumberFormatException e) { }" + nl);
                                    break;
                                }
                                case 49: {
                                    blockBuffer.append("      val = ");
                                    this.appendJavaStringLiteral(blockBuffer, attrVal.second.toString());
                                    blockBuffer.append(";" + nl);
                                    break;
                                }
                                case 48: {
                                    blockBuffer.append("      val = java.lang.Boolean.valueOf(");
                                    this.appendJavaStringLiteral(blockBuffer, attrVal.second.toString());
                                    blockBuffer.append(");" + nl);
                                    break;
                                }
                                case 50: {
                                    blockBuffer.append("      try { val = java.lang.Double.valueOf(");
                                    this.appendJavaStringLiteral(blockBuffer, attrVal.second.toString());
                                    blockBuffer.append("); }" + nl + "      catch(java.lang.NumberFormatException e) { }" + nl);
                                    break;
                                }
                                default: {
                                    blockBuffer.append("      val = \"\";" + nl);
                                }
                            }
                            blockBuffer.append("      features.put(");
                            this.appendJavaStringLiteral(blockBuffer, newAttrName);
                            blockBuffer.append(", val);");
                            blockBuffer.append(nl);
                            break block11;
                        }
                        case 52: {
                            this.jj_consume_token(52);
                            nameTok = this.jj_consume_token(49);
                            existingAnnotSetName = nameTok.image + "ExistingAnnots";
                            if (checkLabel && !this.bindingNameSet.contains(nameTok.image)) {
                                throw new ParseException(this.errorMsgPrefix(nameTok) + "unknown label in RHS action(2): " + nameTok.image);
                            }
                            blockBuffer.append("      { // need a block for the existing annot set" + nl + "        gate.AnnotationSet " + existingAnnotSetName + " = (gate.AnnotationSet)bindings.get(");
                            this.appendJavaStringLiteral(blockBuffer, nameTok.image);
                            blockBuffer.append("); " + nl + "        java.lang.Object existingFeatureValue;" + nl);
                            switch (this.jj_nt.kind) {
                                case 54: {
                                    this.jj_consume_token(54);
                                    switch (this.jj_nt.kind) {
                                        case 49: {
                                            nameTok = this.jj_consume_token(49);
                                            break;
                                        }
                                        case 47: {
                                            nameTok = this.jj_consume_token(47);
                                            break;
                                        }
                                        default: {
                                            this.jj_la1[44] = this.jj_gen;
                                            this.jj_consume_token(-1);
                                            throw new ParseException();
                                        }
                                    }
                                    existingAnnotType = this.stringValueOf(nameTok);
                                    switch (this.jj_nt.kind) {
                                        case 54: {
                                            opTok = this.jj_consume_token(54);
                                            break;
                                        }
                                        case 34: {
                                            opTok = this.jj_consume_token(34);
                                            break;
                                        }
                                        default: {
                                            this.jj_la1[45] = this.jj_gen;
                                            this.jj_consume_token(-1);
                                            throw new ParseException();
                                        }
                                    }
                                    switch (this.jj_nt.kind) {
                                        case 49: {
                                            nameTok = this.jj_consume_token(49);
                                            break;
                                        }
                                        case 47: {
                                            nameTok = this.jj_consume_token(47);
                                            break;
                                        }
                                        default: {
                                            this.jj_la1[46] = this.jj_gen;
                                            this.jj_consume_token(-1);
                                            throw new ParseException();
                                        }
                                    }
                                    opName = opTok.image;
                                    existingAttrName = this.stringValueOf(nameTok);
                                    blockBuffer.append("        if (" + existingAnnotSetName + " != null) {" + nl + "          gate.AnnotationSet existingAnnots = " + nl + "          " + existingAnnotSetName + ".get(");
                                    this.appendJavaStringLiteral(blockBuffer, existingAnnotType);
                                    blockBuffer.append(");" + nl + "          if (existingAnnots != null) {" + nl + "            java.util.Iterator iter = existingAnnots.iterator();" + nl + "            while(iter.hasNext()) {" + nl + "              gate.Annotation existingA = (gate.Annotation) iter.next();" + nl);
                                    if (opName.equals("@") && (existingAttrName.equals("string") || existingAttrName.equals("cleanString") || existingAttrName.equals("length"))) {
                                        blockBuffer.append("              int from = existingA.getStartNode().getOffset().intValue();" + nl + "              int to   = existingA.getEndNode().getOffset().intValue();" + nl + "              existingFeatureValue = doc.getContent().toString().substring(from,to);" + nl);
                                        if (existingAttrName.equals("cleanString")) {
                                            blockBuffer.append("                 existingFeatureValue = gate.Utils.cleanString((String)existingFeatureValue);" + nl);
                                        }
                                        if (existingAttrName.equals("length")) {
                                            blockBuffer.append("                 existingFeatureValue = (long)to - (long)from;" + nl);
                                        }
                                    } else {
                                        blockBuffer.append("existingFeatureValue = existingA.getFeatures().get(");
                                        this.appendJavaStringLiteral(blockBuffer, existingAttrName);
                                        blockBuffer.append(");" + nl);
                                    }
                                    blockBuffer.append("              if(existingFeatureValue != null) {" + nl + "                features.put(");
                                    this.appendJavaStringLiteral(blockBuffer, newAttrName);
                                    blockBuffer.append(", existingFeatureValue);" + nl + "                break;" + nl + "              }" + nl + "            } // while" + nl + "          } // if not null" + nl + "        } // if not null" + nl);
                                    break;
                                }
                                case 34: {
                                    opTok = this.jj_consume_token(34);
                                    nameTok = this.jj_consume_token(49);
                                    opName = opTok.image;
                                    existingAttrName = nameTok.image;
                                    if (opName.equals("@") && (existingAttrName.equals("string") || existingAttrName.equals("cleanString") || existingAttrName.equals("length"))) {
                                        blockBuffer.append("        if (" + existingAnnotSetName + " != null) {" + nl + "          int from = " + existingAnnotSetName + ".firstNode().getOffset().intValue();" + nl + "          int to   = " + existingAnnotSetName + ".lastNode().getOffset().intValue();" + nl + "          existingFeatureValue = doc.getContent().toString().substring(from,to);" + nl);
                                        if (existingAttrName.equals("cleanString")) {
                                            blockBuffer.append("                 existingFeatureValue = ((String)existingFeatureValue).replaceAll(\"\\\\s+\", \" \").trim();" + nl);
                                        }
                                        if (existingAttrName.equals("length")) {
                                            blockBuffer.append("                 existingFeatureValue = (long)to - (long)from;" + nl);
                                        }
                                        blockBuffer.append("          if(existingFeatureValue != null) {" + nl + "            features.put(");
                                        this.appendJavaStringLiteral(blockBuffer, newAttrName);
                                        blockBuffer.append(", existingFeatureValue);" + nl + "          }" + nl + "        } // if not null" + nl);
                                        break;
                                    }
                                    throw new ParseException(this.errorMsgPrefix(nameTok) + "Unsupported RHS meta-property " + nameTok.image);
                                }
                                default: {
                                    this.jj_la1[47] = this.jj_gen;
                                    this.jj_consume_token(-1);
                                    throw new ParseException();
                                }
                            }
                            blockBuffer.append("      } // block for existing annots" + nl);
                            break block11;
                        }
                    }
                    this.jj_la1[48] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                case 52: {
                    this.jj_consume_token(52);
                    nameTok = this.jj_consume_token(49);
                    existingAnnotSetName = nameTok.image + "ExistingAnnots";
                    if (checkLabel && !this.bindingNameSet.contains(nameTok.image)) {
                        throw new ParseException(this.errorMsgPrefix(nameTok) + "unknown label in RHS action(3): " + nameTok.image);
                    }
                    blockBuffer.append("      { // copy all features from this annotation" + nl + "        gate.AnnotationSet " + existingAnnotSetName + " = bindings.get(");
                    this.appendJavaStringLiteral(blockBuffer, nameTok.image);
                    blockBuffer.append(");" + nl);
                    switch (this.jj_nt.kind) {
                        case 54: {
                            this.jj_consume_token(54);
                            switch (this.jj_nt.kind) {
                                case 49: {
                                    nameTok = this.jj_consume_token(49);
                                    break;
                                }
                                case 47: {
                                    nameTok = this.jj_consume_token(47);
                                    break;
                                }
                                default: {
                                    this.jj_la1[49] = this.jj_gen;
                                    this.jj_consume_token(-1);
                                    throw new ParseException();
                                }
                            }
                            existingAnnotType = this.stringValueOf(nameTok);
                            blockBuffer.append("        " + existingAnnotSetName + " = " + existingAnnotSetName + ".get(");
                            this.appendJavaStringLiteral(blockBuffer, existingAnnotType);
                            blockBuffer.append(");" + nl);
                            break;
                        }
                        default: {
                            this.jj_la1[50] = this.jj_gen;
                        }
                    }
                    blockBuffer.append("        for(gate.Annotation a : " + existingAnnotSetName + ") {" + nl + "          if(a.getFeatures() != null && !a.getFeatures().isEmpty()) {" + nl + "            features.putAll(a.getFeatures());" + nl + "            break;" + nl + "          }" + nl + "        }" + nl + "      } // copy all features from this annotation" + nl);
                    break;
                }
                default: {
                    this.jj_la1[51] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            switch (this.jj_nt.kind) {
                case 56: {
                    this.jj_consume_token(56);
                    continue block56;
                }
            }
            this.jj_la1[52] = this.jj_gen;
        }
        this.jj_consume_token(58);
        this.appendAnnotationAdd(blockBuffer, newAnnotType, annotSetName);
        block[1] = blockBuffer.toString();
        if ("" != null) {
            return block;
        }
        throw new Error("Missing return statement in function");
    }

    void appendSpecials(Token tok, StringBuffer block) throws ParseException {
        if (tok != null) {
            this.appendSpecials(tok.specialToken, block);
            block.append(tok.image);
        }
    }

    String ConsumeBlock() throws ParseException, ParseException {
        StringBuffer block = new StringBuffer();
        int nesting = 1;
        Token nextTok = this.getNextToken();
        if (nextTok.kind == 0) {
            throw new ParseException(this.errorMsgPrefix(nextTok) + "Unexpected EOF in Java block");
        }
        Token blockStart = nextTok;
        while (blockStart.specialToken != null) {
            blockStart = blockStart.specialToken;
        }
        block.append("  // JAPE Source: " + this.baseURL + ":" + blockStart.beginLine + "\n");
        while (nesting != 0) {
            this.appendSpecials(nextTok.specialToken, block);
            if (nextTok.image.equals("{")) {
                ++nesting;
            } else if (nextTok.image.equals("}")) {
                --nesting;
            }
            if (nesting > 0) {
                if (nextTok.kind == 47) {
                    this.appendJavaStringLiteral(block, nextTok.image.substring(1, nextTok.image.length() - 1));
                } else {
                    block.append(nextTok.image);
                }
            }
            if (nesting == 0) continue;
            nextTok = this.getNextToken();
            if (nextTok.kind != 0) continue;
            throw new ParseException(this.errorMsgPrefix(nextTok) + "Unexpected EOF in Java block");
        }
        return block.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    private boolean jj_3R_27() {
        return this.jj_scan_token(31);
    }

    private boolean jj_3R_26() {
        return this.jj_3R_15();
    }

    private boolean jj_3R_25() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_27()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_scan_token(49)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(47)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_23() {
        return this.jj_scan_token(47);
    }

    private boolean jj_3R_21() {
        if (this.jj_scan_token(59)) {
            return true;
        }
        return this.jj_3R_24();
    }

    private boolean jj_3R_24() {
        Token xsp;
        if (this.jj_3R_26()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_26());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_19() {
        return this.jj_3R_21();
    }

    private boolean jj_3R_18() {
        return this.jj_3R_20();
    }

    private boolean jj_3R_16() {
        if (this.jj_scan_token(52)) {
            return true;
        }
        if (this.jj_scan_token(49)) {
            return true;
        }
        return this.jj_scan_token(57);
    }

    private boolean jj_3R_17() {
        return this.jj_scan_token(49);
    }

    private boolean jj_3R_22() {
        if (this.jj_scan_token(57)) {
            return true;
        }
        return this.jj_3R_25();
    }

    private boolean jj_3_2() {
        return this.jj_3R_16();
    }

    private boolean jj_3R_15() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_17()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_18()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_19()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_20() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_22()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_23()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_1() {
        return this.jj_3R_15();
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{2048, 0xE00000, 0xE00000, 0x1000000, 8192, 0x1F01000, 0x6000000, 0, 0, 0, 0, 0x6000000, 0x38000000, 0x38000000, 0x100000, 0x40000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, Integer.MIN_VALUE, 0, Integer.MIN_VALUE, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 0, 0, 0, 0, 0, 0, 163840, 163840, 131072, 196608, 0, 0, 0, 0, 0, 0x2120000, 167936000, 0x800000, 167936000, 167936000, 0x1000000, 0x2008000, 0x20000001, 131080, 0x100000, 0x1000000, 0x20000001, 0, 163840, 0x2028000, 0x420004, 0x420004, 163840, 491528, 537362440, 131072, 0x1000000, 0x1000000, 0x2120000, 0x100000, 163840, 1212416, 163840, 163840, 0x400004, 163840, 0x400004, 538411016, 163840, 0x400000, 1212416, 0x1000000};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    public ParseCpsl(InputStream stream) {
        this(stream, null);
    }

    public ParseCpsl(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new ParseCpslTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (i = 0; i < 53; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (i = 0; i < 53; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public ParseCpsl(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new ParseCpslTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (i = 0; i < 53; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        if (this.jj_input_stream == null) {
            this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        } else {
            this.jj_input_stream.ReInit(stream, 1, 1);
        }
        if (this.token_source == null) {
            this.token_source = new ParseCpslTokenManager(this.jj_input_stream);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (i = 0; i < 53; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public ParseCpsl(ParseCpslTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (i = 0; i < 53; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(ParseCpslTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (i = 0; i < 53; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = this.jj_nt;
        this.jj_nt = this.token.next != null ? this.jj_nt.next : (this.jj_nt.next = this.token_source.getNextToken());
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.jj_nt = this.token;
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.jj_nt;
        this.jj_nt = this.token.next != null ? this.jj_nt.next : (this.jj_nt.next = this.token_source.getNextToken());
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                boolean isMatched = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    isMatched = false;
                    break;
                }
                if (!isMatched) continue;
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[73];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 53; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) == 0) continue;
                la1tokens[64 + j] = true;
            }
        }
        for (i = 0; i < 73; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 2; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        ParseCpsl.jj_la1_init_0();
        ParseCpsl.jj_la1_init_1();
        ParseCpsl.jj_la1_init_2();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

