/*
 * Decompiled with CFR 0.152.
 */
package gate.jape;

import gate.AnnotationSet;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.creole.ontology.Ontology;
import gate.jape.ActionContext;
import gate.jape.JapeConstants;
import gate.jape.JapeException;
import gate.jape.LeftHandSide;
import gate.jape.NonFatalJapeException;
import gate.jape.RhsAction;
import gate.jape.SourceInfo;
import gate.util.Err;
import gate.util.GateClassLoader;
import gate.util.GateRuntimeException;
import gate.util.Javac;
import gate.util.Strings;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class RightHandSide
implements JapeConstants,
Serializable {
    private static final long serialVersionUID = -4359589687308736378L;
    private transient Object theActionObject;
    private StringBuffer actionClassString;
    private String actionClassName;
    private static String actionsDirName = "japeactionclasses";
    private String actionClassQualifiedName;
    private String actionClassJavaFileName;
    private String actionClassClassFileName;
    private transient SourceInfo sourceInfo;
    private transient GateClassLoader classloader;
    private static AtomicInteger actionClassNumber = new AtomicInteger();
    private Set<String> blockNames;
    private LeftHandSide lhs;
    private static List<File> tempFiles = new ArrayList<File>();
    private final String nl = Strings.getNl();
    static final boolean debug = false;
    private String phaseName;
    private String ruleName;

    public String getActionClassString() {
        return this.actionClassString.toString();
    }

    public String getActionClassName() {
        return this.actionClassQualifiedName;
    }

    public RightHandSide(String transducerName, String ruleName, LeftHandSide lhs, String importblock) {
        this.lhs = lhs;
        this.phaseName = transducerName;
        this.ruleName = ruleName;
        this.actionClassName = transducerName + ruleName + "ActionClass" + actionClassNumber.getAndIncrement();
        this.blockNames = new HashSet<String>();
        this.actionClassString = new StringBuffer("// " + this.actionClassName + this.nl + "package " + actionsDirName + "; " + this.nl + importblock + this.nl + "public class " + this.actionClassName + this.nl + "implements java.io.Serializable, gate.jape.RhsAction { " + this.nl + "  private gate.jape.ActionContext ctx;" + this.nl + "  public java.lang.String ruleName() { return \"" + ruleName + "\"; }" + this.nl + "  public java.lang.String phaseName() { return \"" + this.phaseName + "\"; }" + this.nl + "  public void setActionContext(gate.jape.ActionContext ac) { ctx = ac; }" + this.nl + "  public gate.jape.ActionContext getActionContext() { return ctx; }" + this.nl + "  public void doit(gate.Document doc, " + this.nl + "                   java.util.Map<java.lang.String, gate.AnnotationSet> bindings, " + this.nl + "                   gate.AnnotationSet inputAS, gate.AnnotationSet outputAS, " + this.nl + "                   gate.creole.ontology.Ontology ontology) throws gate.jape.JapeException {" + this.nl);
        this.actionClassJavaFileName = actionsDirName + File.separator + this.actionClassName.replace('.', File.separatorChar) + ".java";
        this.actionClassQualifiedName = actionsDirName.replace(File.separatorChar, '.').replace('/', '.').replace('\\', '.') + "." + this.actionClassName;
        this.actionClassClassFileName = this.actionClassQualifiedName.replace('.', File.separatorChar) + ".class";
        this.sourceInfo = new SourceInfo(this.actionClassQualifiedName, this.phaseName, ruleName);
    }

    public RightHandSide(RightHandSide existingRhs) {
        this.lhs = existingRhs.lhs;
        this.phaseName = existingRhs.phaseName;
        this.ruleName = existingRhs.ruleName;
        this.actionClassName = existingRhs.actionClassName;
        this.blockNames = existingRhs.blockNames;
        this.actionClassString = existingRhs.actionClassString;
        this.actionClassJavaFileName = existingRhs.actionClassJavaFileName;
        this.actionClassQualifiedName = existingRhs.actionClassQualifiedName;
        this.actionClassClassFileName = existingRhs.actionClassClassFileName;
        this.sourceInfo = existingRhs.sourceInfo;
        this.theActionObject = null;
    }

    public void addBlock(String anonymousBlock) {
        this.actionClassString.append(this.nl);
        this.actionClassString.append("if (true) {");
        this.actionClassString.append(this.nl);
        this.actionClassString.append(this.sourceInfo.addBlock(this.actionClassString.toString(), anonymousBlock));
        this.actionClassString.append(this.nl);
        this.actionClassString.append("}");
        this.actionClassString.append(this.nl);
    }

    public void addBlock(String name, String namedBlock) {
        if (name == null) {
            this.addBlock(namedBlock);
            return;
        }
        if (this.blockNames.add(name)) {
            this.actionClassString.append("    gate.AnnotationSet " + name + "Annots = bindings.get(\"" + name + "\"); " + this.nl);
        }
        this.actionClassString.append("    if(" + name + "Annots != null && " + name + "Annots.size() != 0) { " + this.nl);
        this.actionClassString.append(this.sourceInfo.addBlock(this.actionClassString.toString(), namedBlock));
        this.actionClassString.append(this.nl + "    }" + this.nl);
    }

    public void finish(GateClassLoader classloader) {
        this.classloader = classloader;
    }

    public void createActionClass() throws JapeException {
        this.actionClassString.append("  }" + this.nl + "}" + this.nl);
    }

    public void instantiateActionClass() throws JapeException {
        try {
            this.theActionObject = this.classloader.loadClass(this.actionClassQualifiedName).newInstance();
        }
        catch (Exception e) {
            throw new JapeException("couldn't create instance of action class " + this.actionClassName + ": " + e.getMessage());
        }
    }

    public static void cleanUp() {
        if (tempFiles.size() == 0) {
            return;
        }
        ListIterator<File> i = tempFiles.listIterator(tempFiles.size() - 1);
        while (i.hasPrevious()) {
            File tempFile = i.previous();
            tempFile.delete();
        }
        tempFiles.clear();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        try {
            Class class1 = this.classloader.loadClass(this.actionClassQualifiedName);
            out.writeObject(class1);
        }
        catch (ClassNotFoundException cnfe) {
            throw new GateRuntimeException((Throwable)cnfe);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        String className = this.getActionClassName();
        if (this.classloader == null) {
            this.classloader = Gate.getClassLoader().getDisposableClassLoader(in.toString(), true);
        }
        try {
            HashMap<String, String> actionClasses = new HashMap<String, String>();
            actionClasses.put(className, this.getActionClassString());
            Javac.loadClasses(actionClasses, (GateClassLoader)this.classloader);
        }
        catch (Exception e1) {
            throw new GateRuntimeException((Throwable)e1);
        }
    }

    public void transduce(Document doc, Map<String, AnnotationSet> bindings, AnnotationSet inputAS, final AnnotationSet outputAS, Ontology ontology, final ActionContext actionContext) throws JapeException {
        if (this.theActionObject == null) {
            this.instantiateActionClass();
        }
        try {
            ((RhsAction)this.theActionObject).setActionContext(actionContext);
            if (actionContext.isDebuggingEnabled()) {
                AnnotationSet outputASproxy = (AnnotationSet)Proxy.newProxyInstance((ClassLoader)this.classloader, new Class[]{AnnotationSet.class}, new InvocationHandler(){

                    @Override
                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        if (method.getName().equals("add")) {
                            int index = args.length - 1;
                            Class<?> lastArgType = method.getParameterTypes()[index];
                            if (lastArgType.equals(FeatureMap.class)) {
                                FeatureMap features = (FeatureMap)args[index];
                                if (features == null) {
                                    features = Factory.newFeatureMap();
                                    args[index] = features;
                                }
                                features.put((Object)"addedByPR", (Object)actionContext.getPRName());
                                features.put((Object)"addedByPhase", (Object)RightHandSide.this.getPhaseName());
                                features.put((Object)"addedByRule", (Object)RightHandSide.this.getRuleName());
                            }
                        }
                        return method.invoke((Object)outputAS, args);
                    }
                });
                ((RhsAction)this.theActionObject).doit(doc, bindings, inputAS, outputASproxy, ontology);
            } else {
                ((RhsAction)this.theActionObject).doit(doc, bindings, inputAS, outputAS, ontology);
            }
        }
        catch (NonFatalJapeException e) {
            Throwable t = e.getCause();
            Err.println((String)("A non-fatal JAPE exception occurred while processing document '" + doc.getName() + "'."));
            Err.println((String)("The issue occurred during execution of rule '" + this.getRuleName() + "' in phase '" + this.getPhaseName() + "':"));
            if (t != null) {
                this.sourceInfo.enhanceTheThrowable(t);
                t.printStackTrace(Err.getPrintWriter());
            } else {
                Err.println((String)"Line number and exception details are not available!");
            }
        }
        catch (Throwable e) {
            if (this.sourceInfo != null) {
                this.sourceInfo.enhanceTheThrowable(e);
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            if (e instanceof JapeException) {
                throw (JapeException)((Object)e);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new JapeException("Couldn't run RHS action", e);
        }
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String pad) {
        String nl = Strings.getNl();
        StringBuffer buf = new StringBuffer(pad + "RHS: actionClassName(" + this.actionClassName + "); ");
        buf.append("actionClassClassFileName(" + nl + this.actionClassClassFileName + nl);
        buf.append("actionClassJavaFileName(" + nl + this.actionClassJavaFileName + nl);
        buf.append("actionClassQualifiedName(" + nl + this.actionClassQualifiedName + nl);
        buf.append("blockNames(" + this.blockNames.toString() + "); ");
        buf.append(nl + pad + ") RHS." + nl);
        return buf.toString();
    }

    public String shortDesc() {
        String res = "" + this.actionClassName;
        return res;
    }

    public void setPhaseName(String phaseName) {
        this.phaseName = phaseName;
    }

    public String getPhaseName() {
        return this.phaseName;
    }

    public void setRuleName(String ruleName) {
        this.ruleName = ruleName;
    }

    public String getRuleName() {
        return this.ruleName;
    }
}

