/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.gazetteer;

import gate.util.GateRuntimeException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class GazetteerNode {
    private String entry;
    private Map<String, Object> featureMap = null;
    private String separator;

    public GazetteerNode(String entry, Map<String, Object> featureMap) {
        this.entry = entry;
        this.featureMap = featureMap;
    }

    public GazetteerNode(String node) {
        this(node, null, false);
    }

    public GazetteerNode(String node, String separator) {
        this(node, separator, false);
    }

    public GazetteerNode(String node, String separator, boolean isOrdered) {
        int index_sep;
        String string = this.separator = separator != null && separator.length() == 0 ? null : separator;
        if (this.separator == null || (index_sep = node.indexOf(this.separator)) == -1) {
            this.entry = node;
        } else {
            this.entry = node.substring(0, index_sep);
            String features = node.substring(index_sep + 1);
            this.featureMap = this.getFeatures(features, isOrdered);
        }
    }

    private Map<String, Object> getFeatures(String features, boolean isOrdered) {
        String[] pairs;
        if (this.separator == null) {
            return null;
        }
        ArrayList<String> tempPairs = new ArrayList<String>();
        int substr_begin = 0;
        int substr_end = features.indexOf(this.separator, substr_begin);
        while (substr_end != -1) {
            if (substr_end - substr_begin > 0) {
                tempPairs.add(features.substring(substr_begin, substr_end));
            }
            substr_begin = substr_end + 1;
            substr_end = features.indexOf(this.separator, substr_begin);
        }
        String lastPair = features.substring(substr_begin);
        if (lastPair.length() != 0) {
            tempPairs.add(lastPair);
        }
        if ((pairs = tempPairs.toArray(new String[tempPairs.size()])).length == 0) {
            return null;
        }
        HashMap featureMap = isOrdered ? new LinkedHashMap(pairs.length) : new HashMap(pairs.length);
        for (int i = 0; i < pairs.length; ++i) {
            String pair = pairs[i];
            int sep = pair.indexOf(61);
            if (sep == -1) {
                System.err.println("Odd pair: >" + pair + "<");
                throw new GateRuntimeException("Correct format for gazetteer entry features is: [entry]([separator][featureName]=[featureValue])*");
            }
            String name = pair.substring(0, sep).trim();
            String value = pair.substring(sep + 1).trim();
            if (name.length() <= 0 || value.length() <= 0) continue;
            featureMap.put(name, value);
        }
        if (featureMap.size() == 0) {
            return null;
        }
        return featureMap;
    }

    public String featureMapToString(Map<String, Object> featureMap) {
        StringBuffer str = new StringBuffer();
        if (featureMap instanceof LinkedHashMap) {
            for (Map.Entry<String, Object> entry : featureMap.entrySet()) {
                if (entry.getKey() == null || entry.getKey().trim().isEmpty() || entry.getValue() == null || entry.getValue().toString().isEmpty()) continue;
                str.append(this.separator).append(entry.getKey()).append("=").append(entry.getValue());
            }
        } else {
            ArrayList<String> sortedKeys = new ArrayList<String>(featureMap.keySet());
            Collections.sort(sortedKeys);
            for (String key : sortedKeys) {
                String value = featureMap.get(key).toString().trim();
                if (key.isEmpty() || value.isEmpty()) continue;
                str.append(this.separator).append(key).append("=").append(value);
            }
        }
        return str.toString();
    }

    public String toString() {
        if (this.featureMap == null || this.separator == null) {
            return this.entry;
        }
        return this.entry + this.featureMapToString(this.featureMap);
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof GazetteerNode) {
            result = this.toString().equals(o.toString());
        }
        return result;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String getEntry() {
        return this.entry;
    }

    public void setEntry(String entry) {
        this.entry = entry;
    }

    public Map<String, Object> getFeatureMap() {
        return this.featureMap;
    }

    public void setFeatureMap(Map<String, Object> featureMap) {
        this.featureMap = featureMap;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }
}

