/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.gazetteer;

import gate.creole.AbstractLanguageResource;
import gate.creole.ResourceInstantiationException;
import gate.creole.gazetteer.GazetteerNode;
import gate.util.BomStrippingInputStreamReader;
import gate.util.Files;
import gate.util.GateRuntimeException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Pattern;

public class GazetteerList
extends AbstractLanguageResource
implements List<GazetteerNode> {
    private static final long serialVersionUID = -812795422822719315L;
    public static final int LIST_MODE = 0;
    public static final int STRING_MODE = 1;
    private URL url;
    private String encoding = "UTF-8";
    private int mode = 0;
    private boolean isModified = false;
    private List<GazetteerNode> entries = new ArrayList<GazetteerNode>();
    private String content = null;
    private String separator;

    public boolean isModified() {
        return this.isModified;
    }

    public void setModified(boolean modified) {
        this.isModified = modified;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int m) {
        if (m != this.mode) {
            switch (m) {
                case 0: {
                    this.mode = m;
                    this.updateContent(this.content);
                    break;
                }
                case 1: {
                    this.content = this.toString();
                    this.mode = m;
                    break;
                }
                default: {
                    throw new GateRuntimeException("Invalid Mode =" + this.mode + "\nValid modes are:\nLIST_MODE = " + 0 + "\nSTRING_MODE = " + 1);
                }
            }
        }
    }

    public void setEncoding(String encod) {
        this.encoding = encod;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void load() throws ResourceInstantiationException {
        this.load(false);
    }

    public void load(boolean isOrdered) throws ResourceInstantiationException {
        if (null == this.url) {
            throw new ResourceInstantiationException("URL not specified (null).");
        }
        try (BomStrippingInputStreamReader listReader = new BomStrippingInputStreamReader(this.url.openStream(), this.encoding);){
            String line;
            int linenr = 0;
            Pattern emptyPattern = Pattern.compile("\\s*");
            while (null != (line = listReader.readLine())) {
                ++linenr;
                if (emptyPattern.matcher(line).matches()) continue;
                GazetteerNode node = null;
                try {
                    node = new GazetteerNode(line, this.separator, isOrdered);
                }
                catch (Exception ex) {
                    throw new GateRuntimeException("Could not read gazetteer entry " + linenr + " from URL " + this.getURL() + ": " + ex.getMessage(), (Throwable)ex);
                }
                this.entries.add(node);
            }
        }
        catch (Exception x) {
            throw new ResourceInstantiationException(x.getClass() + ":" + x.getMessage(), x);
        }
        this.isModified = false;
    }

    public void store() throws ResourceInstantiationException {
        try {
            if (null == this.url) {
                throw new ResourceInstantiationException("URL not specified (null)");
            }
            File fileo = Files.fileFromURL((URL)this.url);
            fileo.delete();
            OutputStreamWriter listWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(fileo), this.encoding);
            Iterator<GazetteerNode> iter = this.entries.iterator();
            while (iter.hasNext()) {
                listWriter.write(iter.next().toString());
                listWriter.write(13);
                listWriter.write(10);
            }
            listWriter.close();
        }
        catch (Exception x) {
            throw new ResourceInstantiationException(x.getClass() + ":" + x.getMessage());
        }
        this.isModified = false;
    }

    public void setURL(URL theUrl) {
        this.url = theUrl;
        this.isModified = true;
    }

    public URL getURL() {
        return this.url;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public boolean isEmpty() {
        return 0 == this.entries.size();
    }

    @Override
    public boolean contains(Object o) {
        return this.entries.contains(o);
    }

    @Override
    public Iterator<GazetteerNode> iterator() {
        return this.entries.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.entries.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.entries.toArray(a);
    }

    @Override
    public boolean add(GazetteerNode o) {
        boolean result = this.entries.add(o);
        this.isModified |= result;
        return result;
    }

    @Override
    public boolean remove(Object o) {
        boolean result = this.entries.remove(o);
        this.isModified |= result;
        return result;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.entries.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends GazetteerNode> c) {
        Iterator<? extends GazetteerNode> iter = c.iterator();
        boolean result = false;
        while (iter.hasNext()) {
            GazetteerNode o = iter.next();
            result |= this.entries.add(o);
        }
        this.isModified |= result;
        return result;
    }

    @Override
    public boolean addAll(int index, Collection<? extends GazetteerNode> c) {
        boolean result = this.entries.addAll(index, c);
        this.isModified |= result;
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean result = this.entries.removeAll(c);
        this.isModified |= result;
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean result = this.entries.retainAll(c);
        this.isModified |= result;
        return result;
    }

    @Override
    public void clear() {
        if (0 < this.entries.size()) {
            this.isModified = true;
        }
        this.entries.clear();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.entries == null ? 0 : this.entries.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GazetteerList other = (GazetteerList)obj;
        return !(this.entries == null ? other.entries != null : !this.entries.equals(other.entries));
    }

    @Override
    public GazetteerNode get(int index) {
        return this.entries.get(index);
    }

    @Override
    public GazetteerNode set(int index, GazetteerNode element) {
        this.isModified = true;
        return this.entries.set(index, element);
    }

    @Override
    public void add(int index, GazetteerNode element) {
        this.isModified = true;
        this.entries.add(index, element);
    }

    @Override
    public GazetteerNode remove(int index) {
        int size = this.entries.size();
        GazetteerNode result = this.entries.remove(index);
        this.isModified |= size != this.entries.size();
        return result;
    }

    @Override
    public int indexOf(Object o) {
        return this.entries.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.entries.lastIndexOf(o);
    }

    @Override
    public ListIterator<GazetteerNode> listIterator() {
        return this.entries.listIterator();
    }

    @Override
    public ListIterator<GazetteerNode> listIterator(int index) {
        return this.entries.listIterator(index);
    }

    @Override
    public List<GazetteerNode> subList(int fromIndex, int toIndex) {
        return this.entries.subList(fromIndex, toIndex);
    }

    public String toString() {
        String stres = null;
        switch (this.mode) {
            case 0: {
                StringBuffer result = new StringBuffer();
                String entry = null;
                for (int i = 0; i < this.entries.size(); ++i) {
                    GazetteerNode node = this.entries.get(i);
                    entry = node.getEntry().trim();
                    if (entry.length() <= 0) continue;
                    result.append(entry);
                    Map<String, Object> featureMap = node.getFeatureMap();
                    if (featureMap != null && featureMap.size() > 0) {
                        result.append(node.featureMapToString(featureMap));
                    }
                    result.append("\n");
                }
                stres = result.toString();
                break;
            }
            case 1: {
                stres = this.content;
                break;
            }
            default: {
                throw new GateRuntimeException("Invalid Mode =" + this.mode + "\nValid modes are:\nLIST_MODE = " + 0 + "\nSTRING_MODE = " + 1);
            }
        }
        return stres;
    }

    public void updateContent(String newContent) {
        switch (this.mode) {
            case 1: {
                this.content = newContent;
                break;
            }
            case 0: {
                BufferedReader listReader = new BufferedReader(new StringReader(newContent));
                ArrayList<GazetteerNode> tempEntries = new ArrayList<GazetteerNode>();
                try {
                    String line;
                    while (null != (line = listReader.readLine())) {
                        tempEntries.add(new GazetteerNode(line, this.separator));
                    }
                    listReader.close();
                }
                catch (IOException x) {
                    throw new GateRuntimeException("IOException :" + x.getMessage());
                }
                this.isModified = !tempEntries.equals(this.entries);
                this.clear();
                this.entries = tempEntries;
                break;
            }
            default: {
                throw new GateRuntimeException("Invalid Mode =" + this.mode + "\nValid modes are:\nLIST_MODE = " + 0 + "\nSTRING_MODE = " + 1);
            }
        }
    }
}

