/*
 * Decompiled with CFR 0.152.
 */
package gate.jape;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Controller;
import gate.Corpus;
import gate.CorpusController;
import gate.Document;
import gate.Gate;
import gate.Node;
import gate.annotation.AnnotationSetImpl;
import gate.creole.ExecutionException;
import gate.creole.ExecutionInterruptedException;
import gate.creole.ontology.Ontology;
import gate.event.ProgressListener;
import gate.fsm.FSM;
import gate.fsm.FSMInstance;
import gate.fsm.RuleTime;
import gate.fsm.State;
import gate.fsm.Transition;
import gate.jape.ActionContext;
import gate.jape.Constraint;
import gate.jape.ControllerEventBlocksAction;
import gate.jape.DefaultActionContext;
import gate.jape.JapeConstants;
import gate.jape.JapeException;
import gate.jape.PrioritisedRuleList;
import gate.jape.RightHandSide;
import gate.jape.Rule;
import gate.jape.SourceInfo;
import gate.jape.Transducer;
import gate.util.Benchmark;
import gate.util.GateClassLoader;
import gate.util.GateRuntimeException;
import gate.util.Javac;
import gate.util.SimpleSortedSet;
import gate.util.Strings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SinglePhaseTransducer
extends Transducer
implements JapeConstants,
Serializable {
    private static final long serialVersionUID = -2749474684496896114L;
    protected static final Logger log = LoggerFactory.getLogger(SinglePhaseTransducer.class);
    private static AtomicInteger actionClassNumber = new AtomicInteger();
    protected int ruleApplicationStyle = 1;
    protected PrioritisedRuleList rules;
    protected FSM fsm;
    protected List<FSMInstance> activeFSMInstances;
    private Map<String, String> optionSettings = new HashMap<String, String>();
    protected boolean finishedAlready;
    public Set<String> input = new HashSet<String>();
    private transient Vector<ProgressListener> progressListeners;
    private transient SourceInfo sourceInfo = null;
    private String controllerStartedEventBlock = "";
    private String controllerFinishedEventBlock = "";
    private String controllerAbortedEventBlock = "";
    private String javaImportsBlock = "";
    private Object controllerEventBlocksActionClass = null;
    private String controllerEventBlocksActionClassName;
    private static final String nl = Strings.getNl();
    private static final String controllerEventBlocksActionClassSourceTemplate = "package %%packagename%%;" + nl + "import java.io.*;" + nl + "import java.util.*;" + nl + "import gate.*;" + nl + "import gate.jape.*;" + nl + "import gate.creole.ontology.*;" + nl + "import gate.annotation.*;" + nl + "import gate.util.*;" + nl + "%%javaimports%%" + nl + nl + "public class %%classname%% implements ControllerEventBlocksAction {" + nl + "  private Ontology ontology;" + nl + "  public void setOntology(Ontology o) { ontology = o; }" + nl + "  public Ontology getOntology() { return ontology; }" + nl + "  private ActionContext ctx;" + nl + "  public void setActionContext(ActionContext ac) { ctx = ac; }" + nl + "  public ActionContext getActionContext() { return ctx; }" + nl + "  private Controller controller;" + nl + "  public void setController(Controller c) { controller = c; }" + nl + "  public Controller getController() { return controller; }" + nl + "  private Corpus corpus;" + nl + "  public void setCorpus(Corpus c) { corpus = c; }" + nl + "  public Corpus getCorpus() { return corpus; }" + nl + "  private Throwable throwable;" + nl + "  public void setThrowable(Throwable t) { throwable = t; }" + nl + "  public Throwable getThrowable() { return throwable; }" + nl + "  public void controllerExecutionStarted() {" + nl + "    %%started%%" + nl + "  }" + nl + "  public void controllerExecutionFinished() {" + nl + "    %%finished%%" + nl + "  }" + nl + "  public void controllerExecutionAborted() {" + nl + "    %%aborted%%" + nl + "  }" + nl + "}" + nl + "" + nl;

    public SinglePhaseTransducer(String name) {
        this.name = name;
        this.rules = new PrioritisedRuleList();
        this.finishedAlready = false;
    }

    public void setRuleApplicationStyle(int style) {
        this.ruleApplicationStyle = style;
    }

    public FSM getFSM() {
        return this.fsm;
    }

    public void addRule(Rule rule) {
        this.rules.add(rule);
    }

    public void setOption(String name, String setting) {
        this.optionSettings.put(name, setting);
    }

    public String getOption(String name) {
        return this.optionSettings.get(name);
    }

    @Override
    public void finish(GateClassLoader classLoader) {
        if (this.finishedAlready) {
            return;
        }
        this.finishedAlready = true;
        HashMap<String, String> actionClasses = new HashMap<String, String>(this.rules.size());
        for (Rule rule : this.rules) {
            rule.finish(classLoader);
            actionClasses.put(rule.getRHS().getActionClassName(), rule.getRHS().getActionClassString());
        }
        try {
            Javac.loadClasses(actionClasses, (GateClassLoader)classLoader);
        }
        catch (Exception e) {
            throw new GateRuntimeException((Throwable)e);
        }
        this.compileEventBlocksActionClass(classLoader);
        this.fsm = this.createFSM();
        this.rules.clear();
        this.rules = null;
    }

    protected FSM createFSM() {
        return new FSM(this);
    }

    private void addAnnotationsByOffset(SimpleSortedSet keys, Set<Annotation> annotations) {
        for (Annotation ann : annotations) {
            long offset = ann.getStartNode().getOffset();
            if (offset == ann.getEndNode().getOffset()) continue;
            keys.add(offset, (Object)ann);
        }
    }

    @Override
    public void transduce(Document doc, AnnotationSet inputAS, AnnotationSet outputAS) throws JapeException, ExecutionException {
        SimpleSortedSet offsets;
        this.interrupted = false;
        log.debug("Start: " + this.name);
        this.fireProgressChanged(0);
        SimpleSortedSet annotationsByOffset = offsets = new SimpleSortedSet();
        if (this.input.isEmpty()) {
            this.addAnnotationsByOffset(offsets, (Set<Annotation>)inputAS);
        } else {
            Iterator<String> typesIter = this.input.iterator();
            AnnotationSet ofOneType = null;
            while (typesIter.hasNext()) {
                ofOneType = inputAS.get(typesIter.next());
                if (ofOneType == null) continue;
                this.addAnnotationsByOffset(offsets, (Set<Annotation>)ofOneType);
            }
        }
        if (annotationsByOffset.isEmpty()) {
            this.fireProcessFinished();
            return;
        }
        annotationsByOffset.sort();
        if (this.activeFSMInstances == null) {
            this.activeFSMInstances = new LinkedList<FSMInstance>();
        } else {
            this.activeFSMInstances.clear();
        }
        LinkedList<FSMInstance> acceptingFSMInstances = new LinkedList<FSMInstance>();
        Node startNode = ((Annotation)((List)annotationsByOffset.get(offsets.first())).get(0)).getStartNode();
        long lastNodeOff = doc.getContent().size();
        long startNodeOff = startNode.getOffset();
        SearchState state = new SearchState(startNode, startNodeOff, 0L);
        while (state.startNodeOff != -1L) {
            boolean keepGoing;
            FSMInstance firstCurrentFSM = new FSMInstance(this.fsm, this.fsm.getInitialState(), state.startNode, state.startNode, new HashMap<String, AnnotationSet>(), doc);
            this.activeFSMInstances.clear();
            acceptingFSMInstances.clear();
            this.activeFSMInstances.add(firstCurrentFSM);
            while (!this.activeFSMInstances.isEmpty()) {
                if (this.interrupted) {
                    throw new ExecutionInterruptedException("The execution of the \"" + this.getName() + "\" Jape transducer has been abruptly interrupted!");
                }
                FSMInstance currentFSM = this.activeFSMInstances.remove(0);
                FSMMatcherResult result = this.attemptAdvance(currentFSM, offsets, annotationsByOffset, doc, inputAS);
                if (result == null) continue;
                if (result.acceptingFSMInstances != null && !result.acceptingFSMInstances.isEmpty()) {
                    acceptingFSMInstances.addAll(result.acceptingFSMInstances);
                    if (this.ruleApplicationStyle == 3 || this.ruleApplicationStyle == 4) break;
                }
                if (result.activeFSMInstances == null || result.activeFSMInstances.isEmpty()) continue;
                this.activeFSMInstances.addAll(result.activeFSMInstances);
            }
            if (!(keepGoing = this.fireRule(acceptingFSMInstances, state, lastNodeOff, offsets, inputAS, outputAS, doc, annotationsByOffset))) break;
            if (!((DefaultActionContext)this.actionContext).isPhaseEnded()) continue;
            ((DefaultActionContext)this.actionContext).setPhaseEnded(false);
            log.debug("Ending phase prematurely");
            break;
        }
        this.fireProcessFinished();
        if (Benchmark.isBenchmarkingEnabled()) {
            for (RuleTime r : this.fsm.getRuleTimes()) {
                String ruleName = r.getRuleName();
                long timeSpentOnRule = r.getTimeSpent();
                r.setTimeSpent(0L);
                Benchmark.checkPointWithDuration((long)timeSpentOnRule, (String)Benchmark.createBenchmarkId((String)("rule__" + ruleName), (String)this.getBenchmarkId()), (Object)this, (Map)this.benchmarkFeatures);
            }
        }
    }

    private FSMMatcherResult attemptAdvance(FSMInstance currentInstance, SimpleSortedSet offsets, SimpleSortedSet annotationsByOffset, Document document, AnnotationSet inputAS) {
        SimpleSortedSet offsetsTailSet;
        long theFirst;
        List paths;
        long startTime = 0L;
        if (Benchmark.isBenchmarkingEnabled()) {
            startTime = Benchmark.startPoint();
        }
        ArrayList<FSMInstance> newActiveInstances = null;
        ArrayList<FSMInstance> newAcceptingInstances = null;
        FSMInstance currentClone = (FSMInstance)currentInstance.clone();
        if (currentInstance.getFSMPosition().isFinal()) {
            if (newAcceptingInstances == null) {
                newAcceptingInstances = new ArrayList<FSMInstance>();
            }
            newAcceptingInstances.add(currentClone);
            if (this.ruleApplicationStyle == 3 || this.ruleApplicationStyle == 4) {
                if (Benchmark.isBenchmarkingEnabled()) {
                    this.updateRuleTime(currentInstance, startTime);
                }
                return new FSMMatcherResult(newActiveInstances, newAcceptingInstances);
            }
        }
        List list = paths = (theFirst = (offsetsTailSet = offsets.tailSet(currentInstance.getAGPosition().getOffset().longValue())).first()) >= 0L ? (List)annotationsByOffset.get(theFirst) : null;
        if (paths != null && !paths.isEmpty()) {
            State currentState = currentClone.getFSMPosition();
            Iterator transitionsIter = currentState.getTransitions().iterator();
            boolean newInstanceRequired = false;
            block0: while (transitionsIter.hasNext()) {
                List<Annotation> matchList;
                Constraint c;
                int i;
                Transition currentTransition = (Transition)transitionsIter.next();
                Constraint[] currentConstraints = currentTransition.getConstraints().getConstraints();
                boolean hasPositiveConstraint = false;
                List[] matchesByConstraint = new List[currentConstraints.length];
                for (i = 0; i < matchesByConstraint.length; ++i) {
                    matchesByConstraint[i] = null;
                }
                for (i = 0; i < currentConstraints.length; ++i) {
                    c = currentConstraints[i];
                    if (!c.isNegated()) {
                        hasPositiveConstraint = true;
                        continue;
                    }
                    matchList = c.matches(paths, this.ontology, inputAS);
                    if (!matchList.isEmpty()) continue block0;
                }
                if (hasPositiveConstraint) {
                    for (i = 0; i < currentConstraints.length; ++i) {
                        c = currentConstraints[i];
                        if (c.isNegated()) continue;
                        matchList = c.matches(paths, this.ontology, inputAS);
                        if (matchList.isEmpty()) continue block0;
                        matchesByConstraint[i] = matchList;
                    }
                } else {
                    matchesByConstraint[0] = paths;
                }
                ArrayList<List<Annotation>> matchLists = new ArrayList<List<Annotation>>();
                for (int i2 = 0; i2 < currentConstraints.length; ++i2) {
                    Constraint c2 = currentConstraints[i2];
                    List matchList2 = matchesByConstraint[i2];
                    if (matchList2 == null) continue;
                    matchLists.add(matchList2);
                }
                List<List<Annotation>> combinations = SinglePhaseTransducer.combine(matchLists, matchLists.size(), new LinkedList<Annotation>());
                for (List<Annotation> tuple : combinations) {
                    FSMInstance newFSMI;
                    Annotation matchingAnnot = this.getRightMostAnnotation(tuple);
                    if (newInstanceRequired) {
                        newFSMI = (FSMInstance)currentClone.clone();
                    } else {
                        newFSMI = currentInstance;
                        newInstanceRequired = true;
                    }
                    newFSMI.setAGPosition(matchingAnnot.getEndNode());
                    newFSMI.setFSMPosition(currentTransition.getTarget());
                    Map<String, AnnotationSet> binds = newFSMI.getBindings();
                    for (String oneLabel : currentTransition.getBindings()) {
                        AnnotationSet boundAnnots = binds.get(oneLabel);
                        AnnotationSetImpl newSet = boundAnnots != null ? new AnnotationSetImpl(boundAnnots) : new AnnotationSetImpl(document);
                        for (Annotation annot : tuple) {
                            newSet.add(annot);
                        }
                        binds.put(oneLabel, (AnnotationSet)newSet);
                    }
                    if (newActiveInstances == null) {
                        newActiveInstances = new ArrayList<FSMInstance>();
                    }
                    newActiveInstances.add(newFSMI);
                }
            }
        }
        if (Benchmark.isBenchmarkingEnabled()) {
            this.updateRuleTime(currentInstance, startTime);
        }
        return new FSMMatcherResult(newActiveInstances, newAcceptingInstances);
    }

    private void updateRuleTime(FSMInstance currentInstance, long startTime) {
        int index = currentInstance.getFSMPosition().getIndexInRuleList();
        currentInstance.getSupportGraph().getRuleTimes().get(index).addTime(Benchmark.startPoint() - startTime);
    }

    protected Annotation getRightMostAnnotation(Collection<Annotation> annots) {
        long maxOffset = -1L;
        Annotation retVal = null;
        for (Annotation annot : annots) {
            Long curOffset = annot.getEndNode().getOffset();
            if (curOffset <= maxOffset) continue;
            maxOffset = curOffset;
            retVal = annot;
        }
        return retVal;
    }

    private static List<List<Annotation>> combine(List<List<Annotation>> sourceLists, int maxTupleSize, List<Annotation> incompleteTuple) {
        LinkedList<List<Annotation>> newTupleList = new LinkedList<List<Annotation>>();
        if (incompleteTuple.size() == maxTupleSize) {
            newTupleList.add(incompleteTuple);
        } else {
            List<Annotation> currentSourceList = sourceLists.get(incompleteTuple.size());
            for (int i = 0; i < currentSourceList.size(); ++i) {
                LinkedList<Annotation> augmentedTuple = new LinkedList<Annotation>(incompleteTuple);
                augmentedTuple.add(currentSourceList.get(i));
                newTupleList.addAll(SinglePhaseTransducer.combine(sourceLists, maxTupleSize, augmentedTuple));
            }
        }
        return newTupleList;
    }

    protected boolean fireRule(List<FSMInstance> acceptingFSMInstances, SearchState state, long lastNodeOff, SimpleSortedSet offsets, AnnotationSet inputAS, AnnotationSet outputAS, Document doc, SimpleSortedSet annotationsByOffset) throws JapeException, ExecutionException {
        FSMInstance currentAcceptor;
        Iterator<FSMInstance> accFSMIter;
        Node startNode = state.startNode;
        long startNodeOff = state.startNodeOff;
        long oldStartNodeOff = state.oldStartNodeOff;
        long lastAGPosition = -1L;
        if (acceptingFSMInstances.isEmpty()) {
            lastAGPosition = startNodeOff + 1L;
        } else if (this.ruleApplicationStyle == 1 || this.ruleApplicationStyle == 5) {
            accFSMIter = acceptingFSMInstances.iterator();
            lastAGPosition = startNode.getOffset();
            while (accFSMIter.hasNext()) {
                long currentAGPosition;
                currentAcceptor = accFSMIter.next();
                RightHandSide currentRHS = currentAcceptor.getFSMPosition().getAction();
                currentRHS.transduce(doc, currentAcceptor.getBindings(), inputAS, outputAS, this.ontology, this.actionContext);
                if (this.ruleApplicationStyle != 1 || (currentAGPosition = currentAcceptor.getAGPosition().getOffset().longValue()) <= lastAGPosition) continue;
                lastAGPosition = currentAGPosition;
            }
            if (this.ruleApplicationStyle == 5) {
                ++lastAGPosition;
            }
        } else if (this.ruleApplicationStyle == 2 || this.ruleApplicationStyle == 3 || this.ruleApplicationStyle == 4) {
            Collections.sort(acceptingFSMInstances, Collections.reverseOrder());
            accFSMIter = acceptingFSMInstances.iterator();
            currentAcceptor = accFSMIter.next();
            if (this.isDebugMode()) {
                FSMInstance anAcceptor;
                Iterator<FSMInstance> accIter = acceptingFSMInstances.iterator();
                ArrayList<FSMInstance> conflicts = new ArrayList<FSMInstance>();
                while (accIter.hasNext() && (anAcceptor = accIter.next()).equals(currentAcceptor)) {
                    conflicts.add(anAcceptor);
                }
                if (conflicts.size() > 1) {
                    log.info("Conflicts found during matching:\n================================");
                    accIter = conflicts.iterator();
                    int i = 0;
                    while (accIter.hasNext()) {
                        if (!log.isInfoEnabled()) continue;
                        log.info(i++ + ") " + accIter.next().toString());
                    }
                }
            }
            RightHandSide currentRHS = currentAcceptor.getFSMPosition().getAction();
            currentRHS.transduce(doc, currentAcceptor.getBindings(), inputAS, outputAS, this.ontology, this.actionContext);
            if (this.isMatchGroupMode()) {
                FSMInstance rivalAcceptor;
                String currentAcceptorString = null;
                while (accFSMIter.hasNext() && (rivalAcceptor = accFSMIter.next()).compareTo(currentAcceptor) == 0) {
                    if (rivalAcceptor.equals(currentAcceptor)) continue;
                    if (this.isDebugMode()) {
                        if (currentAcceptorString == null) {
                            currentAcceptorString = currentAcceptor.toString();
                            if (log.isInfoEnabled()) {
                                log.info("~Jape Grammar Transducer : \nConcurrent Patterns by length,priority and index (all transduced):");
                                log.info(currentAcceptorString);
                                log.info("bindings : " + currentAcceptor.getBindings());
                                log.info("Rivals Follow: ");
                            }
                        }
                        if (log.isInfoEnabled()) {
                            log.info(rivalAcceptor.toString());
                            log.info("bindings : " + rivalAcceptor.getBindings());
                        }
                    }
                    currentRHS = rivalAcceptor.getFSMPosition().getAction();
                    currentRHS.transduce(doc, rivalAcceptor.getBindings(), inputAS, outputAS, this.ontology, this.actionContext);
                }
            }
            if (this.ruleApplicationStyle == 4) {
                state.startNodeOff = startNodeOff;
                return false;
            }
            lastAGPosition = currentAcceptor.getAGPosition().getOffset();
        } else {
            throw new RuntimeException("Unknown rule application style!");
        }
        SimpleSortedSet offsetsTailSet = offsets.tailSet(lastAGPosition);
        long theFirst = offsetsTailSet.first();
        if (theFirst < 0L) {
            startNodeOff = -1L;
            this.fireProcessFinished();
        } else {
            long nextKey = theFirst;
            startNode = ((Annotation)((List)annotationsByOffset.get(nextKey)).get(0)).getStartNode();
            startNodeOff = startNode.getOffset();
            if (oldStartNodeOff == startNodeOff) {
                lastAGPosition = startNodeOff + 1L;
                offsetsTailSet = offsets.tailSet(lastAGPosition);
                theFirst = offsetsTailSet.first();
                if (theFirst < 0L) {
                    startNodeOff = -1L;
                    this.fireProcessFinished();
                } else {
                    nextKey = theFirst;
                    startNode = ((Annotation)((List)annotationsByOffset.get(theFirst)).get(0)).getStartNode();
                    startNodeOff = startNode.getOffset();
                }
            }
            if (startNodeOff - oldStartNodeOff > 256L) {
                if (this.isInterrupted()) {
                    throw new ExecutionInterruptedException("The execution of the \"" + this.getName() + "\" Jape transducer has been abruptly interrupted!");
                }
                this.fireProgressChanged((int)(100L * startNodeOff / lastNodeOff));
                oldStartNodeOff = startNodeOff;
            }
        }
        state.oldStartNodeOff = oldStartNodeOff;
        state.startNodeOff = startNodeOff;
        state.startNode = startNode;
        return true;
    }

    @Override
    public void cleanUp() {
    }

    public String toString() {
        return this.toString("");
    }

    @Override
    public String toString(String pad) {
        String newline = Strings.getNl();
        String newPad = Strings.addPadding((String)pad, (int)4);
        StringBuffer buf = new StringBuffer(pad + "SPT: name(" + this.name + "); ruleApplicationStyle(");
        switch (this.ruleApplicationStyle) {
            case 2: {
                buf.append("APPELT_STYLE); ");
                break;
            }
            case 1: {
                buf.append("BRILL_STYLE); ");
                break;
            }
        }
        buf.append("rules(" + newline);
        if (this.rules != null) {
            Iterator rulesIterator = this.rules.iterator();
            while (rulesIterator.hasNext()) {
                buf.append(((Rule)rulesIterator.next()).toString(newPad) + " ");
            }
        }
        buf.append(newline + pad + ")." + newline);
        return buf.toString();
    }

    public PrioritisedRuleList getRules() {
        return this.rules;
    }

    public void addInput(String ident) {
        this.input.add(ident);
    }

    public boolean hasInput(String ident) {
        return this.input.isEmpty() || this.input.contains(ident);
    }

    public boolean isInputRestricted() {
        return !this.input.isEmpty();
    }

    @Override
    public synchronized void removeProgressListener(ProgressListener l) {
        if (this.progressListeners != null && this.progressListeners.contains(l)) {
            Vector v = (Vector)this.progressListeners.clone();
            v.removeElement(l);
            this.progressListeners = v;
        }
    }

    @Override
    public synchronized void addProgressListener(ProgressListener l) {
        Vector v;
        Vector vector = v = this.progressListeners == null ? new Vector(2) : (Vector)this.progressListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.progressListeners = v;
        }
    }

    @Override
    protected void fireProgressChanged(int e) {
        if (this.progressListeners != null) {
            Vector<ProgressListener> listeners = this.progressListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                listeners.elementAt(i).progressChanged(e);
            }
        }
    }

    @Override
    protected void fireProcessFinished() {
        if (this.progressListeners != null) {
            Vector<ProgressListener> listeners = this.progressListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                listeners.elementAt(i).processFinished();
            }
        }
    }

    public int getRuleApplicationStyle() {
        return this.ruleApplicationStyle;
    }

    public void setControllerEventBlocks(String started, String finished, String aborted, String javaimports) {
        this.controllerStartedEventBlock = started;
        this.controllerFinishedEventBlock = finished;
        this.controllerAbortedEventBlock = aborted;
        this.javaImportsBlock = javaimports;
    }

    public String generateControllerEventBlocksCode(String packageName, String className) {
        String sourceCode = null;
        if (this.controllerStartedEventBlock != null || this.controllerFinishedEventBlock != null || this.controllerAbortedEventBlock != null) {
            sourceCode = controllerEventBlocksActionClassSourceTemplate;
            String ceb_classname = className;
            if (className == null || className.isEmpty()) {
                boolean neednewclassname = true;
                while (neednewclassname) {
                    ceb_classname = "ControllerEventBlocksActionClass" + actionClassNumber.getAndIncrement();
                    this.controllerEventBlocksActionClassName = packageName + "." + ceb_classname;
                    try {
                        Gate.getClassLoader().loadClass(this.controllerEventBlocksActionClassName);
                        neednewclassname = true;
                    }
                    catch (ClassNotFoundException e) {
                        neednewclassname = false;
                    }
                }
            }
            sourceCode = sourceCode.replace("%%classname%%", ceb_classname).replace("%%packagename%%", packageName);
            this.sourceInfo = new SourceInfo(this.controllerEventBlocksActionClassName, this.name, "controllerEvents");
            sourceCode = sourceCode.replace("%%javaimports%%", this.javaImportsBlock != null ? this.javaImportsBlock : "// no 'Imports:' block for more imports defined");
            int index = sourceCode.indexOf("%%started%%");
            String previousCode = sourceCode.substring(0, index).trim();
            sourceCode = sourceCode.replace("%%started%%", this.controllerStartedEventBlock != null ? this.sourceInfo.addBlock(previousCode, this.controllerStartedEventBlock) : "// no code defined");
            index = sourceCode.indexOf("%%finished%%");
            previousCode = sourceCode.substring(0, index).trim();
            sourceCode = sourceCode.replace("%%finished%%", this.controllerFinishedEventBlock != null ? this.sourceInfo.addBlock(previousCode, this.controllerFinishedEventBlock) : "// no code defined");
            index = sourceCode.indexOf("%%aborted%%");
            previousCode = sourceCode.substring(0, index).trim();
            sourceCode = sourceCode.replace("%%aborted%%", this.controllerAbortedEventBlock != null ? this.sourceInfo.addBlock(previousCode, this.controllerAbortedEventBlock) : "// no code defined");
        }
        return sourceCode;
    }

    @Override
    public void runControllerExecutionStartedBlock(ActionContext ac, Controller c, Ontology o) throws ExecutionException {
        if (this.controllerEventBlocksActionClass != null) {
            ((ControllerEventBlocksAction)this.controllerEventBlocksActionClass).setController(c);
            ((ControllerEventBlocksAction)this.controllerEventBlocksActionClass).setOntology(o);
            ((ControllerEventBlocksAction)this.controllerEventBlocksActionClass).setActionContext(ac);
            if (c instanceof CorpusController) {
                Corpus corpus = ((CorpusController)c).getCorpus();
                ((ControllerEventBlocksAction)this.controllerEventBlocksActionClass).setCorpus(corpus);
            } else {
                ((ControllerEventBlocksAction)this.controllerEventBlocksActionClass).setCorpus(null);
            }
            ((ControllerEventBlocksAction)this.controllerEventBlocksActionClass).setThrowable(null);
            try {
                ((ControllerEventBlocksAction)this.controllerEventBlocksActionClass).controllerExecutionStarted();
            }
            catch (Throwable e) {
                if (this.sourceInfo != null) {
                    this.sourceInfo.enhanceTheThrowable(e);
                }
                if (e instanceof Error) {
                    throw (Error)e;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new ExecutionException("Couldn't run controller started action", e);
            }
        }
    }

    @Override
    public void runControllerExecutionFinishedBlock(ActionContext ac, Controller c, Ontology o) throws ExecutionException {
        if (this.controllerEventBlocksActionClass != null) {
            ((ControllerEventBlocksAction)this.controllerEventBlocksActionClass).setController(c);
            ((ControllerEventBlocksAction)this.controllerEventBlocksActionClass).setOntology(o);
            ((ControllerEventBlocksAction)this.controllerEventBlocksActionClass).setActionContext(ac);
            if (c instanceof CorpusController) {
                Corpus corpus = ((CorpusController)c).getCorpus();
                ((ControllerEventBlocksAction)this.controllerEventBlocksActionClass).setCorpus(corpus);
            } else {
                ((ControllerEventBlocksAction)this.controllerEventBlocksActionClass).setCorpus(null);
            }
            ((ControllerEventBlocksAction)this.controllerEventBlocksActionClass).setThrowable(null);
            try {
                ((ControllerEventBlocksAction)this.controllerEventBlocksActionClass).controllerExecutionFinished();
            }
            catch (Throwable e) {
                if (this.sourceInfo != null) {
                    this.sourceInfo.enhanceTheThrowable(e);
                }
                if (e instanceof Error) {
                    throw (Error)e;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new ExecutionException("Couldn't run controller finished action", e);
            }
        }
    }

    @Override
    public void runControllerExecutionAbortedBlock(ActionContext ac, Controller c, Throwable t, Ontology o) throws ExecutionException {
        if (this.controllerEventBlocksActionClass != null) {
            ((ControllerEventBlocksAction)this.controllerEventBlocksActionClass).setController(c);
            ((ControllerEventBlocksAction)this.controllerEventBlocksActionClass).setOntology(o);
            ((ControllerEventBlocksAction)this.controllerEventBlocksActionClass).setActionContext(ac);
            if (c instanceof CorpusController) {
                Corpus corpus = ((CorpusController)c).getCorpus();
                ((ControllerEventBlocksAction)this.controllerEventBlocksActionClass).setCorpus(corpus);
            } else {
                ((ControllerEventBlocksAction)this.controllerEventBlocksActionClass).setCorpus(null);
            }
            ((ControllerEventBlocksAction)this.controllerEventBlocksActionClass).setThrowable(t);
            try {
                ((ControllerEventBlocksAction)this.controllerEventBlocksActionClass).controllerExecutionAborted();
            }
            catch (Throwable e) {
                if (this.sourceInfo != null) {
                    this.sourceInfo.enhanceTheThrowable(e);
                }
                if (e instanceof Error) {
                    throw (Error)e;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new ExecutionException("Couldn't run controller aborted action", e);
            }
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        Object save = this.controllerEventBlocksActionClass;
        this.controllerEventBlocksActionClass = null;
        out.defaultWriteObject();
        this.controllerEventBlocksActionClass = save;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.compileEventBlocksActionClass(Gate.getClassLoader());
    }

    private void compileEventBlocksActionClass(GateClassLoader classloader) {
        String sourceCode = this.generateControllerEventBlocksCode("japeactionclasses", "");
        if (sourceCode != null) {
            HashMap<String, String> actionClasses = new HashMap<String, String>(1);
            actionClasses.put(this.controllerEventBlocksActionClassName, sourceCode);
            try {
                Javac.loadClasses(actionClasses, (GateClassLoader)classloader);
                this.controllerEventBlocksActionClass = classloader.loadClass(this.controllerEventBlocksActionClassName).newInstance();
            }
            catch (Exception e1) {
                throw new GateRuntimeException((Throwable)e1);
            }
        }
    }

    public ControllerEventBlocksAction getControllerEventBlocksActionClass() {
        return (ControllerEventBlocksAction)this.controllerEventBlocksActionClass;
    }

    private static final class FSMMatcherResult {
        private List<FSMInstance> acceptingFSMInstances;
        private List<FSMInstance> activeFSMInstances;

        public FSMMatcherResult(List<FSMInstance> activeFSMInstances, List<FSMInstance> acceptingFSMInstances) {
            this.activeFSMInstances = activeFSMInstances;
            this.acceptingFSMInstances = acceptingFSMInstances;
        }
    }

    protected static class SearchState {
        Node startNode;
        long startNodeOff;
        long oldStartNodeOff;

        SearchState(Node startNode, long startNodeOff, long oldStartNodeOff) {
            this.startNode = startNode;
            this.startNodeOff = startNodeOff;
            this.oldStartNodeOff = oldStartNodeOff;
        }
    }
}

