/*
 * Decompiled with CFR 0.152.
 */
package gate.jape;

import gate.jape.ComplexPatternElement;
import gate.jape.ConstraintGroup;
import gate.jape.JapeConstants;
import gate.jape.JapeException;
import gate.util.Strings;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class LeftHandSide
implements JapeConstants,
Serializable {
    private static final long serialVersionUID = -188265607327929863L;
    private ConstraintGroup constraintGroup;
    private Map<String, ComplexPatternElement> bindingTable;

    public LeftHandSide(ConstraintGroup constraintGroup) {
        this.constraintGroup = constraintGroup;
        this.bindingTable = new HashMap<String, ComplexPatternElement>();
    }

    public void addBinding(String bindingName, ComplexPatternElement binding, Set<String> bindingNameSet) throws JapeException {
        if (this.bindingTable.get(bindingName) != null) {
            throw new JapeException("LeftHandSide.addBinding: " + bindingName + " already bound");
        }
        this.bindingTable.put(bindingName, binding);
        bindingNameSet.add(bindingName);
    }

    public void finish() {
        this.constraintGroup.finish();
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String pad) {
        String newline = Strings.getNl();
        String newPad = Strings.addPadding((String)pad, (int)4);
        StringBuffer buf = new StringBuffer(pad + "; constraintGroup(" + newline + this.constraintGroup.toString(newPad) + newline + pad + "); bindingTable(" + newline + pad);
        for (Map.Entry<String, ComplexPatternElement> entry : this.bindingTable.entrySet()) {
            buf.append(pad + "bT.bn(" + entry.getKey() + "), cpe.bn(" + entry.getValue().getBindingName() + ")");
        }
        buf.append(newline + pad + ") LHS." + newline);
        return buf.toString();
    }

    public ConstraintGroup getConstraintGroup() {
        return this.constraintGroup;
    }
}

