/*
 * Decompiled with CFR 0.152.
 */
package gate.fsm;

import gate.fsm.RuleTime;
import gate.fsm.State;
import gate.fsm.Transition;
import gate.jape.BasicPatternElement;
import gate.jape.ComplexPatternElement;
import gate.jape.Constraint;
import gate.jape.ConstraintGroup;
import gate.jape.JapeConstants;
import gate.jape.KleeneOperator;
import gate.jape.LeftHandSide;
import gate.jape.PatternElement;
import gate.jape.PrioritisedRuleList;
import gate.jape.RightHandSide;
import gate.jape.Rule;
import gate.jape.SinglePhaseTransducer;
import gate.util.Benchmark;
import gate.util.SimpleArraySet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class FSM
implements JapeConstants {
    private static final long serialVersionUID = -7088856970776558801L;
    private List<RuleTime> ruleTimes = new ArrayList<RuleTime>();
    private static final boolean DEBUG = false;
    protected State currentState;
    protected Transition currentTransition;
    private State initialState;
    protected State finalState;
    private transient Collection<State> allStates = new HashSet<State>();
    private transient Map<Set<State>, State> newStates = new HashMap<Set<State>, State>();
    private transient Set<Set<State>> dStates = new HashSet<Set<State>>();
    int bpeId = 0;
    public HashMap<String, String> ruleHash = new HashMap();

    public List<RuleTime> getRuleTimes() {
        return this.ruleTimes;
    }

    private void decorateStates() {
        HashMap<String, Integer> temporaryRuleNameToIndexMap = new HashMap<String, Integer>();
        this.ruleTimes.add(new RuleTime(0L, "_____Initial_State_for_all_rules"));
        this.ruleTimes.add(new RuleTime(0L, "___UNKNOWN_RULES_TYPE_1"));
        this.ruleTimes.add(new RuleTime(0L, "___UNKNOWN_RULES_TYPE_2"));
        int ruleIndex = 0;
        for (Transition t : this.getInitialState().getTransitions()) {
            ruleIndex = t.getTarget().getRuleForState(temporaryRuleNameToIndexMap, this.ruleTimes);
            assert (ruleIndex != 2 && ruleIndex != 1);
        }
        this.getInitialState().setIndexInRuleList(0);
    }

    protected FSM() {
        this.initialState = new State();
    }

    public FSM(SinglePhaseTransducer spt) {
        this();
        this.addRules(spt.getRules());
        if (Benchmark.isBenchmarkingEnabled()) {
            this.decorateStates();
        }
    }

    protected void addRules(PrioritisedRuleList rules) {
        Iterator rulesEnum = rules.iterator();
        while (rulesEnum.hasNext()) {
            FSM ruleFSM = this.spawn((Rule)rulesEnum.next());
            this.ruleHash.putAll(ruleFSM.ruleHash);
            this.initialState.addTransition(new Transition(null, ruleFSM.getInitialState()));
        }
        this.eliminateVoidTransitions();
    }

    public FSM(Rule rule) {
        this();
        this.setRule(rule);
    }

    protected void setRule(Rule rule) {
        LeftHandSide lhs = rule.getLHS();
        LinkedList<String> ll = new LinkedList<String>();
        String label = this.currentLHSBinding(lhs);
        ll.add(label);
        this.ruleHash.put(rule.getName(), label);
        PatternElement[][] constraints = lhs.getConstraintGroup().getPatternElementDisjunction();
        State finalState = new State();
        for (int i = 0; i < constraints.length; ++i) {
            State currentRowState = this.initialState;
            for (int j = 0; j < constraints[i].length; ++j) {
                PatternElement currentPattern = constraints[i][j];
                State insulator = new State();
                currentRowState.addTransition(new Transition(null, insulator));
                currentRowState = insulator;
                if (currentPattern instanceof BasicPatternElement) {
                    State nextRowState = new State();
                    LinkedList<String> sll = new LinkedList<String>();
                    sll.add(this.currentBasicBinding((BasicPatternElement)currentPattern));
                    currentRowState.addTransition(new Transition((BasicPatternElement)currentPattern, nextRowState, sll));
                    currentRowState = nextRowState;
                    continue;
                }
                if (currentPattern instanceof ComplexPatternElement) {
                    currentRowState = this.convertComplexPE(currentRowState, (ComplexPatternElement)currentPattern, ll);
                    continue;
                }
                throw new RuntimeException("Strange looking pattern: " + currentPattern);
            }
            currentRowState.addTransition(new Transition(null, finalState));
            finalState.setAction(rule.getRHS());
            finalState.setFileIndex(rule.getPosition());
            finalState.setPriority(rule.getPriority());
        }
    }

    protected FSM(ComplexPatternElement cpe) {
        this();
        this.finalState = this.convertComplexPE(this.initialState, cpe, new LinkedList<String>());
        this.finalState.isFinal = true;
    }

    protected FSM spawn(Rule r) {
        return new FSM(r);
    }

    protected FSM spawn(ComplexPatternElement currentPattern) {
        return new FSM(currentPattern);
    }

    public State getInitialState() {
        return this.initialState;
    }

    private State convertComplexPE(State startState, ComplexPatternElement cpe, LinkedList<String> labels) {
        State endState = this.generateStates(startState, cpe, labels);
        KleeneOperator kleeneOp = cpe.getKleeneOp();
        KleeneOperator.Type type = kleeneOp.getType();
        if (type == KleeneOperator.Type.OPTIONAL) {
            startState.addTransition(new Transition(null, endState));
        } else if (type == KleeneOperator.Type.PLUS) {
            endState.addTransition(new Transition(null, startState));
        } else if (type == KleeneOperator.Type.STAR) {
            startState.addTransition(new Transition(null, endState));
            endState.addTransition(new Transition(null, startState));
        } else if (type == KleeneOperator.Type.RANGE) {
            int i;
            int numCopies;
            Integer min = kleeneOp.getMin();
            Integer max = kleeneOp.getMax();
            ArrayList<State> startStateList = new ArrayList<State>();
            if (min == null || min == 0) {
                startStateList.add(startState);
            } else if (min > 1) {
                numCopies = min - 1;
                for (i = 1; i <= numCopies; ++i) {
                    startState = endState;
                    endState = this.generateStates(startState, cpe, labels);
                }
            }
            if (max == null) {
                endState.addTransition(new Transition(null, startState));
            } else if (max > min) {
                numCopies = max - min;
                if (min == 0) {
                    --numCopies;
                }
                for (i = 1; i <= numCopies; ++i) {
                    startState = endState;
                    startStateList.add(startState);
                    endState = this.generateStates(startState, cpe, labels);
                }
            }
            for (State state : startStateList) {
                state.addTransition(new Transition(null, endState));
            }
        }
        return endState;
    }

    private State generateStates(State startState, ComplexPatternElement cpe, LinkedList<String> labels) {
        LinkedList newBindings = (LinkedList)labels.clone();
        String localLabel = cpe.getBindingName();
        if (localLabel != null) {
            newBindings.add(localLabel);
        }
        ConstraintGroup constraintGroup = cpe.getConstraintGroup();
        PatternElement[][] constraints = constraintGroup.getPatternElementDisjunction();
        State endState = new State();
        for (int i = 0; i < constraints.length; ++i) {
            State currentRowState = startState;
            for (int j = 0; j < constraints[i].length; ++j) {
                State insulator = new State();
                currentRowState.addTransition(new Transition(null, insulator));
                currentRowState = insulator;
                PatternElement currentPattern = constraints[i][j];
                if (currentPattern instanceof BasicPatternElement) {
                    State nextRowState = new State();
                    newBindings.add(this.currentBasicBinding((BasicPatternElement)currentPattern));
                    currentRowState.addTransition(new Transition((BasicPatternElement)currentPattern, nextRowState, newBindings));
                    currentRowState = nextRowState;
                    continue;
                }
                if (currentPattern instanceof ComplexPatternElement) {
                    currentRowState = this.convertComplexPE(currentRowState, (ComplexPatternElement)currentPattern, newBindings);
                    continue;
                }
                throw new RuntimeException("Strange looking pattern:" + currentPattern);
            }
            currentRowState.addTransition(new Transition(null, endState));
        }
        return endState;
    }

    public void eliminateVoidTransitions() {
        this.dStates.clear();
        LinkedList<Set<State>> unmarkedDStates = new LinkedList<Set<State>>();
        Set<State> currentDState = new HashSet<State>();
        this.newStates.clear();
        currentDState.add(this.initialState);
        currentDState = this.lambdaClosure(currentDState);
        this.dStates.add(currentDState);
        unmarkedDStates.add(currentDState);
        this.initialState = new State();
        this.newStates.put(currentDState, this.initialState);
        Iterator<State> innerStatesIter = currentDState.iterator();
        RightHandSide action = null;
        while (innerStatesIter.hasNext()) {
            State currentInnerState = innerStatesIter.next();
            if (!currentInnerState.isFinal()) continue;
            action = currentInnerState.getAction();
            this.initialState.setAction(action);
            this.initialState.setFileIndex(currentInnerState.getFileIndex());
            this.initialState.setPriority(currentInnerState.getPriority());
            break;
        }
        while (!unmarkedDStates.isEmpty()) {
            currentDState = (Set)unmarkedDStates.removeFirst();
            for (State innerState : currentDState) {
                for (Transition currentTrans : innerState.getTransitions()) {
                    if (currentTrans.getConstraints() == null) continue;
                    State target = currentTrans.getTarget();
                    Set<State> newDState = new HashSet<State>();
                    newDState.add(target);
                    newDState = this.lambdaClosure(newDState);
                    if (!this.dStates.contains(newDState)) {
                        this.dStates.add(newDState);
                        unmarkedDStates.add(newDState);
                        State newState = new State();
                        this.newStates.put(newDState, newState);
                        for (State currentInnerState : newDState) {
                            if (!currentInnerState.isFinal()) continue;
                            newState.setAction(currentInnerState.getAction());
                            newState.setFileIndex(currentInnerState.getFileIndex());
                            newState.setPriority(currentInnerState.getPriority());
                            break;
                        }
                    }
                    State currentState = this.newStates.get(currentDState);
                    State newState = this.newStates.get(newDState);
                    currentState.addTransition(new Transition(currentTrans.getConstraints(), newState, currentTrans.getBindings()));
                }
            }
        }
        this.allStates = this.newStates.values();
    }

    private Set<State> lambdaClosure(Set<State> s) {
        LinkedList<State> list = new LinkedList<State>(s);
        HashSet<State> lambdaClosure = new HashSet<State>(s);
        while (!list.isEmpty()) {
            State top = list.removeFirst();
            for (Transition currentTransition : top.getTransitions()) {
                State currentState;
                if (currentTransition.getConstraints() != null || lambdaClosure.contains(currentState = currentTransition.getTarget())) continue;
                lambdaClosure.add(currentState);
                list.addFirst(currentState);
            }
        }
        return lambdaClosure;
    }

    protected void forEachState(Runnable r) {
        HashSet<State> stackToProcess = new HashSet<State>();
        HashSet<State> processed = new HashSet<State>();
        stackToProcess.add(this.initialState);
        while (!stackToProcess.isEmpty()) {
            this.currentState = (State)stackToProcess.iterator().next();
            stackToProcess.remove(this.currentState);
            processed.add(this.currentState);
            Iterator iterator = this.currentState.getTransitions().iterator();
            while (iterator.hasNext()) {
                Transition t;
                this.currentTransition = t = (Transition)iterator.next();
                State target = this.currentTransition.getTarget();
                if (processed.contains(target) || stackToProcess.contains(target)) continue;
                stackToProcess.add(target);
                r.run();
            }
        }
    }

    public Map<State, SimpleArraySet<Transition>> getAllStates() {
        HashMap<State, SimpleArraySet<Transition>> statesToReturn = new HashMap<State, SimpleArraySet<Transition>>();
        HashSet<State> stackToProcess = new HashSet<State>();
        HashSet<State> processed = new HashSet<State>();
        stackToProcess.add(this.initialState);
        while (!stackToProcess.isEmpty()) {
            this.currentState = (State)stackToProcess.iterator().next();
            stackToProcess.remove(this.currentState);
            processed.add(this.currentState);
            SimpleArraySet<Transition> transitions = this.currentState.getTransitions();
            statesToReturn.put(this.currentState, transitions);
            for (Transition this.currentTransition : transitions) {
                State target = this.currentTransition.getTarget();
                if (processed.contains(target) || stackToProcess.contains(target)) continue;
                stackToProcess.add(target);
            }
        }
        return statesToReturn;
    }

    public String asGraphViz(boolean includeConstraints) {
        StringBuffer result = new StringBuffer();
        result.append("digraph G {\n");
        for (State currentState : this.getAllStates().keySet()) {
            int stateIndex = currentState.getIndex();
            HashMap<String, String> opts = new HashMap<String, String>();
            opts.put("shape", currentState == this.initialState ? "diamond" : "circle");
            opts.put("color", currentState == this.initialState ? "green" : (currentState.isFinal() ? "red" : "black"));
            if (currentState.isFinal()) {
                opts.put("peripheries", "2");
            }
            result.append("  " + stateIndex + " [" + this.encodeForGraphViz(opts) + "];\n");
            for (Transition t : currentState.getTransitions()) {
                String extraText = includeConstraints ? " [label=\"" + t.toString(false) + "\"]" : "";
                result.append("  " + stateIndex + " -> " + t.getTarget().getIndex() + extraText + ";\n");
            }
        }
        result.append("}\n");
        return result.toString();
    }

    String encodeForGraphViz(Map<String, String> m) {
        ArrayList<String> temp = new ArrayList<String>(m.size());
        for (Map.Entry<String, String> entry : m.entrySet()) {
            String v = entry.getValue();
            v = v.replaceAll("\r\n", "\\\\l");
            v = v.replaceAll("\"", "\\\\\"");
            temp.add(entry.getKey() + "=\"" + v + "\"");
        }
        StringBuffer toReturn = new StringBuffer();
        for (int i = 0; i < temp.size(); ++i) {
            if (i != 0) {
                toReturn.append(",");
            }
            toReturn.append((String)temp.get(i));
        }
        return toReturn.toString();
    }

    public String getGML() {
        String res = "graph[ \ndirected 1\n";
        StringBuffer nodes = new StringBuffer(1024);
        StringBuffer edges = new StringBuffer(1024);
        for (State currentState : this.allStates) {
            int stateIndex = currentState.getIndex();
            nodes.append("node[ id ");
            nodes.append(stateIndex);
            nodes.append(" label \"");
            nodes.append(stateIndex);
            if (currentState.isFinal()) {
                nodes.append(",F\\n" + currentState.getAction().shortDesc());
            }
            nodes.append("\"  ]\n");
            edges.append(currentState.getEdgesGML());
        }
        res = res + nodes.toString() + edges.toString() + "]\n";
        return res;
    }

    public String toString() {
        StringBuffer res = new StringBuffer("Starting from:").append(this.initialState.getIndex()).append("\n");
        Iterator<State> stateIter = this.allStates.iterator();
        while (stateIter.hasNext()) {
            res.append("\n\n").append(stateIter.next());
        }
        return res.toString();
    }

    private String currentBinding(ComplexPatternElement cpe, int indent) {
        if (indent == 0) {
            this.bpeId = 0;
        }
        String ind = StringUtils.repeat((char)' ', (int)indent);
        String binds = ind + "(\n";
        PatternElement[][] pe = cpe.getConstraintGroup().getPatternElementDisjunction();
        for (int i = 0; i < pe.length; ++i) {
            PatternElement[] patternElements = pe[i];
            for (int j = 0; j < patternElements.length; ++j) {
                PatternElement patternElement = patternElements[j];
                if (patternElement instanceof ComplexPatternElement) {
                    ComplexPatternElement complexPatternElement = (ComplexPatternElement)patternElement;
                    binds = binds + this.currentBinding(complexPatternElement, indent + 1);
                    continue;
                }
                binds = binds + ind + "   ";
                binds = binds + this.currentBasicBinding((BasicPatternElement)patternElement);
                binds = binds + "\n";
            }
            binds = binds + ind + "   |\n";
        }
        binds = binds.substring(0, binds.length() - 5);
        binds = binds + ")" + cpe.getKleeneOp().toString() + "\n";
        if (indent == 0) {
            this.bpeId = 0;
        }
        return binds;
    }

    private String currentBasicBinding(BasicPatternElement bpe) {
        StringBuilder sb = new StringBuilder("{");
        Constraint[] cons = bpe.getConstraints();
        for (int k = 0; k < cons.length; ++k) {
            sb.append(cons[k].getDisplayString(""));
            if (k >= cons.length - 1) continue;
            sb.append(",");
        }
        sb.append("}").append(" *").append(this.bpeId++).append("*");
        return sb.toString();
    }

    private String currentLHSBinding(LeftHandSide lhs) {
        String binds = "(\n";
        PatternElement[][] pe = lhs.getConstraintGroup().getPatternElementDisjunction();
        for (int i = 0; i < pe.length; ++i) {
            PatternElement[] patternElements = pe[i];
            for (int j = 0; j < patternElements.length; ++j) {
                PatternElement patternElement = patternElements[j];
                if (patternElement instanceof ComplexPatternElement) {
                    ComplexPatternElement complexPatternElement = (ComplexPatternElement)patternElement;
                    binds = binds + this.currentBinding(complexPatternElement, 1);
                    continue;
                }
                binds = binds + "   ";
                binds = binds + this.currentBasicBinding((BasicPatternElement)patternElement);
                binds = binds + "\n";
            }
            binds = binds + "   |\n";
        }
        binds = binds.substring(0, binds.length() - 5);
        binds = binds + ")\n";
        this.bpeId = 0;
        return binds;
    }
}

