/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.gazetteer;

import gate.creole.gazetteer.InvalidFormatException;
import java.util.ArrayList;

public class LinearNode {
    private String list;
    private String minor;
    private String major;
    private String language;
    private String annotationType;

    public LinearNode(String list, String minor, String major, String language, String annotationType) {
        this.list = list;
        this.minor = minor;
        this.major = major;
        this.language = language;
        this.annotationType = annotationType;
    }

    public LinearNode(String aList, String aMajor, String aMinor, String aLanguage) {
        this(aList, aMajor, aMinor, aLanguage, null);
    }

    public LinearNode(String node) throws InvalidFormatException {
        int firstColon = node.indexOf(58);
        int secondColon = node.indexOf(58, firstColon + 1);
        int thirdColon = node.indexOf(58, secondColon + 1);
        int fourthColon = node.indexOf(58, thirdColon + 1);
        this.annotationType = "Lookup";
        if (firstColon == -1) {
            throw new InvalidFormatException("", "Line: " + node);
        }
        this.list = node.substring(0, firstColon);
        if (secondColon == -1) {
            this.major = node.substring(firstColon + 1);
            this.minor = null;
            this.language = null;
        } else {
            this.major = node.substring(firstColon + 1, secondColon);
            if (thirdColon == -1) {
                this.minor = node.substring(secondColon + 1);
                this.language = null;
            } else {
                this.minor = node.substring(secondColon + 1, thirdColon);
                if (fourthColon == -1) {
                    this.language = node.substring(thirdColon + 1);
                    this.annotationType = "Lookup";
                } else {
                    this.language = node.substring(thirdColon + 1, fourthColon);
                    this.annotationType = node.substring(fourthColon + 1);
                }
            }
        }
    }

    public String getList() {
        return this.list;
    }

    public void setList(String aList) {
        this.list = aList;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String aLanguage) {
        this.language = aLanguage;
    }

    public String getMinorType() {
        return this.minor;
    }

    public void setMinorType(String minorType) {
        this.minor = minorType;
    }

    public String getMajorType() {
        return this.major;
    }

    public void setMajorType(String majorType) {
        this.major = majorType;
    }

    public String getAnnotationType() {
        return this.annotationType;
    }

    public void setAnnotationType(String annotationType) {
        this.annotationType = annotationType;
    }

    public String toString() {
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(this.list);
        parts.add(this.major);
        parts.add(this.minor != null ? this.minor.trim() : "");
        parts.add(this.language != null ? this.language.trim() : "");
        parts.add(this.annotationType != null && !this.annotationType.equals("Lookup") ? this.annotationType.trim() : "");
        for (int i = parts.size() - 1; i > 0 && ((String)parts.get(i)).equals(""); --i) {
            parts.remove(i);
        }
        return String.join((CharSequence)":", parts);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.annotationType == null ? 0 : this.annotationType.hashCode());
        result = 31 * result + (this.language == null ? 0 : this.language.hashCode());
        result = 31 * result + (this.list == null ? 0 : this.list.hashCode());
        result = 31 * result + (this.major == null ? 0 : this.major.hashCode());
        result = 31 * result + (this.minor == null ? 0 : this.minor.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LinearNode other = (LinearNode)obj;
        if (this.annotationType == null ? other.annotationType != null : !this.annotationType.equals(other.annotationType)) {
            return false;
        }
        if (this.language == null ? other.language != null : !this.language.equals(other.language)) {
            return false;
        }
        if (this.list == null ? other.list != null : !this.list.equals(other.list)) {
            return false;
        }
        if (this.major == null ? other.major != null : !this.major.equals(other.major)) {
            return false;
        }
        return !(this.minor == null ? other.minor != null : !this.minor.equals(other.minor));
    }
}

