/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.gazetteer;

import gate.creole.AbstractLanguageAnalyser;
import gate.creole.ResourceInstantiationException;
import gate.creole.ResourceReference;
import gate.creole.gazetteer.Gazetteer;
import gate.creole.gazetteer.GazetteerEvent;
import gate.creole.gazetteer.GazetteerListener;
import gate.creole.gazetteer.LinearDefinition;
import gate.creole.gazetteer.MappingDefinition;
import gate.creole.metadata.CreoleParameter;
import gate.creole.metadata.Optional;
import gate.creole.metadata.RunTime;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractGazetteer
extends AbstractLanguageAnalyser
implements Gazetteer {
    private static final long serialVersionUID = 223125105523762358L;
    protected Set<GazetteerListener> listeners = new HashSet<GazetteerListener>();
    protected String annotationSetName;
    protected String encoding = "UTF-8";
    protected ResourceReference listsURL;
    protected Boolean caseSensitive;
    protected Boolean wholeWordsOnly;
    protected Boolean longestMatchOnly;
    protected LinearDefinition definition;
    protected MappingDefinition mappingDefinition;

    @Override
    @RunTime
    @Optional
    @CreoleParameter(comment="The annotation set to be used for the generated annotations")
    public void setAnnotationSetName(String newAnnotationSetName) {
        this.annotationSetName = newAnnotationSetName;
    }

    @Override
    public String getAnnotationSetName() {
        return this.annotationSetName;
    }

    @Override
    @CreoleParameter(comment="The encoding used for reading the definitions", defaultValue="UTF-8")
    public void setEncoding(String newEncoding) {
        this.encoding = newEncoding;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public ResourceReference getListsURL() {
        return this.listsURL;
    }

    @Override
    @CreoleParameter(comment="The URL to the file with list of lists", suffixes="def", defaultValue="resources/gazetteer/lists.def")
    public void setListsURL(ResourceReference newListsURL) {
        this.listsURL = newListsURL;
    }

    @Override
    @Deprecated
    public void setListsURL(URL lists) {
        try {
            this.setListsURL(new ResourceReference(lists));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Error converting URL to ResourceReference", e);
        }
    }

    @Override
    @CreoleParameter(comment="Should this gazetteer diferentiate on case?", defaultValue="true")
    public void setCaseSensitive(Boolean newCaseSensitive) {
        this.caseSensitive = newCaseSensitive;
    }

    @Override
    public Boolean getCaseSensitive() {
        return this.caseSensitive;
    }

    @Override
    public void setMappingDefinition(MappingDefinition mapping) {
        this.mappingDefinition = mapping;
    }

    @Override
    public MappingDefinition getMappingDefinition() {
        return this.mappingDefinition;
    }

    public Boolean getLongestMatchOnly() {
        return this.longestMatchOnly;
    }

    @RunTime
    @CreoleParameter(comment="Should this gazetteer only match the longest string starting from any offset?", defaultValue="true")
    public void setLongestMatchOnly(Boolean longestMatchOnly) {
        this.longestMatchOnly = longestMatchOnly;
    }

    @Override
    public LinearDefinition getLinearDefinition() {
        return this.definition;
    }

    public void reInit() throws ResourceInstantiationException {
        super.reInit();
        this.fireGazetteerEvent(new GazetteerEvent(this, 1));
    }

    @Override
    public void fireGazetteerEvent(GazetteerEvent ge) {
        for (GazetteerListener gl : this.listeners) {
            gl.processGazetteerEvent(ge);
        }
    }

    @Override
    public void addGazetteerListener(GazetteerListener gl) {
        if (null != gl) {
            this.listeners.add(gl);
        }
    }

    public Boolean getWholeWordsOnly() {
        return this.wholeWordsOnly;
    }

    @RunTime
    @CreoleParameter(comment="Should this gazetteer only match whole words?", defaultValue="true")
    public void setWholeWordsOnly(Boolean wholeWordsOnly) {
        this.wholeWordsOnly = wholeWordsOnly;
    }
}

